/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryDefinition;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryTypeRegistry;
import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementDeltaVisitor;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.IPlanElementVisitor;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanData;
import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.util.Tags;
import com.ibm.team.apt.internal.common.IterationPlanNoCategoriesException;
import com.ibm.team.apt.internal.common.Iterations;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.ide.core.util.ITeamFutureListener;
import com.ibm.team.apt.internal.ide.core.util.StateResolveEvent;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.IActionProvider;
import com.ibm.team.apt.internal.ide.ui.common.IMarker;
import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.OutlineSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.common.PlanOpenListener;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUnlockedRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModel;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelContentProvider;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewerSorter;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryBar;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryColorizer;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryEntryFilter;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryEntryFinder;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.PartialViewerSorter;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.SortMode;
import com.ibm.team.apt.internal.ide.ui.editor.FilterSelectionDialog;
import com.ibm.team.apt.internal.ide.ui.editor.IterationPlanEditor;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.PlanEditorPage;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeDescription;
import com.ibm.team.apt.internal.ide.ui.editor.PlanModeState;
import com.ibm.team.apt.internal.ide.ui.editor.PreviewPane;
import com.ibm.team.apt.internal.ide.ui.editor.QueryDescriptor;
import com.ibm.team.apt.internal.ide.ui.editor.StatusComposite;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.FilterUsageStatistics;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IPlanOutlineSettings;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IUsageChangeListener;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IterationPlanViewModel;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutlineFilterDescriptor;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutlineViewerFilter;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutline;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutlineViewer;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.ProgressMode;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.TagFilterDescriptor;
import com.ibm.team.apt.internal.ide.ui.jface.CheckboxLabelAdapter;
import com.ibm.team.apt.internal.ide.ui.jface.CheckboxListViewer;
import com.ibm.team.apt.internal.ide.ui.jface.StructuredContentProvider;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.AnimatedLoadingLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.Line;
import com.ibm.team.apt.internal.ide.ui.widgets.ScrolledButtonComposite;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GDeferredImage;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLink;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGObject;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditor;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.IGadgetEditorActivationListener;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineColumn;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.GradientUtilities;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.common.model.TagsAttributeType;
import com.ibm.team.workitem.rcp.ui.QueriesUI;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlinePage
extends PlanEditorPage
implements IActionProvider {
    public static final String ID = "com.ibm.team.apt.ui.IterationPlanEditor.PlannedItemsPage";
    private static final String SORT_BY_LABEL = Messages.OutlinePage_SORT_BY;
    private static final String SEMI_SORT_BY_LABEL = NLS.bind((String)"{0} (<a>{1}</a>)", (Object[])new Object[]{Messages.OutlinePage_SEMI_SORT_BY, Messages.OutlinePage_RESORT});
    private static final String PAGE_TITLE = Messages.OutlinePage_OUTLINE_PAGE_NAME;
    private IterationPlanData fIterationPlanData;
    private volatile TeamFuture<ResolvedIterationPlan> fFuture;
    private ResolvedIterationPlan fIterationPlan;
    private IterationPlanListener fIterationPlanListener;
    private Map<String, PlanModeState> fAllModeSettings = new HashMap<String, PlanModeState>();
    private PlanModeState fModeSettings;
    private String fDefaultModeId;
    private PlanItemOutlineViewer fOutlineViewer;
    private OutlineViewerFilter fViewerFilter;
    private PartialViewerSorter fSorter;
    private IterationPlanViewModel fViewModel;
    private Set<String> fKnownTags;
    private Map<String, OutlineFilterDescriptor> fFilterCache;
    private ResourceManager fResourceManager;
    private List<IOutlineSettingsListener> fAttachedSettingListeners = new ArrayList<IOutlineSettingsListener>();
    private Control fActivePart;
    private PlanItemOutline fOutline;
    private Composite fSideBar;
    private QuickQueryBar fQuickSearch;
    private CheckboxListViewer fQuickFilterList;
    private ComboViewer fGroupModeViewer;
    private ComboViewer fSortModeViewer;
    private Link fSortByLabel;
    private boolean fIsDisposed;
    private StackLayout fStack;
    private Composite fOutlineComposite;
    private AnimatedLoadingLabel fLoadingLabel;
    private FailureInfo fFailureInfo;
    private IQuickQueryDefinition fQuickQueryDefinition;
    private boolean fIsReadModeEnabled;
    private PreviewPane fPreviewPane;
    private IUsageChangeListener fFilterRankingListener = new IUsageChangeListener(){

        public void filterRankingChanged() {
            Control control = OutlinePage.this.fQuickFilterList.getControl();
            if (control != null && !control.isDisposed()) {
                OutlinePage.this.fQuickFilterList.refresh();
            }
        }
    };
    private final SettingsDelegate fSettingsDelegate = new SettingsDelegate();
    private String fContextId = "com.ibm.team.apt.actions.iterationPlanEditor.outline";
    private static final String OUTLINE_PAGE = "outlinePage";
    private boolean fDirty = false;

    public OutlinePage(FormEditor editor, PlanModeDescription[] planModes, String defaultModeId, IMemento uiState) {
        super(editor, ID, PAGE_TITLE);
        this.fDefaultModeId = defaultModeId;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.fQuickQueryDefinition = QuickQueryTypeRegistry.getQuickQueryDefinition("com.ibm.team.apt.ide.ui.mywork.quickfilter");
        PlanModeDescription[] planModeDescriptionArray = planModes;
        int n = planModes.length;
        int n2 = 0;
        while (n2 < n) {
            PlanModeDescription planMode = planModeDescriptionArray[n2];
            this.fAllModeSettings.put(planMode.getId(), new PlanModeState(this, planMode));
            ++n2;
        }
        this.loadState(uiState);
    }

    protected void createFormContent(IManagedForm managedForm) {
        Composite parent = managedForm.getForm().getBody();
        this.fStack = new StackLayout();
        this.fStack.marginWidth = 0;
        this.fStack.marginHeight = 0;
        parent.setLayout((Layout)this.fStack);
        if (this.fFailureInfo == null) {
            this.fLoadingLabel = new AnimatedLoadingLabel(parent, 0);
            this.fLoadingLabel.setFont(JFaceResources.getHeaderFont());
            this.fOutlineComposite = new Composite(parent, 0);
            if (this.fIterationPlan != null) {
                this.fStack.topControl = this.fOutlineComposite;
                parent.layout();
                this.setResolvedIterationPlan(this.fIterationPlan);
            } else {
                this.fLoadingLabel.start(0);
                this.fStack.topControl = this.fLoadingLabel;
                parent.layout();
            }
        } else {
            this.createFailurePage(parent);
        }
        UI.hookHelpListener((Control)parent, "com.ibm.team.apt.ide.ui.page_plannedItems");
    }

    public void dispose() {
        if (this.fQuickSearch != null) {
            this.fQuickSearch.dispose();
        }
        if (this.fPreviewPane != null) {
            this.fPreviewPane.dispose();
        }
        if (this.fViewModel != null) {
            this.fViewModel.dispose();
        }
        if (this.fViewerFilter != null) {
            this.fViewerFilter.dispose();
        }
        if (this.fIterationPlanListener != null) {
            this.fIterationPlan.removeListener((IPlanElementListener)this.fIterationPlanListener);
        }
        this.fResourceManager.dispose();
        for (IOutlineSettingsListener listener : this.fAttachedSettingListeners) {
            this.getPlanOutlineSettings().removeSettingsChangeListener(listener);
        }
        PlanningUIPlugin.getDefault().getFilterUsageStatistics().removeUsageChangeListener(this.fFilterRankingListener);
        this.fIsDisposed = true;
        super.dispose();
    }

    @Override
    public void aboutToSave() {
        if (this.fModeSettings != null) {
            this.fModeSettings.getGroupMode().aboutToSave();
        }
    }

    public void setFocus() {
        if (this.fOutline != null) {
            this.fOutline.setFocus();
            return;
        }
        super.setFocus();
    }

    @Override
    public Action getAction(String id) {
        Action result = null;
        if (this.fQuickSearch != null && (this.fActivePart == this.fQuickSearch.getControl() || this.fActivePart == this.fOutline || this.fActivePart == this.fSideBar) && (result = this.fQuickSearch.getAction(id)) != null) {
            return result;
        }
        if (this.fViewModel != null && (this.fActivePart == this.fOutline || this.fActivePart == this.fSideBar)) {
            result = this.fViewModel.getAction(id);
        } else if (this.fPreviewPane != null && this.fActivePart == this.fPreviewPane.getControl()) {
            result = this.fPreviewPane.getAction(id);
        }
        return result;
    }

    public void setInput(IterationPlanData data) {
        Assert.isTrue((boolean)Thread.currentThread().equals(this.getIterationPlanEditor().getSite().getShell().getDisplay().getThread()));
        this.fIterationPlanData = data;
        if (this.fStack != null) {
            this.fLoadingLabel.start(0);
            this.fStack.topControl = this.fLoadingLabel;
            this.getManagedForm().getForm().getBody().layout();
        }
        this.setBusy(true);
        if (this.fFuture != null) {
            this.fFuture.cancel();
        }
        this.fFailureInfo = null;
        ITeamFutureListener<ResolvedIterationPlan> teamFutureListener = new ITeamFutureListener<ResolvedIterationPlan>(){

            public void stateResolved(StateResolveEvent<ResolvedIterationPlan> event) {
            }

            public void resolvingDone(final TeamFutureEvent<ResolvedIterationPlan> event) {
                event.getTeamFuture().removeListener((ITeamFutureListener)this);
                OutlinePage.this.getIterationPlanEditor().syncExec(new Runnable(){

                    public void run() {
                        OutlinePage.this.setResolvedIterationPlan((ResolvedIterationPlan)event.getTeamFuture().getResult());
                        OutlinePage.this.fFuture = null;
                    }
                });
            }

            public void resolvingFailed(final TeamFutureEvent<ResolvedIterationPlan> event) {
                event.getTeamFuture().removeListener((ITeamFutureListener)this);
                OutlinePage.this.getIterationPlanEditor().syncExec(new Runnable(){

                    public void run() {
                        OutlinePage.this.doResolvingFailed((TeamFutureEvent<ResolvedIterationPlan>)event);
                        OutlinePage.this.fFuture = null;
                    }
                });
            }

            public void resolvingCanceled(TeamFutureEvent<ResolvedIterationPlan> event) {
                OutlinePage.this.fFuture = null;
            }
        };
        this.fFuture = new TeamFuture<ResolvedIterationPlan>(true, (ITeamFutureListener)teamFutureListener){

            protected ResolvedIterationPlan resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor.beginTask("", 2);
                IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)OutlinePage.this.fIterationPlanData.getTeamRepository());
                ResolvedIterationPlan result = client.fetchIterationPlan(OutlinePage.this.fIterationPlanData, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                result.connect((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return result;
            }
        };
        this.fFuture.addListener((ITeamFutureListener)teamFutureListener);
    }

    public Composite getSideBar() {
        return this.fSideBar;
    }

    public IterationPlanViewModel getViewModel() {
        return this.fViewModel;
    }

    public void setPlanMode(String planModeId) {
        PlanModeState newState = this.fAllModeSettings.get(planModeId);
        if (newState == null) {
            throw new IllegalArgumentException(NLS.bind((String)"Unknown plan mode: {0}", (Object[])new Object[]{planModeId}));
        }
        if (this.fIterationPlan != null) {
            this.doSetMode(newState);
        } else {
            this.fDefaultModeId = planModeId;
        }
    }

    public TeamFuture<ResolvedIterationPlan> getFuture() {
        return this.fFuture;
    }

    public boolean toggleReadMode() {
        boolean bl = this.fIsReadModeEnabled = !this.fIsReadModeEnabled;
        if (this.fPreviewPane != null) {
            this.fPreviewPane.setVisible(this.fIsReadModeEnabled);
            if (this.fIsReadModeEnabled) {
                this.fModeSettings.setShowDetails(false);
            } else {
                this.fModeSettings.setShowDetails(true);
            }
        }
        return this.fIsReadModeEnabled;
    }

    public void setPlanOutlineSettingsDEBUG(boolean showDescription, boolean showDetails, String groupModeId, String sortModeId, String[] filterIds) {
        PlanModeDescription modeDescription = this.fModeSettings.getPlanMode();
        GroupByDescription groupMode = null;
        GroupByDescription[] groupByDescriptionArray = modeDescription.getGroupModes();
        int n = groupByDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            GroupByDescription mode = groupByDescriptionArray[n2];
            if (groupModeId.equals(mode.getId())) {
                groupMode = mode;
                break;
            }
            ++n2;
        }
        if (groupModeId == null) {
            throw new IllegalArgumentException(NLS.bind((String)"Unknown group mode: {0}", (Object[])new Object[]{groupModeId}));
        }
        SortMode sortMode = SortMode.getSortMode(sortModeId);
        if (sortMode == null) {
            throw new IllegalArgumentException(NLS.bind((String)"Unknown sort mode: {0} ", (Object[])new Object[]{sortModeId}));
        }
        ArrayList<OutlineFilterDescriptor> filters = new ArrayList<OutlineFilterDescriptor>();
        String[] stringArray = filterIds;
        int n3 = filterIds.length;
        int n4 = 0;
        while (n4 < n3) {
            String filterId = stringArray[n4];
            OutlineFilterDescriptor filter = this.fFilterCache.get(filterId);
            if (filter != null) {
                filters.add(filter);
            }
            ++n4;
        }
        this.fModeSettings.setShowDetails(showDetails);
        this.fModeSettings.setGroupMode(groupMode);
        this.fModeSettings.setSortMode(sortMode);
        this.fModeSettings.setFilters(filters.toArray(new OutlineFilterDescriptor[filters.size()]), OutlineFilterDescriptor.FilterType.ALL);
        this.fViewModel.refreshFilters();
    }

    private void setResolvedIterationPlan(ResolvedIterationPlan plan) {
        if (this.fIsDisposed) {
            return;
        }
        boolean inputExists = this.fIterationPlan != null;
        ISelection selection = null;
        OutlineModel.ExpansionHull expansionHull = null;
        int scrollX = 0;
        int scrollY = 0;
        if (inputExists) {
            this.fIterationPlan.removeListener((IPlanElementListener)this.fIterationPlanListener);
            this.fIterationPlanData.setIterationPlan(null);
            if (this.fOutlineViewer != null) {
                selection = this.fOutlineViewer.getSelection();
                expansionHull = this.fViewModel.getExpansionHull();
                scrollX = this.fOutline.getTransformation().getX();
                scrollY = this.fOutline.getTransformation().getY();
            }
        }
        this.fIterationPlan = plan;
        this.fIterationPlanData.setIterationPlan(this.fIterationPlan);
        if (this.fOutlineViewer == null && this.getManagedForm() != null) {
            this.createOutliner();
            this.initializeOutliner();
        } else if (this.fViewModel != null) {
            this.fViewModel.setInput((ResolvedPlan)this.fIterationPlan);
        }
        if (!inputExists) {
            this.fIterationPlanListener = new IterationPlanListener();
        } else if (this.fOutlineViewer != null) {
            if (expansionHull != null) {
                this.fOutlineViewer.collapseAll();
                this.fViewModel.setExpansionHull(expansionHull);
            }
            if (selection != null) {
                this.fOutlineViewer.setSelection(selection);
                this.fOutline.scroll(scrollX, scrollY);
            }
        }
        this.fIterationPlan.addListener((IPlanElementListener)this.fIterationPlanListener);
        this.setBusy(false);
        if (this.fLoadingLabel != null) {
            this.fLoadingLabel.stop();
        }
        if (this.fOutline != null) {
            this.fStack.topControl = this.fOutlineComposite;
            this.getManagedForm().getForm().getBody().layout();
        }
        this.fIterationPlan.triggerProblemCalculation();
        if (plan.isDirty()) {
            this.setDirtyPartName();
        } else {
            this.setSavedPartName();
        }
        if (plan.isDirty()) {
            this.setDirtyPartName();
        } else {
            this.setSavedPartName();
        }
        this.setFocus();
    }

    private void doResolvingFailed(TeamFutureEvent<ResolvedIterationPlan> event) {
        if (this.fIsDisposed) {
            return;
        }
        this.setBusy(false);
        if (this.fLoadingLabel != null) {
            this.fLoadingLabel.stop();
        }
        TeamFuture teamFuture = event.getTeamFuture();
        this.fFailureInfo = new FailureInfo(teamFuture.getException(), teamFuture.getStatus());
        if (this.getManagedForm() != null) {
            this.createFailurePage(this.getManagedForm().getForm().getBody());
        }
    }

    private void createFailurePage(Composite parent) {
        StatusComposite statusPresenter = new StatusComposite(parent, 0);
        TeamRepositoryException exception = this.fFailureInfo.exception;
        if (exception != null) {
            if (exception instanceof IterationPlanNoCategoriesException) {
                statusPresenter.setStatus((IStatus)new Status(1, PlanningUIPlugin.getPluginId(), NLS.bind((String)Messages.OutlinePage_ERROR_NO_CATEGORIES, (Object[])new Object[]{this.fIterationPlanData.getTeamArea().getName()})), Messages.OutlinePage_NO_CATEGORIES_HELP_MESSAGE, (SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ITeamArea teamArea = OutlinePage.this.fIterationPlanData.getTeamArea();
                        IProjectAreaHandle handle = teamArea.getProjectArea();
                        Location location = Location.itemLocation((IItemHandle)handle, (String)OutlinePage.this.fIterationPlanData.getTeamRepository().getRepositoryURI());
                        Hyperlinks.open((URI)location.toAbsoluteUri(), null);
                    }
                });
            } else if (exception instanceof NotLoggedInException) {
                statusPresenter.setStatus((IStatus)new Status(1, PlanningUIPlugin.getPluginId(), Messages.OutlinePage_ERROR_NOT_LOGGED_IN));
            } else {
                PlanningUIPlugin.log(exception);
                statusPresenter.setStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), exception.getMessage(), (Throwable)exception));
            }
        } else {
            IStatus status = this.fFailureInfo.status;
            if (status != null && !status.isOK()) {
                PlanningUIPlugin.log(status);
                statusPresenter.setStatus(status);
            } else {
                statusPresenter.setStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), Messages.OutlinePage_ERROR_LOADING_FAILED));
            }
        }
        this.fStack.topControl = statusPresenter;
        parent.layout();
    }

    public IPlanOutlineSettings getPlanOutlineSettings() {
        return this.fSettingsDelegate;
    }

    private void doSetMode(PlanModeState mode) {
        int n;
        int n2;
        OutlineFilterDescriptor[] outlineFilterDescriptorArray;
        if (this.fViewModel == null) {
            return;
        }
        if (mode.equals(this.fModeSettings)) {
            return;
        }
        if (this.fModeSettings != null) {
            this.fModeSettings.removeSettingsChangeListener(this.fSettingsDelegate);
            HashMap<String, OutlineFilterDescriptor> newFilterCache = new HashMap<String, OutlineFilterDescriptor>();
            outlineFilterDescriptorArray = this.getTagFilters();
            n2 = outlineFilterDescriptorArray.length;
            n = 0;
            while (n < n2) {
                OutlineFilterDescriptor tagFilter = outlineFilterDescriptorArray[n];
                newFilterCache.put(tagFilter.getId(), tagFilter);
                ++n;
            }
            this.fFilterCache = newFilterCache;
        }
        this.fModeSettings = mode;
        this.fModeSettings.addSettingsChangeListener(this.fSettingsDelegate);
        IIteration iteration = this.getIterationPlanData().getIteration();
        if (iteration.getStartDate() == null && "TIMELINE".equals(this.fModeSettings.getGroupMode().getId())) {
            this.fModeSettings.setGroupMode(this.fModeSettings.getPlanMode().getDefaultGroupMode());
        }
        outlineFilterDescriptorArray = mode.getPlanMode().getAllFilters();
        n2 = outlineFilterDescriptorArray.length;
        n = 0;
        while (n < n2) {
            OutlineFilterDescriptor filter = outlineFilterDescriptorArray[n];
            this.fFilterCache.put(filter.getId(), filter);
            ++n;
        }
        this.fQuickFilterList.setInput(this.fModeSettings);
        this.fGroupModeViewer.setInput((Object)this.fModeSettings);
        this.fSortModeViewer.setInput((Object)this.fModeSettings);
        this.fSettingsDelegate.settingChanged(new PlanOutlineSettingChangeEvent(PlanOutlineSettingChangeEvent.Property.REFRESH, null, new Object[0]));
    }

    OutlineFilterDescriptor getFilterFromId(String filterId) {
        return this.fFilterCache.get(filterId);
    }

    private void createTagFilter(String tag, boolean addToFilterSet) {
        TagFilterDescriptor tagFilter = new TagFilterDescriptor(tag);
        this.fFilterCache.put(tagFilter.getId(), tagFilter);
        if (addToFilterSet && this.fModeSettings.hasActiveFilters(OutlineFilterDescriptor.FilterType.TAGS)) {
            this.fModeSettings.addFilter(tagFilter);
        }
    }

    private OutlineFilterDescriptor[] getTagFilters() {
        ArrayList<OutlineFilterDescriptor> result = new ArrayList<OutlineFilterDescriptor>();
        for (OutlineFilterDescriptor filter : this.fFilterCache.values()) {
            if (!filter.isFilterType(OutlineFilterDescriptor.FilterType.TAGS)) continue;
            result.add(filter);
        }
        return result.toArray(new OutlineFilterDescriptor[result.size()]);
    }

    private void initializeOutliner() {
        this.hookActions();
        this.doSetMode(this.fAllModeSettings.get(this.fDefaultModeId));
        this.fViewModel.setInput((ResolvedPlan)this.fIterationPlan);
    }

    private void activePartChanged(Control control) {
        this.fActivePart = control;
        this.getIterationPlanEditor().refreshActionBarContributor();
        if (this.fActivePart == this.fOutline && this.fOutline != null) {
            this.getSite().setSelectionProvider((ISelectionProvider)this.fOutlineViewer);
        } else {
            this.getSite().setSelectionProvider(null);
        }
    }

    private void createOutliner() {
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).spacing(0, 0).applyTo(this.fOutlineComposite);
        Composite outlineContainer = new Composite(this.fOutlineComposite, 0);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 10;
        outlineContainer.setLayoutData((Object)gridData);
        GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(outlineContainer);
        Composite mainContainer = new Composite(outlineContainer, 0);
        mainContainer.setLayoutData((Object)new GridData(1808));
        mainContainer.setLayout((Layout)new FormLayout());
        this.fOutline = new PlanItemOutline(mainContainer, 0, this.getPlanOutlineSettings());
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100, 0);
        this.fOutline.setLayoutData(data);
        ActivationListener listener = new ActivationListener((Control)this.fOutline);
        this.fOutline.addListener(26, listener);
        this.fOutline.addListener(27, listener);
        TableLayoutHelper tableLayout = new TableLayoutHelper(this.fIterationPlan, this.fOutline.getPlanOutlineResources());
        OutlineColumn c = new OutlineColumn(this.fOutline);
        c.setWidth(tableLayout.getMarkerColumnWidth());
        c = new OutlineColumn(this.fOutline);
        c.setWidth(tableLayout.getItemColumnWidth());
        c = new OutlineColumn(this.fOutline);
        c.setWidth(tableLayout.getDurationColumnWidth());
        c = new OutlineColumn(this.fOutline);
        c.setWidth(tableLayout.getPriorityColumnWidth());
        c = new OutlineColumn(this.fOutline);
        c.setWidth(tableLayout.getOwnerColumnWidth());
        c = new OutlineColumn(this.fOutline);
        c.setWidth(tableLayout.getIdColumnWidth());
        this.fKnownTags = new HashSet<String>();
        this.fKnownTags.add(Tags.NO_TAGS);
        this.fIterationPlan.accept(new IPlanElementVisitor(){

            public boolean visit(PlanElement element) {
                if (element instanceof PlanItem && !((PlanItem)element).isAuxiliaryPlanItem()) {
                    PlanItem pi = (PlanItem)element;
                    Collection planTags = pi.getTags();
                    if (planTags.isEmpty()) {
                        planTags.add(pi.getPrimaryTag());
                    }
                    OutlinePage.this.fKnownTags.addAll(planTags);
                }
                return true;
            }
        });
        this.fOutlineViewer = new PlanItemOutlineViewer(this.fOutline, (IWorkbenchPartSite)this.getEditorSite());
        this.fOutlineViewer.setComparator(new OutlineModelViewerSorter());
        this.fOutlineViewer.setContentProvider((IContentProvider)new OutlineModelContentProvider());
        this.fOutlineViewer.addOpenListener(new PlanOpenListener(this.getEditorSite().getPage()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.fOutlineViewer);
        this.fSorter = new PartialViewerSorter(false);
        this.fViewerFilter = new OutlineViewerFilter(this.getPlanOutlineSettings());
        this.fViewModel = new IterationPlanViewModel(this.getPlanOutlineSettings());
        this.fViewModel.setViewer(this.fOutlineViewer);
        this.fViewModel.setSorter(this.fSorter);
        this.fViewModel.addFilter(this.fViewerFilter);
        this.fViewModel.hookContextMenu(this.getSite());
        this.fViewModel.addSortListener(new IterationPlanViewModel.SortListener(){

            public void sortingChanged(boolean isSorted) {
                if (OutlinePage.this.getPlanOutlineSettings().getSortMode() == SortMode.MY_SORT_ORDER) {
                    return;
                }
                OutlinePage.this.fSortByLabel.setText(isSorted ? SORT_BY_LABEL : SEMI_SORT_BY_LABEL);
            }
        });
        this.attachSettingListener(new PlanOutlineSettingsListener(this.getPlanOutlineSettings()){

            public void groupModeChanged(final GroupByDescription mode) {
                try {
                    OutlinePage.this.fOutline.stopEditSession();
                    OutlinePage.this.fOutline.setRelayout(false);
                    OutlinePage.this.fViewModel.executeUnlocked(new ModelUnlockedRunnable<Void, RuntimeException>(){

                        @Override
                        public Void run() throws RuntimeException {
                            OutlinePage.this.fViewModel.setSorter(null);
                            PlanModelTransformer modelTransformer = mode.createModelTransformer(null);
                            OutlinePage.this.fSorter = mode.createSorter();
                            SortMode sortMode = OutlinePage.this.fModeSettings.getSortMode();
                            if (sortMode != null) {
                                OutlinePage.this.fSorter.setItemComparator(sortMode.getComparator());
                            }
                            OutlinePage.this.fViewModel.setModelTransformer(modelTransformer);
                            OutlinePage.this.fViewModel.setSorter(OutlinePage.this.fSorter);
                            return null;
                        }
                    });
                }
                finally {
                    OutlinePage.this.fOutline.setRelayout(true);
                }
            }

            public void sortModeChanged(SortMode mode) {
                OutlinePage.this.fSorter.setItemComparator(mode.getComparator());
                OutlinePage.this.fViewModel.refreshSortOrder();
            }
        });
        this.fOutlineViewer.setInput(this.fViewModel);
        this.fFilterCache = new HashMap<String, OutlineFilterDescriptor>();
        for (String tag : this.fKnownTags) {
            this.createTagFilter(tag, false);
        }
        this.createPreviewPane(mainContainer);
        this.createSearchBar(outlineContainer);
        this.fOutlineComposite.layout(new Control[]{mainContainer, this.createSideBar(this.fOutlineComposite)});
        new TooltipSupport((Control)this.fOutline, true, false){

            public Object getElement(Control control, int x, int y) {
                IGObject graphicalObject = OutlinePage.this.fOutline.getGObjectUnder(x, y);
                if (graphicalObject == null) {
                    return null;
                }
                Object element = graphicalObject.getElement();
                if (element instanceof IterationPlanItem && graphicalObject instanceof GLink) {
                    return ((IterationPlanItem)element).getWorkItemHandle();
                }
                if (element instanceof IContributor && (graphicalObject instanceof GLabel || graphicalObject instanceof GDeferredImage)) {
                    return element;
                }
                if (element instanceof IMarker) {
                    return element;
                }
                if (element instanceof LoadItem) {
                    return element;
                }
                if (element instanceof ProgressInformation) {
                    return element;
                }
                return null;
            }

            public Rectangle getElementBounds(Control control, int x, int y) {
                IGObject graphicalObject = OutlinePage.this.fOutline.getGObjectUnder(x, y);
                if (graphicalObject == null) {
                    return new Rectangle(0, 0, 0, 0);
                }
                return Rectangles.create(OutlinePage.this.fOutline.getTransformation().toViewPort(graphicalObject.getBounds()));
            }
        };
        ((IterationPlanEditor)this.getEditor()).refreshActionBarContributor();
    }

    private void createSearchBar(Composite parent) {
        this.fQuickSearch = new QuickQueryBar(parent, this.fQuickQueryDefinition, new IQuickQueryContext(){

            public Object getAdapter(Class adapter) {
                if (ResolvedPlan.class.equals((Object)adapter)) {
                    return OutlinePage.this.fIterationPlan;
                }
                if (IProjectAreaHandle.class.equals((Object)adapter)) {
                    return this.getProjectArea();
                }
                return Platform.getAdapterManager().getAdapter((Object)this, adapter);
            }

            public IProjectAreaHandle getProjectArea() {
                return OutlinePage.this.fIterationPlanData.getProjectArea();
            }
        });
        Control control = this.fQuickSearch.getControl();
        ActivationListener listener = new ActivationListener(control);
        control.addListener(26, (Listener)listener);
        control.addListener(27, (Listener)listener);
        QuickQueryEntryFilter filter = new QuickQueryEntryFilter(this.fViewModel);
        this.fQuickSearch.registerParticipant(filter);
        QuickQueryColorizer colorizer = new QuickQueryColorizer(this.fViewModel);
        colorizer.setPriority(-1);
        colorizer.setLabel(Messages.OutlinePage_QUICK_COLORIZE);
        colorizer.setEnabled(true);
        colorizer.setColor(new RGB(255, 255, 0));
        this.fQuickSearch.registerParticipant(colorizer);
        QuickQueryEntryFinder finder = new QuickQueryEntryFinder((PlanViewModel)this.fViewModel){

            public void setExpression(Expression expression) {
                super.setExpression(expression);
                if (!this.find(true)) {
                    this.fViewModel.setSelectedEntries(Collections.EMPTY_SET);
                }
            }
        };
        this.fQuickSearch.registerParticipant(finder);
    }

    private Control createPreviewPane(Composite parent) {
        this.fPreviewPane = new PreviewPane(parent, this.fOutline, this, this.fIterationPlanData);
        Control previewControl = this.fPreviewPane.getControl();
        ActivationListener listener = new ActivationListener(previewControl);
        previewControl.addListener(26, (Listener)listener);
        previewControl.addListener(27, (Listener)listener);
        this.fPreviewPane.setVisible(this.fIsReadModeEnabled);
        this.fOutlineViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PlanItem planItem = null;
                OutlineEntry firstElement = (OutlineEntry)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (EntryUtils.isType(firstElement, PlanItem.class)) {
                    planItem = (PlanItem)firstElement.getElement();
                }
                OutlinePage.this.fPreviewPane.setInput(planItem);
            }
        });
        return previewControl;
    }

    private Composite createSideBar(Composite parent) {
        this.fSideBar = new Composite(parent, 0);
        ActivationListener listener = new ActivationListener((Control)this.fSideBar);
        this.fSideBar.addListener(26, (Listener)listener);
        this.fSideBar.addListener(27, (Listener)listener);
        GridData gd = new GridData(1040);
        gd.minimumWidth = 160;
        gd.heightHint = 10;
        this.fSideBar.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fSideBar.setLayout((Layout)gridLayout);
        Line vLine = new Line(this.fSideBar, 512);
        vLine.setForeground(JazzResources.getColor((String)"com.ibm.team.jface.itemview.OutlineColor"));
        gd = new GridData(1040);
        gd.verticalSpan = 2;
        vLine.setLayoutData(gd);
        Composite top = new Composite(this.fSideBar, 0);
        top.setLayoutData((Object)new GridData(768));
        gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 5;
        top.setLayout((Layout)gridLayout);
        top.setBackgroundMode(1);
        this.createGroupByContainer(top);
        this.createOrderByContainer(top);
        this.createProgressContainer(top);
        this.createFilterContainer(top);
        this.createSeparator(top);
        Composite bottom = new Composite(this.fSideBar, 0);
        bottom.setLayoutData((Object)new GridData(1808));
        gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 5;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        bottom.setLayout((Layout)gridLayout);
        bottom.setBackgroundMode(1);
        this.createSeparator(bottom);
        this.createRelatedWorkItemsContainer(bottom);
        this.createNextPlansContainer(bottom);
        LocalResourceManager mSB = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fSideBar);
        RGB listBackgroundRGB = mSB.getDevice().getSystemColor(25).getRGB();
        Color widgetBackgroundColor = mSB.getDevice().getSystemColor(22);
        Color sideBarTopColor = JazzResources.getColor((ResourceManager)mSB, (RGB)FormColors.blend((RGB)widgetBackgroundColor.getRGB(), (RGB)listBackgroundRGB, (int)10));
        GradientUtilities.setVerticalGradient((Composite)this.fSideBar, (Color)sideBarTopColor, (Color)widgetBackgroundColor);
        return this.fSideBar;
    }

    private void createFilterContainer(Composite composite) {
        Composite filterContainer = new Composite(composite, 0);
        filterContainer.setLayoutData((Object)new GridData(768));
        filterContainer.setLayout((Layout)new GridLayout(1, false));
        this.createTitle(filterContainer, Messages.OutlinePage_SIDEBAR_EXCLUDE_SECTION, 0);
        this.fQuickFilterList = new CheckboxListViewer(filterContainer, 0, this.getManagedForm().getForm().getBody());
        this.fQuickFilterList.setContentProvider((IContentProvider)new StructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return NO_ELEMENTS;
                }
                Assert.isLegal((inputElement == OutlinePage.this.fModeSettings ? 1 : 0) != 0);
                String[] filterIds = OutlinePage.this.getHotFilters();
                ArrayList<OutlineFilterDescriptor> result = new ArrayList<OutlineFilterDescriptor>(filterIds.length);
                String[] stringArray = filterIds;
                int n = filterIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String filterId = stringArray[n2];
                    OutlineFilterDescriptor filter = (OutlineFilterDescriptor)OutlinePage.this.fFilterCache.get(filterId);
                    Assert.isNotNull((Object)filter);
                    result.add(filter);
                    ++n2;
                }
                Collections.sort(result, new Comparator<OutlineFilterDescriptor>(){
                    Comparator fComperator = Collator.getInstance();

                    @Override
                    public int compare(OutlineFilterDescriptor o1, OutlineFilterDescriptor o2) {
                        return this.fComperator.compare(o1.getLabel(), o2.getLabel());
                    }
                });
                return result.toArray();
            }
        });
        this.fQuickFilterList.setLabelProvider((IBaseLabelProvider)new CheckboxLabelAdapter(){

            public String getText(Object element) {
                return ((OutlineFilterDescriptor)element).getLabel();
            }

            public boolean isChecked(Object element) {
                return OutlinePage.this.fModeSettings.isFilterActive((OutlineFilterDescriptor)element);
            }
        });
        this.fQuickFilterList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                OutlineFilterDescriptor filter = (OutlineFilterDescriptor)event.getElement();
                if (event.getChecked()) {
                    OutlinePage.this.fModeSettings.addFilter(filter);
                } else {
                    OutlinePage.this.fModeSettings.removeFilter(filter);
                }
                OutlinePage.this.fViewModel.refreshFilters();
            }
        });
        this.attachSettingListener(new PlanOutlineSettingsListener(){

            public void refresh() {
                OutlinePage.this.fQuickFilterList.refresh();
            }

            public void filterChanged(OutlineFilterDescriptor filter, boolean active) {
                OutlinePage.this.fQuickFilterList.setChecked(filter, active);
            }
        });
        PlanningUIPlugin.getDefault().getFilterUsageStatistics().addUsageChangeListener(this.fFilterRankingListener);
        HyperlinkGroup group = new HyperlinkGroup(this.getSite().getShell().getDisplay());
        group.setHyperlinkUnderlineMode(2);
        final Hyperlink moreFilters = this.createLink(filterContainer, Messages.OutlinePage_SIDEBAR_EXCLUDE_MORE_FILTERS);
        group.add(moreFilters);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 5;
        moreFilters.setLayoutData((Object)gd);
        moreFilters.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FilterSelectionDialog dialog = new FilterSelectionDialog(OutlinePage.this.getSite().getShell(), Messages.OutlinePage_FILTER_DIALOG_TITLE, Messages.OutlinePage_FILTER_DIALOG_MESSAGE, OutlinePage.this.fModeSettings.getPlanMode().getAllFilters(), OutlinePage.this.fModeSettings.getActiveFilters(OutlineFilterDescriptor.FilterType.REGULAR), new ViewerComparator((Comparator)new Comparator<String>(){
                    Comparator fComperator = Collator.getInstance();

                    @Override
                    public int compare(String s1, String s2) {
                        return this.fComperator.compare(s1, s2);
                    }
                }), "com.ibm.team.apt.ide.ui.dialog_workItemFilters");
                if (dialog.open() == 0) {
                    OutlinePage.this.fModeSettings.setFilters(dialog.getCheckedFilters(), OutlineFilterDescriptor.FilterType.REGULAR);
                    OutlinePage.this.fViewModel.refreshFilters();
                }
            }
        });
        final Hyperlink moreTags = this.createLink(filterContainer, Messages.OutlinePage_SIDEBAR_EXCLUDE_TAGS);
        group.add(moreTags);
        gd = new GridData(768);
        gd.horizontalIndent = 5;
        moreTags.setLayoutData((Object)gd);
        moreTags.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FilterSelectionDialog dialog = new FilterSelectionDialog(OutlinePage.this.getSite().getShell(), Messages.OutlinePage_TAG_FILTER_DIALOG_TITLE, Messages.OutlinePage_TAG_FILTER_DIALOG_MESSAGE, OutlinePage.this.getTagFilters(), OutlinePage.this.fModeSettings.getActiveFilters(OutlineFilterDescriptor.FilterType.TAGS), new ViewerComparator((Comparator)new Comparator<String>(){
                    Comparator fComperator = Collator.getInstance();

                    @Override
                    public int compare(String s1, String s2) {
                        if (s1.equals(s2)) {
                            return 0;
                        }
                        if (s1.equals(Tags.NO_TAGS)) {
                            return -1;
                        }
                        if (s2.equals(Tags.NO_TAGS)) {
                            return 1;
                        }
                        return this.fComperator.compare(s1, s2);
                    }
                }), "com.ibm.team.apt.ide.ui.dialog_tagFilters");
                if (dialog.open() == 0) {
                    OutlinePage.this.fModeSettings.setFilters(dialog.getCheckedFilters(), OutlineFilterDescriptor.FilterType.TAGS);
                    OutlinePage.this.fViewModel.refreshFilters();
                }
            }
        });
        this.attachSettingListener(new PlanOutlineSettingsListener(){

            public void refresh() {
                this.updateFilterCount();
            }

            public void filterChanged(OutlineFilterDescriptor filter, boolean active) {
                this.updateFilterCount();
            }

            private void updateFilterCount() {
                OutlineFilterDescriptor[] activeFilters = OutlinePage.this.fModeSettings.getActiveFilters(OutlineFilterDescriptor.FilterType.REGULAR);
                int activeHiddenFilters = activeFilters.length;
                String[] stringArray = OutlinePage.this.getHotFilters();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String hotFilterId = stringArray[n2];
                    OutlineFilterDescriptor[] outlineFilterDescriptorArray = activeFilters;
                    int n3 = activeFilters.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        OutlineFilterDescriptor activeFilter = outlineFilterDescriptorArray[n4];
                        if (hotFilterId.equals(activeFilter.getId())) {
                            --activeHiddenFilters;
                            break;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (activeHiddenFilters > 0) {
                    moreFilters.setText(NLS.bind((String)Messages.OutlinePage_FILTERS_MORE_SELETCED, (Object[])new Object[]{activeHiddenFilters}));
                } else {
                    moreFilters.setText(Messages.OutlinePage_FILTERS_MORE_NONE_SELECTED);
                }
                if (OutlinePage.this.fModeSettings.getActiveFilters(OutlineFilterDescriptor.FilterType.TAGS).length > 0) {
                    moreTags.setText(NLS.bind((String)Messages.OutlinePage_TAGS_MORE_SELETCED, (Object[])new Object[]{OutlinePage.this.fModeSettings.getActiveFilters(OutlineFilterDescriptor.FilterType.TAGS).length}));
                } else {
                    moreTags.setText(Messages.OutlinePage_TAGS_MORE_NONE_SELETCED);
                }
            }
        });
    }

    private String[] getHotFilters() {
        PlanModeDescription planMode = this.fModeSettings.getPlanMode();
        HashSet<String> allFilters = new HashSet<String>();
        OutlineFilterDescriptor[] outlineFilterDescriptorArray = planMode.getAllFilters();
        int n = outlineFilterDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            OutlineFilterDescriptor filter = outlineFilterDescriptorArray[n2];
            allFilters.add(filter.getId());
            ++n2;
        }
        ArrayList<String> defaultFilters = new ArrayList<String>();
        OutlineFilterDescriptor[] outlineFilterDescriptorArray2 = planMode.getDisplayedFilters();
        int n3 = outlineFilterDescriptorArray2.length;
        n = 0;
        while (n < n3) {
            OutlineFilterDescriptor filter = outlineFilterDescriptorArray2[n];
            defaultFilters.add(filter.getId());
            ++n;
        }
        FilterUsageStatistics usageStatistics = PlanningUIPlugin.getDefault().getFilterUsageStatistics();
        return usageStatistics.getFilterHotlist(3, allFilters, defaultFilters);
    }

    private void createGroupByContainer(Composite composite) {
        Composite groupByContainer = new Composite(composite, 0);
        groupByContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        groupByContainer.setLayout((Layout)new GridLayout(1, false));
        this.createTitle(groupByContainer, Messages.OutlinePage_SIDEBAR_GROUPBY_SECTION, 0);
        Combo combo = new Combo(groupByContainer, 8);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 5;
        combo.setLayoutData((Object)gd);
        this.fGroupModeViewer = new ComboViewer(combo);
        this.fGroupModeViewer.setContentProvider((IContentProvider)new StructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return NO_ELEMENTS;
                }
                Assert.isLegal((inputElement == OutlinePage.this.fModeSettings ? 1 : 0) != 0);
                return OutlinePage.this.fModeSettings.getPlanMode().getGroupModes();
            }
        });
        this.fGroupModeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((GroupByDescription)element).getLabel();
            }
        });
        this.fGroupModeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                Assert.isTrue((selection.size() == 1 ? 1 : 0) != 0);
                GroupByDescription mode = (GroupByDescription)selection.getFirstElement();
                if ("TIMELINE".equals(mode.getId()) && OutlinePage.this.getIterationPlanData().getIteration().getStartDate() == null) {
                    MessageDialog.openInformation((Shell)OutlinePage.this.fGroupModeViewer.getControl().getShell(), (String)Messages.OutlinePage_SEQUENCE_GROUP_MODE_NOT_AVAILABLE_TITLE, (String)Messages.OutlinePage_SEQUENCE_GROUP_MODE_NOT_AVAILABLE_MESSAGE);
                } else {
                    OutlinePage.this.fModeSettings.setGroupMode(mode);
                }
            }
        });
        this.attachSettingListener(new PlanOutlineSettingsListener(this.getPlanOutlineSettings()){

            public void groupModeChanged(GroupByDescription mode) {
                OutlinePage.this.fGroupModeViewer.setSelection((ISelection)new StructuredSelection((Object)mode));
            }
        });
    }

    private void createOrderByContainer(Composite composite) {
        Composite orderByContainer = new Composite(composite, 0);
        orderByContainer.setLayoutData((Object)new GridData(4, 1, false, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginBottom = 5;
        orderByContainer.setLayout((Layout)layout);
        this.fSortByLabel = new Link(orderByContainer, 0);
        this.fSortByLabel.setText(SORT_BY_LABEL);
        this.fSortByLabel.setFont(JazzResources.getFont((String)"com.ibm.team.jface.itemview.TitleFont"));
        this.fSortByLabel.setForeground(JazzResources.getColor((String)"com.ibm.team.jface.itemview.TitleColor"));
        this.fSortByLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutlinePage.this.fViewModel.refreshSortOrder();
                OutlinePage.this.fOutline.setFocus();
            }
        });
        this.fSortByLabel.setLayoutData((Object)new GridData(768));
        Combo combo = new Combo(orderByContainer, 8);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 5;
        combo.setLayoutData((Object)gd);
        this.fSortModeViewer = new ComboViewer(combo);
        this.fSortModeViewer.setContentProvider((IContentProvider)new StructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return NO_ELEMENTS;
                }
                Assert.isLegal((inputElement == OutlinePage.this.fModeSettings ? 1 : 0) != 0);
                return OutlinePage.this.fModeSettings.getGroupMode().getSortModes().toArray();
            }
        });
        this.fSortModeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((SortMode)((Object)element)).getLabel();
            }
        });
        this.fSortModeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.size() >= 1) {
                    OutlinePage.this.fModeSettings.setSortMode((SortMode)((Object)selection.getFirstElement()));
                }
            }
        });
        this.attachSettingListener(new PlanOutlineSettingsListener(this.getPlanOutlineSettings()){

            public void groupModeChanged(GroupByDescription mode) {
                int size = OutlinePage.this.fModeSettings.getGroupMode().getSortModes().size();
                OutlinePage.this.fSortModeViewer.getCombo().setEnabled(size > 1);
                OutlinePage.this.fSortModeViewer.getCombo().setVisibleItemCount(size);
                OutlinePage.this.fSortModeViewer.refresh();
            }

            public void sortModeChanged(SortMode mode) {
                OutlinePage.this.fSortModeViewer.setSelection((ISelection)new StructuredSelection((Object)mode));
                OutlinePage.this.fSortByLabel.setText(SORT_BY_LABEL);
            }
        });
    }

    private void createProgressContainer(Composite composite) {
        Composite progressContainer = new Composite(composite, 0);
        progressContainer.setLayoutData((Object)new GridData(4, 1, false, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginBottom = 5;
        progressContainer.setLayout((Layout)layout);
        this.createTitle(progressContainer, Messages.OutlinePage_GROUP_BARS, 0);
        final Combo combo = new Combo(progressContainer, 8);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 5;
        combo.setLayoutData((Object)gd);
        ProgressMode[] progressModeArray = ProgressMode.values();
        int n = progressModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProgressMode mode = progressModeArray[n2];
            combo.add(mode.getLabel());
            ++n2;
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = combo.getSelectionIndex();
                switch (selectionIndex) {
                    case 0: {
                        OutlinePage.this.fModeSettings.setOwnerProgressMode(ProgressMode.PROGRESS);
                        break;
                    }
                    case 1: {
                        OutlinePage.this.fModeSettings.setOwnerProgressMode(ProgressMode.LOAD);
                    }
                }
            }
        });
        this.attachSettingListener(new PlanOutlineSettingsListener(this.getPlanOutlineSettings()){

            public void groupModeChanged(GroupByDescription mode) {
                if ("OWNER".equals(mode.getId()) || "TIMELINE".equals(mode.getId())) {
                    combo.setEnabled(true);
                    combo.select(OutlinePage.this.getPlanOutlineSettings().getOwnerProgressMode().ordinal());
                } else {
                    combo.setEnabled(false);
                    combo.select(ProgressMode.PROGRESS.ordinal());
                }
            }
        });
    }

    private void createPlanWorkItemsContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gridData = new GridData(4, 1, true, false);
        container.setLayoutData((Object)gridData);
        GridLayout linksContainerGridLayout = new GridLayout(1, false);
        container.setLayout((Layout)linksContainerGridLayout);
        this.createTitle(container, Messages.OutlinePage_SIDEBAR_WORKITEMS_SECTION, 0);
        HyperlinkGroup group = new HyperlinkGroup(this.getSite().getShell().getDisplay());
        group.setHyperlinkUnderlineMode(2);
        this.createQueryLink(container, group, Messages.OutlinePage_SIDEBAR_WORKITEMS_OPEN, PlanModeDescription.SidebarQuery.OPEN_ITEMS, new Object[0]);
        this.createQueryLink(container, group, Messages.OutlinePage_SIDEBAR_WORKITEMS_CLOSED, PlanModeDescription.SidebarQuery.CLOSED_ITEMS, new Object[0]);
    }

    private void createRelatedWorkItemsContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gridData = new GridData(4, 1, true, false);
        container.setLayoutData((Object)gridData);
        GridLayout linksContainerGridLayout = new GridLayout(1, false);
        container.setLayout((Layout)linksContainerGridLayout);
        this.createTitle(container, Messages.OutlinePage_SIDEBAR_WORKITEMS_RELATED, 0);
        HyperlinkGroup group = new HyperlinkGroup(this.getSite().getShell().getDisplay());
        group.setHyperlinkUnderlineMode(2);
        this.createQueryLink(container, group, Messages.OutlinePage_SIDEBAR_WORKITEMS_BACKLOG, PlanModeDescription.SidebarQuery.BACKLOG, new Object[0]);
        if (Iterations.hasDates((IIteration)this.getIterationPlanData().getIteration())) {
            this.createQueryLink(container, group, Messages.OutlinePage_SIDEBAR_WORKITEMS_UNPLANNED_CLOSED, PlanModeDescription.SidebarQuery.UNPLANNED_CLOSED, new Object[0]);
        }
    }

    private void createNextPlansContainer(Composite parent) {
        Composite nextPlansContainer = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        nextPlansContainer.setLayoutData((Object)gd);
        GridLayout relGridLayout = new GridLayout(1, false);
        nextPlansContainer.setLayout((Layout)relGridLayout);
        this.createTitle(nextPlansContainer, Messages.OutlinePage_SIDEBAR_NEXTPLANS_SECTION, 0);
        ScrolledButtonComposite sbc = new ScrolledButtonComposite(nextPlansContainer, 0);
        gd = new GridData(1808);
        gd.heightHint = 100;
        sbc.setLayoutData(gd);
        Composite scrollContainer = sbc.getScrollContainer();
        scrollContainer.setLayout((Layout)new GridLayout(1, false));
        Composite content = new Composite(scrollContainer, 0);
        GridData contentGridData = new GridData(4, 1, true, false);
        content.setLayoutData((Object)contentGridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 2;
        gridLayout.marginHeight = 5;
        content.setLayout((Layout)gridLayout);
        HyperlinkGroup group = new HyperlinkGroup(this.getSite().getShell().getDisplay());
        group.setHyperlinkUnderlineMode(2);
        for (IIteration interval : this.fIterationPlan.getFutureIterations()) {
            this.createIntervalLink(content, group, interval);
        }
        sbc.setContent(content);
    }

    private void createIntervalLink(Composite content, HyperlinkGroup group, IIteration iteration) {
        Composite c = new Composite(content, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        c.setLayout((Layout)gridLayout);
        Label l = new Label(c, 0);
        l.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)ImagePool.ITERATION_PLAN_OBJ));
        l.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Hyperlink link = this.createPlanLink(c, OutlinePage.shortenText(iteration.getLabel(), 15), iteration);
        group.add(link);
        boolean hasDates = Iterations.hasDates((IIteration)iteration);
        String iterationTooltipText = hasDates ? MessageFormat.format(Messages.OutlinePage_SIDEBAR_NEXTPLANS_TOOLTIP_DURATION, iteration.getStartDate(), iteration.getEndDate()) : Messages.OutlinePage_SIDEBAR_NEXTPLANS_TOOLTIP_DURATION_UNKNOWN;
        String tooltipText = MessageFormat.format(Messages.OutlinePage_SIDEBAR_NEXTPLANS_TOOLTIP, iteration.getLabel(), iterationTooltipText);
        link.setToolTipText(tooltipText);
        GridData gridData = new GridData(4, 1, true, false);
        link.setLayoutData((Object)gridData);
    }

    private static String shortenText(String value, int cCount) {
        if (value == null) {
            return value;
        }
        StringBuilder text = new StringBuilder(value);
        if (text.length() > cCount) {
            text.delete(cCount, text.length());
            text.append("...");
        }
        return text.toString();
    }

    private Hyperlink createLink(Composite composite, String string) {
        Hyperlink l = new Hyperlink(composite, 64);
        l.setText(string);
        return l;
    }

    private Label createTitle(Composite parent, String text, int style) {
        Label l = new Label(parent, style);
        l.setText(text);
        l.setFont(JazzResources.getFont((String)"com.ibm.team.jface.itemview.TitleFont"));
        l.setForeground(JazzResources.getColor((String)"com.ibm.team.jface.itemview.TitleColor"));
        return l;
    }

    private void createSeparator(Composite parent) {
        Label label = new Label(parent, 258);
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
    }

    private Hyperlink createPlanLink(Composite container, String linkText, final IIteration iteration) {
        Hyperlink link = this.createLink(container, linkText);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IterationPlanData data = OutlinePage.this.getIterationPlanData();
                PlanningUIPlugin.openIterationPlanEditor((ITeamAreaHandle)data.getTeamArea(), (IIterationHandle)iteration, OutlinePage.this.getEditorSite().getPage());
            }
        });
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).indent(5, 0).applyTo((Control)link);
        return link;
    }

    private Hyperlink createQueryLink(Composite container, HyperlinkGroup group, String linkText, final PlanModeDescription.SidebarQuery query, final Object ... parameters) {
        Hyperlink queryLink = this.createLink(container, linkText);
        group.add(queryLink);
        queryLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                final IWorkbenchWindow window = OutlinePage.this.getSite().getWorkbenchWindow();
                IProgressService progService = window.getWorkbench().getProgressService();
                try {
                    progService.run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                        protected void execute(IProgressMonitor monitor) throws TeamRepositoryException, InvocationTargetException, InterruptedException {
                            IterationPlanData planData = OutlinePage.this.getIterationPlanData();
                            QueryDescriptor queryDescriptor = OutlinePage.this.fModeSettings.getPlanMode().getSidebarQuery(query, planData, monitor, parameters);
                            QueriesUI.showQueryResults((IWorkbenchWindow)window, (ITeamRepository)planData.getTeamRepository(), (String)queryDescriptor.getLabel(), (Expression)queryDescriptor.getQuery());
                        }
                    });
                }
                catch (InvocationTargetException ex) {
                    ExceptionHandler.handle(ex, OutlinePage.this.getSite().getShell(), Messages.OutlinePage_RUN_QUERY_FAILED_TITLE, Messages.OutlinePage_RUN_QUERY_FAILED_MESSAGE);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalIndent = 5;
        queryLink.setLayoutData((Object)gridData);
        return queryLink;
    }

    public String getContextId() {
        return this.fContextId;
    }

    private void hookActions() {
        Action action;
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Action[] actionArray = this.fQuickSearch.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)action));
            ++n2;
        }
        actionArray = this.fViewModel.getActions();
        n = actionArray.length;
        n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)action));
            ++n2;
        }
        this.fOutline.addGadgetEditorActivationListener(new IGadgetEditorActivationListener(){

            public void activated(IGadgetEditor editor) {
                if (editor == null) {
                    return;
                }
                Gadget gadget = editor.getGadget();
                if (!(gadget instanceof GText)) {
                    return;
                }
                String id = ((GText)gadget).getId();
                if ("summary".equals(id)) {
                    OutlinePage.this.fContextId = "com.ibm.team.apt.actions.iterationPlanEditor.editing.summary";
                } else if ("description".equals(id)) {
                    OutlinePage.this.fContextId = "com.ibm.team.apt.actions.iterationPlanEditor.editing.description";
                } else {
                    OutlinePage.this.fContextId = "com.ibm.team.apt.actions.iterationPlanEditor.editing";
                }
                OutlinePage.this.getIterationPlanEditor().refreshActionBarContributor();
            }

            public void deactivated(IGadgetEditor editor) {
                if (editor == null) {
                    return;
                }
                OutlinePage.this.fContextId = "com.ibm.team.apt.actions.iterationPlanEditor.outline";
                OutlinePage.this.getIterationPlanEditor().refreshActionBarContributor();
            }
        });
    }

    public void saveState(IMemento memento) {
        IMemento outlinePageState = memento.createChild(OUTLINE_PAGE);
        for (PlanModeState modeState : this.fAllModeSettings.values()) {
            modeState.saveState(outlinePageState);
        }
    }

    public void loadState(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento outlinePageState = memento.getChild(OUTLINE_PAGE);
        if (outlinePageState == null) {
            return;
        }
        for (PlanModeState modeState : this.fAllModeSettings.values()) {
            modeState.loadState(outlinePageState);
        }
    }

    private void attachSettingListener(IOutlineSettingsListener listener) {
        this.getPlanOutlineSettings().addSettingsChangeListener(listener);
        this.fAttachedSettingListeners.add(listener);
    }

    private void setDirtyPartName() {
        if (this.fDirty) {
            return;
        }
        this.fDirty = true;
        this.getIterationPlanEditor().asyncExec(new Runnable(){

            public void run() {
                OutlinePage.this.setPartName("*" + PAGE_TITLE);
            }
        });
    }

    private void setSavedPartName() {
        if (!this.fDirty) {
            return;
        }
        this.fDirty = false;
        this.getIterationPlanEditor().asyncExec(new Runnable(){

            public void run() {
                OutlinePage.this.setPartName(PAGE_TITLE);
            }
        });
    }

    private class ActivationListener
    implements Listener {
        private Control fControl;

        public ActivationListener(Control control) {
            this.fControl = control;
        }

        public void handleEvent(Event event) {
            if (event.type == 26) {
                OutlinePage.this.activePartChanged(this.fControl);
            } else if (event.type == 27 && OutlinePage.this.fActivePart == this.fControl) {
                OutlinePage.this.activePartChanged(null);
            }
        }
    }

    private static class FailureInfo {
        public TeamRepositoryException exception;
        public IStatus status;

        public FailureInfo(TeamRepositoryException e, IStatus s) {
            this.exception = e;
            this.status = s;
        }
    }

    private final class IterationPlanListener
    implements IPlanElementListener {
        private IterationPlanListener() {
        }

        public void planElementChanged(IPlanElementChangeEvent event) {
            final Boolean[] dirty = new Boolean[1];
            if (OutlinePage.this.fOutlineViewer == null) {
                event.getDelta().accept(new IPlanElementDeltaVisitor(){

                    public boolean visit(IPlanElementDelta delta) {
                        PlanElement element = delta.getPlanElement();
                        if (element instanceof ResolvedIterationPlan) {
                            IPlanAttributeDelta attribute = delta.getAttributeDelta(ResolvedPlan.DIRTY);
                            if (attribute == null) {
                                return true;
                            }
                            dirty[0] = (Boolean)attribute.getNewValue();
                            return false;
                        }
                        return true;
                    }
                });
            } else {
                final String[] newLabel = new String[1];
                event.getDelta().accept(new IPlanElementDeltaVisitor(){

                    public boolean visit(IPlanElementDelta delta) {
                        PlanElement element = delta.getPlanElement();
                        if (newLabel[0] == null) {
                            if (delta.isAdded()) {
                                newLabel[0] = SEMI_SORT_BY_LABEL;
                            } else {
                                IPlanAttributeDelta[] attributeDeltas = delta.getAttributeDeltas();
                                int i = 0;
                                while (i < attributeDeltas.length) {
                                    if (OutlinePage.this.fSorter.isSorterProperty(attributeDeltas[i].getAttribute().getName())) {
                                        newLabel[0] = SEMI_SORT_BY_LABEL;
                                        break;
                                    }
                                    ++i;
                                }
                            }
                        }
                        if (element instanceof PlanItem) {
                            IPlanAttributeDelta attributeDelta;
                            Collection tags = null;
                            if (delta.isAdded()) {
                                tags = ((PlanItem)element).getTags();
                            }
                            if (delta.isChanged() && (attributeDelta = delta.getAttributeDelta(PlanItem.TAGS)) != null) {
                                tags = TagsAttributeType.parseTags((String)((String)attributeDelta.getNewValue()));
                            }
                            if (tags != null) {
                                for (String tag : tags) {
                                    if (!OutlinePage.this.fKnownTags.add(tag)) continue;
                                    OutlinePage.this.createTagFilter(tag, true);
                                }
                            }
                        } else if (element instanceof ResolvedIterationPlan) {
                            IPlanAttributeDelta attribute = delta.getAttributeDelta(ResolvedPlan.DIRTY);
                            if (attribute == null) {
                                return true;
                            }
                            dirty[0] = (Boolean)attribute.getNewValue();
                            return true;
                        }
                        return true;
                    }
                });
                if (newLabel[0] != null && OutlinePage.this.fSortByLabel != null && OutlinePage.this.getPlanOutlineSettings().getSortMode() != SortMode.MY_SORT_ORDER) {
                    UI.asyncExec((Control)OutlinePage.this.fSortByLabel, new Runnable(){

                        public void run() {
                            OutlinePage.this.fSortByLabel.setText(newLabel[0]);
                        }
                    });
                }
            }
            if (dirty[0] != null) {
                if (dirty[0].booleanValue()) {
                    OutlinePage.this.setDirtyPartName();
                } else {
                    OutlinePage.this.setSavedPartName();
                }
            }
        }
    }

    private class SettingsDelegate
    implements IPlanOutlineSettings,
    IOutlineSettingsListener {
        private final ListenerList fSettingListeners = new ListenerList(1);

        private SettingsDelegate() {
        }

        public void addSettingsChangeListener(IOutlineSettingsListener listener) {
            this.fSettingListeners.add((Object)listener);
        }

        public void removeSettingsChangeListener(IOutlineSettingsListener listener) {
            this.fSettingListeners.remove((Object)listener);
        }

        public ItemMovePolicy getItemMovePolicy() {
            return OutlinePage.this.fModeSettings.getItemMovePolicy();
        }

        public boolean getShowDetails() {
            return OutlinePage.this.fModeSettings.getShowDetails();
        }

        public PlanModeDescription getPlanMode() {
            return OutlinePage.this.fModeSettings.getPlanMode();
        }

        public GroupByDescription getGroupMode() {
            return OutlinePage.this.fModeSettings.getGroupMode();
        }

        public SortMode getSortMode() {
            return OutlinePage.this.fModeSettings.getSortMode();
        }

        public ProgressMode getOwnerProgressMode() {
            return OutlinePage.this.fModeSettings.getOwnerProgressMode();
        }

        public OutlineFilterDescriptor[] getActiveFilters(OutlineFilterDescriptor.FilterType filterType) {
            return OutlinePage.this.fModeSettings.getActiveFilters(filterType);
        }

        public void settingChanged(OutlineSettingChangeEvent event) {
            Object[] listeners = this.fSettingListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                IOutlineSettingsListener listener = (IOutlineSettingsListener)listeners[i];
                listener.settingChanged(event);
                ++i;
            }
        }

        public String getDefaultWorkItemType() {
            return OutlinePage.this.fModeSettings.getDefaultWorkItemType();
        }

        public void setDefaultWorkItemType(String value) {
            OutlinePage.this.fModeSettings.setDefaultWorkItemType(value);
        }
    }

    public static class TableLayoutHelper {
        private static final int ICON_WIDTH = 16;
        private static final int OWNER_MAX_LEN = 22;
        private int fId;
        private int fPriority;
        private int fDuration;
        private int fOwner;

        private TableLayoutHelper(ResolvedIterationPlan plan, PlanOutlineResources planOutlineResources) {
            this.init(plan, planOutlineResources);
        }

        private void init(ResolvedIterationPlan plan, PlanOutlineResources resources) {
            Font normalFont = resources.getTextFonts().getNormalFont();
            final GC gc = new GC((Drawable)normalFont.getDevice());
            gc.setFont(normalFont);
            try {
                final int[] lengths = new int[4];
                final int[] count = new int[1];
                final DurationFormat durationFormat = resources.getDurationFormat(plan.getProjectWorkEnvironment());
                lengths[2] = gc.stringExtent((String)Messages.OutlinePage_100_CLOSED).x;
                plan.accept(new IPlanElementVisitor(){

                    public boolean visit(PlanElement element) {
                        if (element instanceof PlanItem) {
                            IContributor owner;
                            PlanItem item = (PlanItem)element;
                            if (!item.isProgressPlanItem()) {
                                lengths[0] = Math.max(lengths[0], item.getId());
                                IPriority priority = item.getPriority();
                                lengths[1] = Math.max(lengths[1], gc.stringExtent((String)(priority != null ? priority.getName() : Messages.OutlinePage_NULL_PRIORITY)).x);
                                lengths[2] = Math.max(lengths[2], gc.stringExtent((String)durationFormat.format((Duration)item.getDuration())).x);
                            }
                            if ((owner = item.getOwner()) != null) {
                                lengths[3] = Math.max(lengths[3], gc.stringExtent((String)owner.getName()).x);
                            }
                            count[0] = count[0] + 1;
                        }
                        return true;
                    }
                });
                int highestId = lengths[0];
                int c = 0;
                while (highestId > 0) {
                    highestId /= 10;
                    ++c;
                }
                lengths[0] = 100 * c - lengths[0] > 80 ? gc.stringExtent((String)String.valueOf((int)(lengths[0] * 10))).x : gc.stringExtent((String)String.valueOf((int)lengths[0])).x;
                if (count[0] > 0) {
                    this.fId = lengths[0];
                    this.fPriority = lengths[1];
                    this.fDuration = lengths[2];
                    this.fOwner = lengths[3];
                } else {
                    this.fId = gc.stringExtent((String)"99999").x;
                    this.fPriority = gc.stringExtent((String)"unassigned").x;
                    this.fDuration = gc.stringExtent((String)"99 minutes").x;
                    this.fOwner = resources.getFontMetrics().getAverageCharWidth() * 22;
                }
                this.fId += resources.getIdSpacing() * 2;
                this.fPriority += 2 * resources.getSpaceWidth();
                this.fDuration += 2 * resources.getSpaceWidth();
                this.fOwner += 2 * resources.getSpaceWidth();
            }
            finally {
                gc.dispose();
            }
        }

        public int getMarkerColumnWidth() {
            return 16;
        }

        public int getItemColumnWidth() {
            return 4;
        }

        public int getPriorityColumnWidth() {
            return 16 + this.fPriority;
        }

        public int getDurationColumnWidth() {
            return 16 + this.fDuration;
        }

        public int getOwnerColumnWidth() {
            return 16 + this.fOwner;
        }

        public int getIdColumnWidth() {
            return this.fId;
        }
    }
}

