/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;

public class LoadingPage
extends FormPage {
    public static final String ID = "com.ibm.team.apt.internal.IterationPlanEditor.LoadingPage";
    private Label fImage;
    private Label fMessage;
    private Text fException;

    public LoadingPage(FormEditor editor) {
        this(editor, Messages.LoadingPage_LOADING_MESSAGE);
    }

    public LoadingPage(FormEditor editor, String title) {
        super(editor, ID, title);
    }

    public void setStatus(IStatus status) {
        if (this.fImage == null) {
            this.createContent();
        }
        this.setPartName(Messages.LoadingPage_STATUS);
        Display display = this.fImage.getDisplay();
        switch (status.getSeverity()) {
            case 0: {
                this.fImage.setImage(null);
                break;
            }
            case 1: {
                this.fImage.setImage(display.getSystemImage(2));
                break;
            }
            case 2: {
                this.fImage.setImage(display.getSystemImage(8));
                break;
            }
            case 4: {
                this.fImage.setImage(display.getSystemImage(1));
                break;
            }
            default: {
                this.fImage.setImage(null);
            }
        }
        this.fMessage.setText(status.getMessage());
        Throwable exception = status.getException();
        if (exception != null) {
            StringWriter writer = new StringWriter();
            exception.printStackTrace(new PrintWriter(writer));
            this.fException.setText(writer.getBuffer().toString());
            ((GridData)this.fException.getLayoutData()).exclude = false;
        } else {
            this.fException.setText("");
            ((GridData)this.fException.getLayoutData()).exclude = true;
        }
        this.getManagedForm().getForm().getBody().layout(true, true);
    }

    private void createContent() {
        Composite body = this.getManagedForm().getForm().getBody();
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(body);
        this.fImage = new Label(body, 0);
        this.fImage.setBackground(body.getBackground());
        GridDataFactory.swtDefaults().align(16384, 128).span(1, 2).applyTo((Control)this.fImage);
        this.fMessage = new Label(body, 64);
        this.fMessage.setBackground(body.getBackground());
        this.fMessage.setFont(JFaceResources.getBannerFont());
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fMessage);
        this.fException = new Text(body, 776);
        this.fException.setBackground(body.getBackground());
        GridDataFactory.fillDefaults().grab(true, true).exclude(true).applyTo((Control)this.fException);
    }
}

