/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.common.Message;
import com.ibm.team.apt.internal.ide.ui.editor.IInformationMessageProvider;
import com.ibm.team.apt.internal.ide.ui.widgets.InformationViewer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.ui.forms.editor.IFormPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformationMessageProvider
implements IInformationMessageProvider {
    public static final IFormPage ANY_PAGE = null;
    private ListenerList fListener = new ListenerList(1);
    private List<Message> fMessages = new ArrayList<Message>();
    private InformationViewer fViewer;
    private final IFormPage fPage;

    protected InformationMessageProvider(IFormPage page, InformationViewer viewer) {
        Assert.isNotNull((Object)((Object)viewer));
        this.fPage = page;
        this.fViewer = viewer;
        this.fViewer.addInformationMessageListener(new InformationViewer.IInformationMessageListener(){

            public void clicked(Object element, String text) {
                if (InformationMessageProvider.this.fMessages.contains(element)) {
                    Object[] listeners;
                    Object[] objectArray = listeners = InformationMessageProvider.this.fListener.getListeners();
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        ((InformationViewer.IInformationMessageListener)object).clicked(element, text);
                        ++n2;
                    }
                }
            }

            public void closed(Object element) {
                if (InformationMessageProvider.this.fMessages.contains(element)) {
                    Object[] listeners;
                    Object[] objectArray = listeners = InformationMessageProvider.this.fListener.getListeners();
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        ((InformationViewer.IInformationMessageListener)object).closed(element);
                        ++n2;
                    }
                    InformationMessageProvider.this.removeMessage((Message)element);
                }
            }
        });
    }

    public void addMessage(Message message) {
        this.fMessages.add(message);
        this.fViewer.refresh();
    }

    public void removeMessage(Message message) {
        this.fMessages.remove(message);
        this.fViewer.refresh();
    }

    public void clear() {
        this.fMessages.clear();
        this.fViewer.refresh();
    }

    @Override
    public List<? extends Message> getMessages() {
        boolean showMessages;
        boolean bl = showMessages = this.fPage == null || this.fPage == this.fPage.getEditor().getActivePageInstance();
        if (showMessages) {
            return Collections.unmodifiableList(this.fMessages);
        }
        return Collections.emptyList();
    }

    public void addInformationMessageListener(InformationViewer.IInformationMessageListener listener) {
        this.fListener.add((Object)listener);
    }

    public void removeInformationMessageListener(InformationViewer.IInformationMessageListener listener) {
        this.fListener.remove((Object)listener);
    }
}

