/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.ide.ui.editor.FilterDescriptorLabelProvider;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.OutlineFilterDescriptor;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FilterSelectionDialog
extends Dialog {
    protected CheckboxTableViewer fFiltersViewer;
    protected Text fDescriptionText;
    protected Label fSelectedCount;
    protected OutlineFilterDescriptor[] fAllFilters;
    protected OutlineFilterDescriptor[] fSelectedFilters;
    protected OutlineFilterDescriptor[] fCheckedFilters;
    protected String fTitle;
    protected String fText;
    protected ViewerComparator fComparator;
    private String fHelpContextId;

    public FilterSelectionDialog(Shell parent, String title, String text, OutlineFilterDescriptor[] allFilters, OutlineFilterDescriptor[] selectedFilters, ViewerComparator comparator, String helpContextId) {
        super(parent);
        this.fAllFilters = allFilters;
        this.fSelectedFilters = selectedFilters;
        this.fTitle = title;
        this.fText = text;
        this.fComparator = comparator;
        this.fHelpContextId = helpContextId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
        if (this.fHelpContextId != null) {
            UI.hookHelpListener((Control)newShell, this.fHelpContextId);
        }
    }

    protected void okPressed() {
        this.fCheckedFilters = new OutlineFilterDescriptor[this.fFiltersViewer.getCheckedElements().length];
        System.arraycopy(this.fFiltersViewer.getCheckedElements(), 0, this.fCheckedFilters, 0, this.fFiltersViewer.getCheckedElements().length);
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        gd.heightHint = this.convertHeightInCharsToPixels(25);
        gd.minimumHeight = this.convertHeightInCharsToPixels(20);
        composite.setLayoutData((Object)gd);
        Label title = new Label(composite, 16384);
        title.setText(this.fText);
        this.fFiltersViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2564);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        this.fFiltersViewer.getControl().setLayoutData((Object)gd);
        this.fFiltersViewer.setLabelProvider((IBaseLabelProvider)new FilterDescriptorLabelProvider());
        this.fFiltersViewer.setComparator(this.fComparator);
        this.fFiltersViewer.add((Object[])this.fAllFilters);
        this.fFiltersViewer.setCheckedElements((Object[])this.fSelectedFilters);
        this.fFiltersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    OutlineFilterDescriptor ofd = (OutlineFilterDescriptor)((IStructuredSelection)event.getSelection()).getFirstElement();
                    FilterSelectionDialog.this.fDescriptionText.setText(ofd.getDescription());
                }
            }
        });
        this.fFiltersViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FilterSelectionDialog.this.updateSelectedCount();
            }
        });
        Label descTitle = new Label(composite, 16384);
        descTitle.setText(Messages.FilterSelectionDialog_TITLE);
        this.fDescriptionText = new Text(composite, 2632);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fDescriptionText.setLayoutData((Object)gd);
        this.fSelectedCount = new Label(composite, 16384);
        this.updateSelectedCount();
        Composite selectButtons = new Composite(composite, 0);
        gd = new GridData(768);
        selectButtons.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, false);
        selectButtons.setLayout((Layout)gl);
        Button selectAll = new Button(selectButtons, 8);
        selectAll.setText(Messages.FilterSelectionDialog_BUTTON_SELECT_ALL);
        gd = new GridData(768);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterSelectionDialog.this.fFiltersViewer.setAllChecked(true);
                FilterSelectionDialog.this.updateSelectedCount();
            }
        });
        Button deselectAll = new Button(selectButtons, 8);
        deselectAll.setText(Messages.FilterSelectionDialog_BUTTON_DESELECT_ALL);
        gd = new GridData(768);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterSelectionDialog.this.fFiltersViewer.setAllChecked(false);
                FilterSelectionDialog.this.updateSelectedCount();
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateSelectedCount() {
        this.fSelectedCount.setText(NLS.bind((String)Messages.FilterSelectionDialog_NUMBER_SELECTED, (Object[])new Object[]{this.fFiltersViewer.getCheckedElements().length, this.fAllFilters.length}));
    }

    public OutlineFilterDescriptor[] getCheckedFilters() {
        return this.fCheckedFilters;
    }
}

