/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor;

import com.ibm.team.apt.internal.common.wiki.transformer.IItemReferenceDetector;
import com.ibm.team.apt.internal.common.wiki.transformer.Token;
import com.ibm.team.apt.internal.common.wiki.transformer.WorkItemVariableResolver;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.apt.internal.ide.ui.editor.WikiFormPage2;
import com.ibm.team.apt.internal.ide.ui.util.Html;
import com.ibm.team.apt.internal.ide.ui.util.JS;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class DeferredVariableResolver
extends WorkItemVariableResolver {
    private static Cache<Location, IItemHandle> fCache = new Cache(123);
    private Mode fMode;
    private static long idPool = 0L;
    private IItemManager fManager;
    private WikiFormPage2.ScriptExecutor fScripts;
    private ResolveHelper fJob;

    public DeferredVariableResolver(Mode mode, IItemManager manager, WikiFormPage2.ScriptExecutor scripts) {
        this.fMode = mode;
        this.fManager = manager;
        this.fScripts = scripts;
        this.fJob = new ResolveHelper();
    }

    public String resolveWorkItemProperty(IItemReferenceDetector.Reference context, String property) {
        if (context == null) {
            return null;
        }
        Location location = context.getLocation();
        if (location == null) {
            return null;
        }
        String result = this.fJob.syncHandleRequest(location, property);
        if (result != null) {
            return result;
        }
        long id = DeferredVariableResolver.nextId();
        switch (this.fMode) {
            case Blocking: {
                Object value = this.fJob.resolveVariable(new Request(id, property, location), (IProgressMonitor)new NullProgressMonitor());
                return String.valueOf(value);
            }
            case SingleDispatch: {
                this.fJob.fRequests.add(new Request(id, property, location));
                this.fJob.schedule();
                break;
            }
            case CollectedDispatch: {
                this.fJob.fRequests.add(new Request(id, property, location));
            }
        }
        StringBuilder text = new StringBuilder();
        Html.SPAN.open(text, new Html.Attribute("id", String.valueOf(id)));
        Html.append(text, NLS.bind((String)Messages.DeferredVariableResolver_RESOLVING_LABEL));
        Html.SPAN.close(text);
        return text.toString();
    }

    public void resolve() {
        if (this.fMode == Mode.CollectedDispatch) {
            this.fJob.schedule();
        }
    }

    private static synchronized long nextId() {
        return idPool++;
    }

    protected static String script(Long[] ids, Object[] values) {
        StringBuilder script = new StringBuilder();
        script.append("replaceAll(");
        script.append(JS.toArray(ids));
        script.append(',');
        script.append(JS.toArray(values));
        script.append(')');
        script.append(';');
        return script.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private int fSize;

        public Cache(int size) {
            Assert.isLegal((size > 0 ? 1 : 0) != 0);
            this.fSize = size;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.fSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        Blocking,
        SingleDispatch,
        CollectedDispatch;

    }

    public class Request {
        public final long id;
        public final String property;
        public final Location location;

        public Request(long id, String property, Location location) {
            this.id = id;
            this.property = property;
            this.location = location;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolveHelper
    extends FoundationJob {
        private List<Request> fRequests;

        public ResolveHelper() {
            super("");
            this.fRequests = Collections.synchronizedList(new ArrayList());
            this.setSystem(true);
            this.setPriority(10);
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            if (!this.fRequests.isEmpty()) {
                if (this.fRequests.size() == 1) {
                    Request request = this.fRequests.remove(0);
                    Object value = this.resolveVariable(request, monitor);
                    String script = DeferredVariableResolver.script(new Long[]{request.id}, new Object[]{value});
                    DeferredVariableResolver.this.fScripts.post(script);
                } else {
                    String script = this.resolveVariablesAndCreateScripts(this.fRequests, monitor);
                    this.fRequests.clear();
                    DeferredVariableResolver.this.fScripts.post(script);
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * Unable to fully structure code
         */
        protected String resolveVariablesAndCreateScripts(List<Request> requests, IProgressMonitor monitor) {
            jsScript = null;
            locations = new ArrayList<Location>(requests.size());
            properties = new HashSet<String>();
            result = new HashMap<Long, Object>();
            for (Request request : requests) {
                locations.add(request.location);
                properties.add(request.property);
                result.put(request.id, String.valueOf(Token.VAR_START.wiki) + request.property + Token.VAR_END.wiki);
            }
            try {
                try {
                    items = DeferredVariableResolver.access$1(DeferredVariableResolver.this).fetchPartialItemsByLocation(locations, 0, properties, monitor);
                    iter = items.listIterator();
                    while (iter.hasNext()) {
                        next = (IItem)iter.next();
                        if (next == null) continue;
                        index = iter.nextIndex() - 1;
                        request = requests.get(index);
                        id = request.id;
                        value = request.property;
                        try {
                            value = ((Item)next).getPropertyValue(request.property);
                            result.put(id, value);
                        }
                        catch (IllegalArgumentException v0) {}
                        DeferredVariableResolver.access$2().put(request.location, next.getItemHandle());
                    }
                }
                catch (ItemNotFoundException v1) {
                    jsScript = DeferredVariableResolver.script(result.keySet().toArray(new Long[0]), result.values().toArray());
                }
                catch (IllegalArgumentException v2) {
                    ** try [egrp 3[TRYBLOCK] [5 : 340->341)] { 
lbl39:
                    // 1 sources

                    jsScript = DeferredVariableResolver.script(result.keySet().toArray(new Long[0]), result.values().toArray());
                }
                catch (TeamRepositoryException v3) {
                    ** try [egrp 4[TRYBLOCK] [6 : 379->380)] { 
lbl-1000:
                    // 2 sources

                    {
                        catch (Throwable var15_14) {
                            throw var15_14;
                        }
                    }
lbl45:
                    // 1 sources

                    jsScript = DeferredVariableResolver.script(result.keySet().toArray(new Long[0]), result.values().toArray());
                }
            }
            finally {
                jsScript = DeferredVariableResolver.script(result.keySet().toArray(new Long[0]), result.values().toArray());
            }
            return jsScript;
        }

        protected Object resolveVariable(Request request, IProgressMonitor monitor) {
            Object value = String.valueOf(Token.VAR_START.wiki) + request.property + Token.VAR_END.wiki;
            try {
                IItem item = DeferredVariableResolver.this.fManager.fetchPartialItem(request.location, 0, (Collection)Arrays.asList(request.property), monitor);
                fCache.put(request.location, item.getItemHandle());
                value = ((Item)item).getPropertyValue(request.property);
            }
            catch (ItemNotFoundException itemNotFoundException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (TeamRepositoryException teamRepositoryException) {}
            return value;
        }

        protected String syncHandleRequest(Location location, String property) {
            IItemHandle handle = location.getItemHandle();
            if (handle == null && (handle = (IItemHandle)fCache.get(location)) == null) {
                return null;
            }
            IItem item = DeferredVariableResolver.this.fManager.getSharedItemIfKnown(handle);
            if (item != null && this.isPropertySet(item, property)) {
                Object object = ((Item)item).getPropertyValue(property);
                return String.valueOf(object);
            }
            return null;
        }

        protected boolean isPropertySet(IItem item, String property) {
            try {
                return item.isPropertySet(property);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
    }
}

