/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanDefinition;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class WeekTimeSpanFactory
extends TimeSpanFactory {
    private Date fReferenceTime = new Date();
    private static final Date fExpiryTime = new Date(Long.MAX_VALUE);
    private final List<TimeSpanDefinition> fTimeSpans = new ArrayList<TimeSpanDefinition>();

    public TimeSpanDefinition findTimeSpan(Timespan scheduledTime, boolean isResolved) {
        if (scheduledTime == null) {
            return TimeSpanDefinition.UNSCHEDULED;
        }
        Date when = isResolved ? scheduledTime.getEnd() : scheduledTime.getStart();
        int low = 0;
        int high = this.fTimeSpans.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            TimeSpanDefinition value = this.fTimeSpans.get(mid);
            if (value.isInGroup(when, isResolved)) {
                return value;
            }
            if (value.getStartTime().after(when)) {
                high = mid - 1;
                continue;
            }
            Assert.isTrue((!value.getEndTime().after(when) ? 1 : 0) != 0);
            low = mid + 1;
        }
        TimeSpanDefinition.TimeSpanWeek result = new TimeSpanDefinition.TimeSpanWeek(when);
        result.refreshTimestamps(this.fReferenceTime);
        this.fTimeSpans.add(low, result);
        return result;
    }

    public void updateTimespans(Date referenceTime) {
        this.fReferenceTime = referenceTime;
        this.fTimeSpans.clear();
    }

    public Date getExpiryTime() {
        return fExpiryTime;
    }
}

