/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.apt.internal.ide.ui.common.structure.Messages;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimeSpanDefinition
implements Comparable<TimeSpanDefinition> {
    public static final TimeSpanDefinition UNSCHEDULED = new UnscheduledTimeSpan();
    private final String fLabel;
    private long fReferenceTime;
    private Date fExpiryTime;
    private Date fStartTime;
    private Date fEndTime;

    public TimeSpanDefinition(String label) {
        this.fLabel = label;
    }

    public boolean isInGroup(Date when, boolean resolved) {
        this.ensureInitialized();
        return (this.fStartTime.equals(when) || this.fStartTime.before(when)) && this.fEndTime.after(when);
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void refreshTimestamps(Date reference) {
        this.fReferenceTime = reference.getTime();
        this.fExpiryTime = null;
        this.fEndTime = null;
        this.fStartTime = null;
        this.ensureInitialized();
    }

    public Date getStartTime() {
        this.ensureInitialized();
        return this.fStartTime;
    }

    public Date getEndTime() {
        this.ensureInitialized();
        return this.fEndTime;
    }

    public Date getExpiryTime() {
        this.ensureInitialized();
        return this.fExpiryTime;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().isInstance(o);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean before(TimeSpanDefinition timeSpan) {
        return timeSpan.compareTo(timeSpan) < 0;
    }

    public boolean after(TimeSpanDefinition timeSpan) {
        return timeSpan.compareTo(timeSpan) > 0;
    }

    @Override
    public int compareTo(TimeSpanDefinition timeSpan) {
        return (int)Math.signum(this.calculateComparisonValue() - timeSpan.calculateComparisonValue());
    }

    protected abstract Date calculateStartTime();

    protected abstract Date calculateEndTime();

    protected Date calculateExpiryTime() {
        return this.toTimestamp(this.add(this.getToday(), 6, 1));
    }

    protected Date getReference() {
        return new Date(this.fReferenceTime);
    }

    protected Calendar getNow() {
        Calendar result = Calendar.getInstance();
        result.setTimeInMillis(this.fReferenceTime);
        return result;
    }

    protected Calendar getToday() {
        Calendar calendar = this.getNow();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    protected Calendar getThisWeek() {
        Calendar calendar = this.getToday();
        calendar.set(7, 2);
        return calendar;
    }

    protected Calendar add(Calendar calendar, int field, int delta) {
        calendar.add(field, delta);
        return calendar;
    }

    protected Date toTimestamp(Calendar calendar) {
        return new Date(calendar.getTimeInMillis());
    }

    protected Date min(Date first, Date second) {
        return Dates.compareTo((Date)first, (Date)second) < 0 ? first : second;
    }

    private long calculateComparisonValue() {
        long start = this.getStartTime().getTime();
        long end = this.getEndTime().getTime();
        return start + (end - start) / 2L;
    }

    private void ensureInitialized() {
        if (this.fStartTime == null || this.fEndTime == null || this.fExpiryTime == null) {
            if (this.fReferenceTime == 0L) {
                this.fReferenceTime = System.currentTimeMillis();
            }
            this.fExpiryTime = this.calculateExpiryTime();
            this.fStartTime = this.calculateStartTime();
            this.fEndTime = this.calculateEndTime();
        }
    }

    private static class StateAwareTimeSpan
    extends TimeSpanDefinition {
        private final long fOverlap;
        private boolean fPastTimespan;

        public StateAwareTimeSpan(String label, boolean isPast, long overlap) {
            super(label);
            this.fOverlap = overlap;
            this.fPastTimespan = isPast;
        }

        public boolean isInGroup(Date when, boolean resolved) {
            return resolved == this.fPastTimespan && super.isInGroup(when, resolved);
        }

        protected Date calculateStartTime() {
            return new Date(this.getNow().getTimeInMillis() - this.fOverlap);
        }

        protected Date calculateEndTime() {
            return new Date(this.getNow().getTimeInMillis() + this.fOverlap);
        }

        public boolean equals(Object o) {
            return super.equals(o) && o instanceof StateAwareTimeSpan && this.fPastTimespan == ((StateAwareTimeSpan)o).fPastTimespan;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + super.hashCode();
            result = 31 * result + (this.fPastTimespan ? 1231 : 1237);
            return result;
        }
    }

    public static class TimeSpanClosed
    extends StateAwareTimeSpan {
        public TimeSpanClosed() {
            this(0L);
        }

        public TimeSpanClosed(long pastOverlap) {
            super(Messages.TimeSpanDefinition_CLOSED, true, pastOverlap);
        }

        protected Date calculateStartTime() {
            return new Date(0L);
        }
    }

    public static class TimeSpanEarlierThisWeek
    extends StateAwareTimeSpan {
        public TimeSpanEarlierThisWeek() {
            this(0L);
        }

        public TimeSpanEarlierThisWeek(long futureOverlap) {
            super(Messages.TimeSpanDefinition_EARLIER_THIS_WEEK, true, futureOverlap);
        }

        protected Date calculateStartTime() {
            return this.toTimestamp(this.getThisWeek());
        }

        protected Date calculateExpiryTime() {
            return this.min(super.calculateExpiryTime(), this.toTimestamp(this.add(this.getThisWeek(), 3, 1)));
        }
    }

    public static class TimeSpanEarlierToday
    extends StateAwareTimeSpan {
        public TimeSpanEarlierToday() {
            this(0L);
        }

        public TimeSpanEarlierToday(long futureOverlap) {
            super(Messages.TimeSpanDefinition_EARLIER_TODAY, true, futureOverlap);
        }

        protected Date calculateStartTime() {
            return this.toTimestamp(this.getToday());
        }

        protected Date calculateExpiryTime() {
            return this.min(super.calculateExpiryTime(), this.toTimestamp(this.add(this.getToday(), 6, 1)));
        }
    }

    public static class TimeSpanFuture
    extends StateAwareTimeSpan {
        public TimeSpanFuture() {
            this(0L);
        }

        public TimeSpanFuture(long pastOverlap) {
            super(Messages.TimeSpanDefinition_FUTURE, false, pastOverlap);
        }

        public TimeSpanFuture(String label, long pastOverlap) {
            super(label, false, pastOverlap);
        }

        protected Date calculateEndTime() {
            return new Date(0x7FFFFFFFFFFFFFFEL);
        }
    }

    public static class TimeSpanLastWeek
    extends TimeSpanWeekRelative {
        public TimeSpanLastWeek() {
            super(Messages.TimeSpanDefinition_LAST_WEEK, -1);
        }
    }

    public static class TimeSpanLaterThisWeek
    extends StateAwareTimeSpan {
        public TimeSpanLaterThisWeek() {
            this(0L);
        }

        public TimeSpanLaterThisWeek(long pastOverlap) {
            super(Messages.TimeSpanDefinition_LATER_THIS_WEEK, false, pastOverlap);
        }

        protected Date calculateEndTime() {
            return this.toTimestamp(this.add(this.getThisWeek(), 3, 1));
        }

        protected Date calculateExpiryTime() {
            return this.min(super.calculateExpiryTime(), this.toTimestamp(this.add(this.getThisWeek(), 3, 1)));
        }
    }

    public static class TimeSpanLaterToday
    extends StateAwareTimeSpan {
        public TimeSpanLaterToday() {
            this(0L);
        }

        public TimeSpanLaterToday(long pastOverlap) {
            super(Messages.TimeSpanDefinition_TODAY, false, pastOverlap);
        }

        public TimeSpanLaterToday(String label, long pastOverlap) {
            super(label, false, pastOverlap);
        }

        protected Date calculateEndTime() {
            return this.toTimestamp(this.add(this.getToday(), 6, 1));
        }

        protected Date calculateExpiryTime() {
            return this.min(super.calculateExpiryTime(), this.toTimestamp(this.add(this.getToday(), 6, 1)));
        }
    }

    public static class TimeSpanNextWeek
    extends TimeSpanWeekRelative {
        public TimeSpanNextWeek() {
            super(Messages.TimeSpanDefinition_NEXT_WEEK, 1);
        }
    }

    public static class TimeSpanOpen
    extends StateAwareTimeSpan {
        public TimeSpanOpen() {
            this(0L);
        }

        public TimeSpanOpen(long pastOverlap) {
            super(Messages.TimeSpanDefinition_OPEN, false, pastOverlap);
        }

        protected Date calculateEndTime() {
            return new Date(0x7FFFFFFFFFFFFFFEL);
        }
    }

    public static class TimeSpanPast
    extends StateAwareTimeSpan {
        public TimeSpanPast() {
            this(0L);
        }

        public TimeSpanPast(long futureOverlap) {
            super(Messages.TimeSpanDefinition_PAST, true, futureOverlap);
        }

        protected Date calculateStartTime() {
            return new Date(0L);
        }
    }

    public static class TimeSpanTomorrow
    extends TimeSpanDefinition {
        public TimeSpanTomorrow() {
            super(Messages.TimeSpanDefinition_TOMORROW);
        }

        protected Date calculateStartTime() {
            return this.toTimestamp(this.add(this.getToday(), 6, 1));
        }

        protected Date calculateEndTime() {
            return this.toTimestamp(this.add(this.getToday(), 6, 2));
        }

        protected Date calculateExpiryTime() {
            return this.toTimestamp(this.add(this.getToday(), 6, 1));
        }
    }

    public static class TimeSpanWeek
    extends TimeSpanDefinition {
        private String fLabel;
        private Date fTimeInWeek;

        public TimeSpanWeek(Date timeInWeek) {
            super(Messages.TimeSpanDefinition_WEEK);
            this.fTimeInWeek = timeInWeek;
            this.refreshTimestamps(new Date(System.currentTimeMillis()));
        }

        public void refreshTimestamps(Date reference) {
            this.fLabel = null;
            if (this.fTimeInWeek != null) {
                super.refreshTimestamps(reference);
            }
        }

        public String getLabel() {
            if (this.fLabel == null) {
                Date reference = this.getReference();
                Date startTime = this.getStartTime();
                Date endTime = this.getEndTime();
                this.fLabel = startTime.before(reference) && endTime.after(reference) ? Messages.TimeSpanDefinition_THIS_WEEK : MessageFormat.format(Messages.TimeSpanDefinition_SPECIFIC_WEEK, startTime, endTime);
            }
            return this.fLabel;
        }

        protected Date calculateStartTime() {
            return this.toTimestamp(this.getSpecifiedWeek());
        }

        protected Date calculateEndTime() {
            return this.toTimestamp(this.add(this.getSpecifiedWeek(), 3, 1));
        }

        private Calendar getSpecifiedWeek() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.fTimeInWeek);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.set(7, 2);
            return calendar;
        }

        public boolean equals(Object o) {
            return super.equals(o) && o instanceof TimeSpanWeek && this.getStartTime().equals(((TimeSpanWeek)o).getStartTime());
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + super.hashCode();
            result = 31 * result + this.getStartTime().hashCode();
            return result;
        }
    }

    public static class TimeSpanWeekRelative
    extends TimeSpanDefinition {
        private final int fWeekShift;

        public TimeSpanWeekRelative(String label, int weekShift) {
            super(label);
            this.fWeekShift = weekShift;
        }

        protected Date calculateStartTime() {
            return this.toTimestamp(this.add(this.getThisWeek(), 3, this.fWeekShift));
        }

        protected Date calculateEndTime() {
            return this.toTimestamp(this.add(this.getThisWeek(), 3, this.fWeekShift + 1));
        }

        protected Date calculateExpiryTime() {
            return this.toTimestamp(this.add(this.getThisWeek(), 3, 1));
        }
    }

    public static class TimeSpanYesterday
    extends TimeSpanDefinition {
        public TimeSpanYesterday() {
            super(Messages.TimeSpanDefinition_YESTERDAY);
        }

        protected Date calculateStartTime() {
            return this.toTimestamp(this.add(this.getToday(), 6, -1));
        }

        protected Date calculateEndTime() {
            return this.toTimestamp(this.getToday());
        }

        protected Date calculateExpiryTime() {
            return this.toTimestamp(this.add(this.getToday(), 6, 1));
        }
    }

    private static final class UnscheduledTimeSpan
    extends TimeSpanDefinition {
        public UnscheduledTimeSpan() {
            super(Messages.TimeSpanDefinition_UNKNOWN);
        }

        protected Date calculateEndTime() {
            return new Date(0L);
        }

        protected Date calculateStartTime() {
            return new Date(0L);
        }

        protected Date calculateExpiryTime() {
            return new Date(Long.MAX_VALUE);
        }
    }
}

