/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelUpdater;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressUpdater<T> {
    private PlanModelTransformer fTransformer;
    private Class<T> fClass;
    private static final Set<Attribute> AFFECTS_FOLDER_PROGRESS = new HashSet<Attribute>();

    public ProgressUpdater(PlanModelTransformer transformer, Class<T> clazz) {
        AFFECTS_FOLDER_PROGRESS.add(PlanItem.STATE);
        AFFECTS_FOLDER_PROGRESS.add(PlanItem.ESTIMATE);
        AFFECTS_FOLDER_PROGRESS.add(PlanItem.CORRECTED_ESTIMATE);
        AFFECTS_FOLDER_PROGRESS.add(PlanItem.TIMESPENT);
        AFFECTS_FOLDER_PROGRESS.add(PlanItem.AUXILIARY_ITEM);
        this.fClass = clazz;
        this.fTransformer = transformer;
    }

    protected PlanModelTransformer getTransformer() {
        return this.fTransformer;
    }

    public void processElementAdded(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor) {
        if (!(delta.getPlanElement() instanceof PlanItem)) {
            return;
        }
        this.updateTopLevelProgress(this.getTopLevelParents(delta, updateAccessor, true), updateAccessor);
        this.updateFolderProgress(this.getParentFolders(delta, updateAccessor, true), updateAccessor);
    }

    public void processElementRemoved(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor) {
        if (!(delta.getPlanElement() instanceof PlanItem)) {
            return;
        }
        this.updateTopLevelProgress(this.getTopLevelParents(delta, updateAccessor, false), updateAccessor);
        this.updateFolderProgress(this.getParentFolders(delta, updateAccessor, true), updateAccessor);
    }

    public void processElementMoved(IPlanElementDelta removeDelta, IPlanElementDelta addDelta, IOutlineModelUpdater updateAccessor) {
        if (!(removeDelta.getPlanElement() instanceof PlanItem) || !(addDelta.getPlanElement() instanceof PlanItem)) {
            return;
        }
        List<PlanItem> removedParents = this.getTopLevelParents(removeDelta, updateAccessor, false);
        HashSet<PlanItem> addParents = new HashSet<PlanItem>(this.getTopLevelParents(addDelta, updateAccessor, true));
        ArrayList<PlanItem> parentsToUpdate = new ArrayList<PlanItem>();
        for (PlanItem planItem : removedParents) {
            if (addParents.remove(planItem)) continue;
            parentsToUpdate.add(planItem);
        }
        parentsToUpdate.addAll(addParents);
        this.updateTopLevelProgress(parentsToUpdate, updateAccessor);
        List<OutlineEntry<T>> removedFolders = this.getParentFolders(removeDelta, updateAccessor, false);
        HashSet<OutlineEntry<T>> addFolders = new HashSet<OutlineEntry<T>>(this.getParentFolders(addDelta, updateAccessor, true));
        ArrayList<OutlineEntry<T>> foldersToUpdate = new ArrayList<OutlineEntry<T>>();
        for (OutlineEntry outlineEntry : removedFolders) {
            if (addFolders.remove(outlineEntry)) continue;
            foldersToUpdate.add(outlineEntry);
        }
        foldersToUpdate.addAll(addFolders);
        this.updateFolderProgress(foldersToUpdate, updateAccessor);
    }

    public void processElementChanged(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor) {
        if (!(delta.getPlanElement() instanceof PlanItem)) {
            return;
        }
        if (this.affectsFolderProgress(delta)) {
            this.updateFolderProgress(this.getParentFolders(delta, updateAccessor, true), updateAccessor);
        }
        if (this.affectsTopLevelItem(delta)) {
            this.updateTopLevelProgress(this.getTopLevelParents(delta, updateAccessor, true), updateAccessor);
        }
    }

    private boolean affectsTopLevelItem(IPlanElementDelta delta) {
        return delta.getAttributeDelta(PlanItem.STATE) != null;
    }

    private List<PlanItem> getTopLevelParents(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor, boolean newValue) {
        ArrayList<PlanItem> result = new ArrayList<PlanItem>();
        List<PlanModelTransformer.ElementInfo> elementInfoPath = this.fTransformer.getElementInfoPath(delta, newValue);
        if (elementInfoPath.isEmpty()) {
            return result;
        }
        PlanElement element = elementInfoPath.get(0).getPlanElement();
        if (!(element instanceof PlanItem)) {
            return result;
        }
        Collection<OutlineEntry<PlanItem>> entries = updateAccessor.getElementEntries((PlanItem)element);
        OutlineEntry<Object> current = null;
        for (OutlineEntry<PlanItem> entry : entries) {
            if (!entry.hasTag(PrimaryLocationTag.INSTANCE)) continue;
            current = entry;
            break;
        }
        while (current != null) {
            PlanItem currentElement;
            if (current.hasTag(PrimaryLocationTag.INSTANCE) && EntryUtils.isType(current, PlanItem.class) && (currentElement = (PlanItem)current.getElement()).isTopLevelPlanItem()) {
                result.add(currentElement);
            }
            current = updateAccessor.getParent(current);
        }
        return result;
    }

    private void updateTopLevelProgress(List<PlanItem> items, IOutlineModelUpdater updateAccessor) {
        for (PlanItem item : items) {
            for (OutlineEntry<PlanItem> entry : updateAccessor.getElementEntries(item)) {
                updateAccessor.update(entry, new String[]{"progress"});
            }
        }
    }

    protected boolean affectsFolderProgress(IPlanElementDelta delta) {
        IPlanAttributeDelta[] attributeDeltas;
        IPlanAttributeDelta[] iPlanAttributeDeltaArray = attributeDeltas = delta.getAttributeDeltas();
        int n = attributeDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IPlanAttributeDelta attributeDelta = iPlanAttributeDeltaArray[n2];
            if (AFFECTS_FOLDER_PROGRESS.contains(attributeDelta.getAttribute())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private List<OutlineEntry<T>> getParentFolders(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor, boolean newValue) {
        ArrayList<OutlineEntry<T>> result = new ArrayList<OutlineEntry<T>>();
        List<PlanModelTransformer.ElementInfo> elementInfoPath = this.fTransformer.getElementInfoPath(delta, newValue);
        if (elementInfoPath.isEmpty()) {
            return result;
        }
        PlanElement element = elementInfoPath.get(0).getPlanElement();
        if (!(element instanceof PlanItem)) {
            return result;
        }
        Collection<OutlineEntry<PlanItem>> entries = updateAccessor.getElementEntries((PlanItem)element);
        OutlineEntry<Object> current = null;
        for (OutlineEntry<PlanItem> entry : entries) {
            if (!entry.hasTag(PrimaryLocationTag.INSTANCE)) continue;
            current = entry;
            break;
        }
        while (current != null) {
            if (EntryUtils.isType(current, this.fClass)) {
                result.add(current);
            }
            current = updateAccessor.getParent(current);
        }
        return result;
    }

    private void updateFolderProgress(List<OutlineEntry<T>> folders, IOutlineModelUpdater updateAccessor) {
        for (OutlineEntry<T> folder : folders) {
            updateAccessor.update(folder, new String[]{"progress"});
        }
    }
}

