/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelUpdater;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanDefinition;
import com.ibm.team.apt.internal.ide.ui.common.structure.TimeSpanFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlanModelSequenceTransformer
extends PlanModelTransformer {
    private TimeSpanFactory fTimeSpanFactory;

    public PlanModelSequenceTransformer(TimeSpanFactory timeSpanFactory, Collection<Attribute> structureAttributes) {
        super(structureAttributes);
        this.fTimeSpanFactory = timeSpanFactory;
    }

    public Date getTimeSpanExpiration() {
        return this.fTimeSpanFactory.getExpiryTime();
    }

    @Override
    protected void onBeginRefresh() {
        ResolvedPlan plan = this.getPlan();
        if (plan != null) {
            this.fTimeSpanFactory.updateTimespans(plan.getReferenceTime());
        }
        super.onBeginRefresh();
    }

    @Override
    protected boolean isElementIncluded(PlanElement element) {
        return element instanceof IScheduleItem;
    }

    @Override
    protected List<PlanElement> doTransformElementPath(GroupElement[] groupPath, List<PlanModelTransformer.ElementInfo> elementInfoPath) {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected boolean doProcessPlanChanged(IPlanElementDelta delta, IOutlineModelUpdater updateAccessor) {
        if (delta.affectsAttribute(ResolvedPlan.RESOURCE_PLANNING)) {
            this.getViewModel().viewerPreservingRefresh();
            return false;
        }
        return super.doProcessPlanChanged(delta, updateAccessor);
    }

    protected TimeSpanDefinition findTimeSpan(Timespan scheduledTime, boolean isResolved) {
        if (!isResolved && scheduledTime != null) {
            Date planReferenceTime = this.getPlan().getReferenceTime();
            if (scheduledTime.getStart().before(planReferenceTime)) {
                scheduledTime = new Timespan(planReferenceTime, scheduledTime.getEnd());
            }
        }
        return this.fTimeSpanFactory.findTimeSpan(scheduledTime, isResolved);
    }
}

