/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.common.APTCommon;
import com.ibm.team.apt.internal.client.IPlanElementVisitor;
import com.ibm.team.apt.internal.client.IPlanItemAttributeSetter;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.ide.ui.common.PlanCanvas;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelUpdater;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUnlockedRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUpdateRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.Messages;
import com.ibm.team.apt.internal.ide.ui.common.structure.PrimaryLocationTag;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanItemOutlineItem;
import com.ibm.team.apt.internal.ide.ui.util.DisplayCallable;
import com.ibm.team.apt.internal.ide.ui.util.DisplayRunnable;
import com.ibm.team.apt.internal.ide.ui.util.ExceptionHandler;
import com.ibm.team.apt.internal.ide.ui.util.TeamRunnable;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemMovePolicy {
    public DropLocation validateDrop(IStructuredSelection sourceSelection, OutlineEntry<?> targetEntry, DropLocation location, DropTargetEvent event) {
        return DropLocation.None;
    }

    public boolean drop(IStructuredSelection sourceSelection, OutlineEntry<?> targetEntry, DropLocation location, DropTargetEvent event, IProgressService progressService) {
        return false;
    }

    public boolean canIncreaseIndent(OutlineEntry<?> entry) {
        return false;
    }

    public void increaseIndent(OutlineEntry<?> entry) {
        throw new UnsupportedOperationException();
    }

    public boolean canDecreaseIndent(OutlineEntry<?> entry) {
        return false;
    }

    public void decreaseIndent(OutlineEntry<?> entry) {
        throw new UnsupportedOperationException();
    }

    public boolean canMoveUp(OutlineEntry<?> entry) {
        return false;
    }

    public void moveUp(OutlineEntry<?> entry) {
        throw new UnsupportedOperationException();
    }

    public boolean canMoveDown(OutlineEntry<?> entry) {
        return false;
    }

    public void moveDown(OutlineEntry<?> entry) {
        throw new UnsupportedOperationException();
    }

    public boolean canAddItemAbove(OutlineEntry<?> entry) {
        return false;
    }

    public void addItemAbove(OutlineEntry<?> entry, String workItemType, IRunnableContext context) throws TeamRepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean canAddItemBelow(OutlineEntry<?> entry) {
        return false;
    }

    public void addItemBelow(OutlineEntry<?> entry, String workItemType, IRunnableContext context) throws TeamRepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean canAddItemToGroup(OutlineEntry<GroupElement> groupEntry) {
        return true;
    }

    public void addItemToGroup(final OutlineEntry<GroupElement> groupEntry, final String workItemType, final IRunnableContext context) throws TeamRepositoryException {
        final PlanViewModel viewModel = this.getViewModel(groupEntry);
        viewModel.updateModel(new ModelUpdateRunnable<Void, TeamRepositoryException>(){

            @Override
            public Void run(IOutlineModelUpdater updateAccessor) throws TeamRepositoryException {
                ResolvedPlan plan = ItemMovePolicy.this.getPlan(groupEntry);
                ItemMovePolicy.this.addItem(viewModel, (PlanElement)plan, new IPlanItemAttributeSetter(){

                    public String getWorkItemTypeIdentifier() {
                        return workItemType;
                    }

                    public void setAttributes(PlanItem item, IProgressMonitor monitor) throws TeamRepositoryException {
                        ((GroupElement)groupEntry.getElement()).adopt((PlanElement)item, groupEntry, monitor);
                    }
                }, null, updateAccessor, context);
                return null;
            }
        });
    }

    protected PlanViewModel getViewModel(OutlineEntry<?> entry) {
        return (PlanViewModel)entry.getModel();
    }

    protected ResolvedPlan getPlan(OutlineEntry<?> entry) {
        return (ResolvedPlan)entry.getModel().getInput();
    }

    protected boolean isPlanItemInPrimaryGroup(OutlineEntry<?> entry) {
        return EntryUtils.isType(entry, PlanItem.class) && entry.hasTag(PrimaryLocationTag.INSTANCE) && !((PlanItem)entry.getElement()).isProgressPlanItem();
    }

    protected boolean isIncompatibleTeamRepository(Object source, OutlineEntry<?> targetEntry) {
        IItemHandle sourceHandle = null;
        if (source instanceof IItemHandle) {
            sourceHandle = (IItemHandle)source;
        } else if (source instanceof PlanItem) {
            sourceHandle = ((PlanItem)source).getWorkItemHandle();
        }
        if (sourceHandle == null) {
            return false;
        }
        return !PlanningClientPlugin.sameRepository((IItemHandle)this.getPlan(targetEntry).getProjectArea(), (IItemHandle)sourceHandle);
    }

    protected boolean isIncompatibleProjectArea(Object source, OutlineEntry<?> targetEntry) {
        IProjectAreaHandle sourceProjectArea = this.getProjectArea(source);
        IProjectAreaHandle targetProjectArea = null;
        if (EntryUtils.isType(targetEntry, PlanItem.class)) {
            targetProjectArea = this.getProjectArea(targetEntry.getElement());
        } else {
            ResolvedPlan plan = this.getPlan(targetEntry);
            if (plan instanceof ResolvedIterationPlan) {
                targetProjectArea = ((ResolvedIterationPlan)plan).getProjectAreaHandle();
            }
        }
        if (sourceProjectArea == null || targetProjectArea == null) {
            return false;
        }
        return !sourceProjectArea.getItemId().equals((Object)targetProjectArea.getItemId());
    }

    protected void addItem(final PlanViewModel viewModel, final PlanElement modelParent, final IPlanItemAttributeSetter initializer, OutlineEntry<? extends PlanElement> moveBefore, IOutlineModelUpdater updateAccessor, final IRunnableContext context) throws TeamRepositoryException {
        final PlanCanvas outline = viewModel.getViewer().getOutline();
        outline.storeData();
        EntryNavigator n = updateAccessor.getEntryNavigator(true);
        final ResolvedPlan plan = (ResolvedPlan)viewModel.getInput();
        final PlanItem planItem = updateAccessor.executeUnlocked(new ModelUnlockedRunnable<PlanItem, TeamRepositoryException>(){

            @Override
            public PlanItem run() throws TeamRepositoryException {
                final PlanItem[] newPlanItem = new PlanItem[1];
                try {
                    context.run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                        public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, TeamRepositoryException {
                            newPlanItem[0] = plan.createNewPlanItem(modelParent, initializer, monitor);
                        }
                    });
                }
                catch (InterruptedException e) {
                    if (e.getCause() instanceof TeamRepositoryException) {
                        throw (TeamRepositoryException)e.getCause();
                    }
                    throw new TeamRepositoryException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof TeamRepositoryException) {
                        throw (TeamRepositoryException)e.getCause();
                    }
                    throw new TeamRepositoryException((Throwable)e);
                }
                return newPlanItem[0];
            }
        });
        if (planItem != null) {
            final OutlineEntry<PlanItem> primaryEntry = n.findPrimaryEntry(planItem);
            OutlineEntry<?> primaryEntryParent = n.parentEntry(primaryEntry);
            int targetIndex = 0;
            if (moveBefore != null && primaryEntryParent == n.parentEntry(moveBefore)) {
                targetIndex = n.index(moveBefore);
                if (targetIndex == -1) {
                    targetIndex = n.siblings(primaryEntry).size() - 1;
                }
            } else {
                List<OutlineEntry<PlanItem>> planItemEntries = EntryUtils.entriesOfType(n.childEntries(primaryEntryParent), PlanItem.class);
                int i = planItemEntries.size() - 1;
                while (i >= 0) {
                    OutlineEntry<PlanItem> candidateEntry = planItemEntries.get(i);
                    if (candidateEntry != primaryEntry) {
                        targetIndex = n.index(candidateEntry) + 1;
                        break;
                    }
                    --i;
                }
            }
            updateAccessor.move(primaryEntry, targetIndex);
            updateAccessor.executeAfterUpdate(new Runnable(){

                public void run() {
                    viewModel.setSelectedEntry(primaryEntry);
                    viewModel.revealEntry(primaryEntry);
                    OutlineItem newOutlineItem = viewModel.getViewer().findOutlineItem(primaryEntry);
                    ItemMovePolicy.this.itemAdded(planItem, newOutlineItem);
                    if (newOutlineItem instanceof PlanItemOutlineItem) {
                        outline.startEditSession(((PlanItemOutlineItem)newOutlineItem).getPlanItemGadget().getSummary());
                    }
                }
            });
        }
    }

    protected void itemAdded(PlanItem newPlanItem, OutlineItem newOutlineItem) {
    }

    protected boolean doResolveAndDrop(final IStructuredSelection sourceSelection, final IPlanItemAttributeSetter adopter, final PlanViewModel viewModel, DropTargetEvent event, IProgressService progressService) {
        boolean success = false;
        try {
            progressService.run(true, true, (IRunnableWithProgress)new TeamRunnable(){

                public void execute(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, TeamRepositoryException {
                    monitor.beginTask(Messages.ItemMovePolicy_MONITOR_DROP_WORKITEMS, sourceSelection.size() * 3);
                    viewModel.executeUnlocked(new ModelUnlockedRunnable<Void, TeamRepositoryException>(){

                        /*
                         * Unable to fully structure code
                         */
                        @Override
                        public Void run() throws TeamRepositoryException {
                            plan = (ResolvedPlan)viewModel.getInput();
                            workItemClient = PlanningClientPlugin.getWorkItemClient((ITeamRepository)plan.getTeamRepository());
                            workingCopyManager = workItemClient.getWorkItemWorkingCopyManager();
                            var7_4 = sourceSelection.toArray();
                            var6_5 = var7_4.length;
                            var5_6 = 0;
                            while (var5_6 < var6_5) {
                                source = var7_4[var5_6];
                                if (source instanceof IWorkItemHandle) {
                                    workItemHandle = (IWorkItemHandle)source;
                                    mustDisconnect = false;
                                    try {
                                        planItem = plan.getPlanItem((IWorkItemHandle)source);
                                        if (planItem == null) {
                                            plan.connectDeltaBuilder();
                                            try {
                                                workingCopyManager.connect(workItemHandle, APTCommon.getPlanItemWorkItemProfile((boolean)true), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                                mustDisconnect = true;
                                                changeableWorkItem = workingCopyManager.getWorkingCopy(workItemHandle).getWorkItem();
                                                plan.adopt(changeableWorkItem, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                                planItem = plan.getPlanItem(workItemHandle);
                                                if (planItem == null) ** GOTO lbl33
                                                planItem.modified();
                                            }
                                            finally {
                                                plan.disconnectDeltaBuilder();
                                            }
                                        } else if (!plan.matchesPlanQuery(planItem)) {
                                            plan.adopt(planItem.getWorkItem(true), (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                                        } else {
                                            monitor.worked(2);
                                        }
lbl33:
                                        // 4 sources

                                        if (planItem == null) ** GOTO lbl76
                                        adopter.setAttributes(planItem, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    }
                                    finally {
                                        if (mustDisconnect) {
                                            workingCopyManager.disconnect(workItemHandle);
                                        }
                                    }
                                } else if (source instanceof PlanItem) {
                                    planItem = (PlanItem)source;
                                    if (planItem.getPlan() != plan) {
                                        if (planItem.isDraftItem()) {
                                            control = viewModel.getViewer().getControl();
                                            summary = planItem.getHTMLSummary().getPlainText();
                                            text = summary.length() > 0 ? summary : WorkItemTextUtilities.getWorkItemId((IWorkItem)planItem.getWorkItem(false));
                                            new DisplayRunnable(control){

                                                protected void execute() {
                                                    MessageDialog.openInformation((Shell)control.getShell(), (String)Messages.ItemMovePolicy_DROP_NOT_SAVED_TITLE, (String)NLS.bind((String)Messages.ItemMovePolicy_DROP_NOT_SAVED_MESSAGE, (Object[])new Object[]{text}));
                                                }
                                            }.syncExec();
                                            planItem = null;
                                        } else {
                                            allChildren = new ArrayList<E>();
                                            parent = planItem;
                                            planItem.accept(new IPlanElementVisitor(){

                                                public boolean visit(PlanElement element) {
                                                    if (element != parent && element instanceof PlanItem) {
                                                        allChildren.add((PlanItem)element);
                                                    }
                                                    return true;
                                                }
                                            });
                                            result = null;
                                            if (!allChildren.isEmpty() && ((result = new DisplayCallable<Integer>(control = viewModel.getViewer().getControl(), summary = planItem.getHTMLSummary().getPlainText()){
                                                private final /* synthetic */ String val$summary;
                                                {
                                                    this.val$summary = string;
                                                    super($anonymous0);
                                                }

                                                @Override
                                                protected Integer execute() {
                                                    MessageDialog dialog = new MessageDialog(control.getShell(), Messages.ItemMovePolicy_DROP_HAS_CHILDREN_TITLE, null, NLS.bind((String)Messages.ItemMovePolicy_DROP_HAS_CHILDREN_MESSAGE, (Object[])new Object[]{this.val$summary}), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                                                    return dialog.open();
                                                }
                                            }.syncExec()).isOK() && (Integer)result.value == 1 || !result.isOK())) {
                                                allChildren.clear();
                                            }
                                            if (result == null || result.isOK() && (Integer)result.value != 2) {
                                                plan.adopt(planItem.getWorkItem(true), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                                planItem = plan.getPlanItem(planItem.getWorkItemHandle());
                                                planItem.modified();
                                                if (!allChildren.isEmpty()) {
                                                    childMonitor = new SubProgressMonitor(monitor, 1);
                                                    childMonitor.beginTask("", allChildren.size());
                                                    for (PlanItem child : allChildren) {
                                                        plan.adopt(child.getWorkItem(true), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)childMonitor, 1));
                                                        otherChild = plan.getPlanItem(child.getWorkItemHandle());
                                                        otherChild.modified();
                                                    }
                                                    childMonitor.done();
                                                }
                                            } else {
                                                planItem = null;
                                            }
                                        }
                                    }
                                    if (planItem != null) {
                                        adopter.setAttributes(planItem, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    }
                                } else {
                                    monitor.worked(3);
                                }
lbl76:
                                // 4 sources

                                ++var5_6;
                            }
                            return null;
                        }
                    });
                }
            });
            success = true;
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, viewModel.getViewer().getControl().getShell(), Messages.ItemMovePolicy_DROP_FAILED_TITLE, Messages.ItemMovePolicy_DROP_FAILED_MESSAGE);
            success = false;
        }
        catch (InterruptedException interruptedException) {
            success = false;
        }
        return success;
    }

    protected void doSelect(final IStructuredSelection source, final OutlineEntry<GroupElement> groupEntry) {
        PlanViewModel viewModel = this.getViewModel(groupEntry);
        final ResolvedPlan plan = this.getPlan(groupEntry);
        List<OutlineEntry<PlanItem>> toSelect = groupEntry.getModel().readModel(new ModelReadRunnable<List<OutlineEntry<PlanItem>>, RuntimeException>(){

            @Override
            public List<OutlineEntry<PlanItem>> run(IOutlineModelReader readAccessor) throws RuntimeException {
                EntryNavigator n = readAccessor.getEntryNavigator(true);
                ArrayList<OutlineEntry<PlanItem>> result = new ArrayList<OutlineEntry<PlanItem>>(source.size());
                Object[] objectArray = source.toArray();
                int n2 = objectArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    OutlineEntry<PlanItem> entry;
                    PlanItem planItem;
                    Object element = objectArray[n3];
                    if (element instanceof IWorkItemHandle && (planItem = plan.getPlanItem((IWorkItemHandle)element)) != null && (entry = n.findFirstEntryInSubtree(planItem, groupEntry)) != null) {
                        result.add(entry);
                    }
                    ++n3;
                }
                return result;
            }
        });
        viewModel.setSelectedEntries(toSelect);
    }

    private IProjectAreaHandle getProjectArea(Object element) {
        if (element instanceof IWorkItem) {
            return ((IWorkItem)element).getProjectArea();
        }
        if (element instanceof PlanItem) {
            return ((PlanItem)element).getPlan().getProjectArea();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DropLocation {
        None,
        Before,
        Onto,
        After,
        OntoUnderlayChildern,
        OntoParent;

    }
}

