/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.structure;

import com.ibm.team.apt.internal.client.IPlanElementVisitor;
import com.ibm.team.apt.internal.client.IterationPlanItem;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.common.myfolders.MyFolders;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupFolderElement
extends GroupElement {
    public static final GroupElement[] EMPTY_PATH = new GroupElement[0];
    private GroupFolderElement fParent;
    private UUID fId;
    private String fLabel;
    private int fIndex;

    GroupFolderElement(UUID id, String label, int index) {
        this(null, id, label, index);
    }

    GroupFolderElement(GroupFolderElement parent, UUID id, String label, int index) {
        Assert.isNotNull((Object)id);
        Assert.isTrue((label != null && label.length() > 0 ? 1 : 0) != 0);
        this.fParent = parent;
        this.fId = id;
        this.fLabel = label;
        this.fIndex = index;
    }

    @Override
    public boolean adopt(PlanElement toAdopt, OutlineEntry<? extends GroupElement> groupEntry, IProgressMonitor monitor) {
        GroupElement groupElement = groupEntry.getElement();
        if (!(groupElement instanceof GroupFolderElement) || !(toAdopt instanceof IterationPlanItem)) {
            return false;
        }
        IterationPlanItem planItem = (IterationPlanItem)toAdopt;
        ResolvedIterationPlan plan = planItem.getPlan();
        try {
            plan.connectDeltaBuilder();
            final UUID oldId = planItem.getFolderId();
            final UUID newId = ((GroupFolderElement)groupEntry.getElement()).getId();
            planItem.accept(new IPlanElementVisitor(){

                public boolean visit(PlanElement element) {
                    if (element instanceof IterationPlanItem) {
                        IterationPlanItem ipi = (IterationPlanItem)element;
                        if (oldId == null || oldId.equals((Object)ipi.getFolderId())) {
                            ipi.setFolderId(newId);
                        }
                    }
                    return true;
                }
            });
        }
        finally {
            plan.disconnectDeltaBuilder();
        }
        return true;
    }

    public GroupFolderElement getParent() {
        return this.fParent;
    }

    public void reparent(GroupFolderElement newParent) {
        this.fParent = newParent;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    public void setLabel(String label) {
        this.fLabel = label;
    }

    public UUID getId() {
        return this.fId;
    }

    public int getIndex() {
        return this.fIndex;
    }

    public GroupElement[] getPath() {
        GroupFolderElement folder = this;
        ArrayList<GroupFolderElement> result = new ArrayList<GroupFolderElement>();
        while (folder != null) {
            result.add(folder);
            folder = folder.getParent();
        }
        Collections.reverse(result);
        return result.toArray(new GroupElement[result.size()]);
    }

    public boolean isTopItemFolder() {
        return MyFolders.TOP_FOLDER_ID.equals((Object)this.fId);
    }

    public boolean isBugFolder() {
        return MyFolders.BUG_FOLDER_ID.equals((Object)this.fId);
    }

    @Override
    public int compareTo(GroupElement o) {
        if (o instanceof GroupFolderElement) {
            return this.fIndex - ((GroupFolderElement)o).fIndex;
        }
        return super.compareTo(o);
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.fId.equals((Object)((GroupFolderElement)o).fId);
    }

    public int hashCode() {
        return this.fId.hashCode();
    }
}

