/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryDefinition;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ContentProposalRecentQuery;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IQuickQueryListener;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryHelper;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryProposal;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryProposalProvider;
import com.ibm.team.apt.internal.ide.ui.quickquery.IParsedQuickQueryElement;
import com.ibm.team.apt.internal.ide.ui.quickquery.QuickQueryParser;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.expression.Expression;
import com.ibm.team.workitem.common.internal.expression.XMLExpressionSerializer;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickQueryTextField {
    private static final long DEFAULT_EXECUTION_DELAY = 500L;
    private final QuickQueryProposalProvider fQuickQueryProposalProvider;
    private Text fQuickQueryInput;
    private ControlDecoration fContentProposalDecoration;
    private QuickQueryParser fParsedCurrentQuery;
    private ListenerList fQuickQueryListeners = new ListenerList();
    private final QuickQueryEvaluationJob fFilterJob;
    private volatile long fLastModification;
    private Expression fLastExpression;
    private final IQuickQueryDefinition fQuickQueryDefinition;
    private final IQuickQueryContext fContext;
    private long fExecutionDelay = 500L;
    private Expression fCurrentExpression;

    public QuickQueryTextField(Composite parent, IQuickQueryDefinition quickQueryDefinition, IQuickQueryContext context) {
        this.fQuickQueryDefinition = quickQueryDefinition;
        this.fContext = context;
        this.fQuickQueryProposalProvider = new QuickQueryProposalProvider(quickQueryDefinition, context);
        this.fFilterJob = new QuickQueryEvaluationJob();
        this.createControl(parent);
    }

    public void setExecutionDelay(long delay) {
        this.fExecutionDelay = delay;
    }

    public void setText(String queryText) {
        this.fQuickQueryInput.setText(queryText);
    }

    public Iterator<IParsedQuickQueryElement> getParsedFilterIterator() {
        if (!this.fQuickQueryInput.isDisposed()) {
            this.fQuickQueryInput.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!(QuickQueryTextField.this.fQuickQueryInput.isDisposed() || QuickQueryTextField.this.fParsedCurrentQuery != null && QuickQueryTextField.this.fParsedCurrentQuery.getInput().equals(QuickQueryTextField.this.fQuickQueryInput.getText()))) {
                        QuickQueryTextField.this.fParsedCurrentQuery = new QuickQueryParser(QuickQueryTextField.this.fQuickQueryInput.getText());
                    }
                }
            });
        }
        return this.fParsedCurrentQuery != null ? this.fParsedCurrentQuery.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public void addListener(IQuickQueryListener listener) {
        this.fQuickQueryListeners.add((Object)listener);
    }

    public void removeListener(IQuickQueryListener listener) {
        this.fQuickQueryListeners.remove((Object)listener);
    }

    public Text getControl() {
        return this.fQuickQueryInput;
    }

    public Expression getFilterExpression(IProgressMonitor monitor) {
        this.fCurrentExpression = QuickQueryHelper.buildExpression(this.getParsedFilterIterator(), this.fQuickQueryDefinition, this.fContext, monitor);
        return this.fCurrentExpression;
    }

    public Expression getCurrentExpression() {
        return this.fCurrentExpression;
    }

    private void createControl(Composite parent) {
        this.fQuickQueryInput = new Text(parent, 2432);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.fQuickQueryInput);
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] activeBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        KeyStroke keyStroke = activeBindings.length != 0 && activeBindings[0].getTriggers().length > 0 && activeBindings[0].getTriggers()[0] instanceof KeyStroke ? (KeyStroke)activeBindings[0].getTriggers()[0] : KeyStroke.getInstance((int)SWT.MOD1, (int)32);
        this.fQuickQueryInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QuickQueryTextField.this.modifiedText();
            }
        });
        this.fContentProposalDecoration = new ControlDecoration((Control)this.fQuickQueryInput, 16512);
        this.fContentProposalDecoration.hide();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    QuickQueryTextField.this.fContentProposalDecoration.show();
                }
                if (event.type == 27) {
                    QuickQueryTextField.this.fContentProposalDecoration.hide();
                }
            }
        };
        this.fQuickQueryInput.addListener(26, listener);
        this.fQuickQueryInput.addListener(27, listener);
        this.fContentProposalDecoration.setDescriptionText(NLS.bind((String)Messages.QuickQueryTextField_CONTENT_ASSIST_AVAILABLE, (Object[])new Object[]{keyStroke.format()}));
        this.fContentProposalDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.fQuickQueryInput, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.fQuickQueryProposalProvider, keyStroke, null);
        adapter.setProposalAcceptanceStyle(3);
        adapter.setPropagateKeys(true);
        adapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                String newContent = QuickQueryTextField.this.fQuickQueryInput.getText();
                int cursorPosition = QuickQueryTextField.this.fQuickQueryInput.getCaretPosition();
                if (proposal instanceof QuickQueryProposal) {
                    QuickQueryProposal attributeProposal = (QuickQueryProposal)proposal;
                    String currentContent = newContent;
                    StringBuilder result = new StringBuilder();
                    if (attributeProposal.getStart() > currentContent.length()) {
                        result.append(currentContent).append(' ');
                    } else {
                        result.append(currentContent.substring(0, attributeProposal.getStart()));
                    }
                    cursorPosition = proposal.getCursorPosition() + result.length();
                    result.append(proposal.getContent());
                    if (currentContent.length() > attributeProposal.getEnd()) {
                        result.append(currentContent.substring(attributeProposal.getEnd()));
                    }
                    newContent = result.toString();
                }
                QuickQueryTextField.this.fQuickQueryInput.setText(newContent);
                QuickQueryTextField.this.fQuickQueryInput.setSelection(cursorPosition);
            }
        });
        adapter.addContentProposalListener(new IContentProposalListener2(){

            public void proposalPopupOpened(ContentProposalAdapter adapter) {
                QuickQueryTextField.this.proposalPopupOpened();
            }

            public void proposalPopupClosed(ContentProposalAdapter adapter) {
                QuickQueryTextField.this.proposalPopupClosed();
            }
        });
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fQuickQueryInput);
        adapter.setLabelProvider((ILabelProvider)new LabelProvider((ResourceManager)resourceManager){
            private final /* synthetic */ ResourceManager val$resourceManager;
            {
                this.val$resourceManager = resourceManager;
            }

            public String getText(Object element) {
                return ((IContentProposal)element).getLabel();
            }

            public Image getImage(Object element) {
                if (element instanceof QuickQueryProposal) {
                    return JazzResources.getImageWithDefault((ResourceManager)this.val$resourceManager, (ImageDescriptor)((QuickQueryProposal)element).getIcon());
                }
                if (element instanceof ContentProposalRecentQuery) {
                    return JazzResources.getImageWithDefault((ResourceManager)this.val$resourceManager, (ImageDescriptor)ImagePool.REFRESH);
                }
                return super.getImage(element);
            }
        });
    }

    private void modifiedText() {
        this.fLastModification = System.currentTimeMillis();
        this.fFilterJob.schedule(this.fExecutionDelay);
    }

    private void proposalPopupOpened() {
        this.fLastModification = -1L;
        this.fFilterJob.cancel();
    }

    private void proposalPopupClosed() {
        this.fLastModification = System.currentTimeMillis();
        this.fFilterJob.schedule(this.fExecutionDelay);
    }

    private class QuickQueryEvaluationJob
    extends Job {
        public QuickQueryEvaluationJob() {
            super(Messages.QuickQueryTextField_JOB_FILTERING);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            long lastModification = QuickQueryTextField.this.fLastModification;
            if (lastModification != -1L) {
                long modificationDelta = System.currentTimeMillis() - lastModification;
                if (modificationDelta >= QuickQueryTextField.this.fExecutionDelay) {
                    QuickQueryEvaluationJob quickQueryEvaluationJob = this;
                    synchronized (quickQueryEvaluationJob) {
                        final Expression filterExpression = QuickQueryTextField.this.getFilterExpression(monitor);
                        if (!(monitor.isCanceled() || QuickQueryTextField.this.fLastExpression != null && this.equals(QuickQueryTextField.this.fLastExpression, filterExpression))) {
                            QuickQueryTextField.this.fQuickQueryListeners.getListeners();
                            Object[] objectArray = QuickQueryTextField.this.fQuickQueryListeners.getListeners();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                final Object listener = objectArray[n2];
                                if (monitor.isCanceled()) break;
                                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                                    public void run() throws Exception {
                                        ((IQuickQueryListener)listener).evaluateQuery(filterExpression);
                                    }
                                });
                                ++n2;
                            }
                            QuickQueryTextField.this.fLastExpression = filterExpression;
                        }
                    }
                    QuickQueryTextField.this.fLastModification = System.currentTimeMillis();
                } else {
                    this.schedule(QuickQueryTextField.this.fExecutionDelay - modificationDelta);
                }
            }
            return Status.OK_STATUS;
        }

        private boolean equals(Expression e1, Expression e2) {
            if (e1 == null ^ e2 == null) {
                return false;
            }
            if (e1 == null) {
                return true;
            }
            XMLExpressionSerializer serializer = new XMLExpressionSerializer();
            return serializer.serialize(e1).equals(e2);
        }
    }
}

