/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttribute;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryDefinition;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryParameter;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ContentProposalRecentQuery;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ProposalMatcher;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryProposal;
import com.ibm.team.apt.internal.ide.ui.quickquery.IParsedQuickQueryElement;
import com.ibm.team.apt.internal.ide.ui.quickquery.ParsedAttributePredicate;
import com.ibm.team.apt.internal.ide.ui.quickquery.QuickQueryParser;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.IMemento;

public class QuickQueryProposalProvider
implements IContentProposalProvider {
    private static final int MAX_RECENT_QUERIES = 50;
    private final ProposalComparator fProposalComparator = new ProposalComparator();
    private final List<String> fRecentQueries = new LinkedList<String>();
    private final IQuickQueryDefinition fDefinition;
    private final IQuickQueryContext fContext;

    public QuickQueryProposalProvider(IQuickQueryDefinition definition, IQuickQueryContext context) {
        this.fDefinition = definition;
        this.fContext = context;
    }

    public void addRecentQuery(String query) {
        if (!this.fRecentQueries.remove(query) && this.fRecentQueries.size() > 50) {
            this.fRecentQueries.remove(50);
        }
        this.fRecentQueries.add(0, query);
    }

    public void loadState(IMemento state) {
    }

    public void saveState(IMemento state) {
    }

    public IContentProposal[] getProposals(final String contents, final int position) {
        TeamFuture<IContentProposal[]> proposalComputerFuture = new TeamFuture<IContentProposal[]>(){

            protected IContentProposal[] resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor.beginTask("", -1);
                try {
                    ArrayList<Object> proposals = new ArrayList<Object>();
                    ProposalMatcher queryMatcher = new ProposalMatcher(contents.substring(0, position));
                    for (String recentQuery : QuickQueryProposalProvider.this.fRecentQueries) {
                        if (!queryMatcher.matches(recentQuery)) continue;
                        proposals.add(new ContentProposalRecentQuery(recentQuery));
                    }
                    QuickQueryParser parser = new QuickQueryParser(contents);
                    IParsedQuickQueryElement currentPredicate = null;
                    for (IParsedQuickQueryElement parsed : parser) {
                        if (parsed.getStartPosition() >= position || parsed.getEndPosition() < position) continue;
                        currentPredicate = parsed;
                        break;
                    }
                    try {
                        Collection<IQuickQueryAttribute> allAttributes = QuickQueryProposalProvider.this.fDefinition.findAllAttributes(QuickQueryProposalProvider.this.fContext);
                        if (currentPredicate != null) {
                            int attributeNameStart = currentPredicate.getStartPosition();
                            int attributeNameEnd = currentPredicate.getEndPosition();
                            if (currentPredicate instanceof ParsedAttributePredicate) {
                                attributeNameStart = ((ParsedAttributePredicate)currentPredicate).getAttributeNameStart();
                                attributeNameEnd = ((ParsedAttributePredicate)currentPredicate).getAttributeNameEnd();
                            }
                            if (position <= attributeNameEnd) {
                                ProposalMatcher attributeMatcher = new ProposalMatcher(contents.substring(attributeNameStart, position));
                                for (IQuickQueryAttribute quickQueryAttribute : allAttributes) {
                                    if (attributeMatcher.matches(quickQueryAttribute.getKeyword())) {
                                        proposals.add(new QuickQueryProposal(quickQueryAttribute, currentPredicate.getStartPosition(), currentPredicate.getEndPosition()));
                                    }
                                    for (IQuickQueryParameter parameter : quickQueryAttribute.getParameterProposals(true, QuickQueryOperator.DEFAULT, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                                        if (!attributeMatcher.matches(parameter.getKeyword())) continue;
                                        proposals.add(new QuickQueryProposal(quickQueryAttribute, parameter, currentPredicate.getStartPosition(), currentPredicate.getEndPosition(), false));
                                    }
                                }
                            } else if (currentPredicate instanceof ParsedAttributePredicate) {
                                ParsedAttributePredicate parsedAttribute = (ParsedAttributePredicate)currentPredicate;
                                for (IQuickQueryAttribute quickQueryAttribute : allAttributes) {
                                    if (!quickQueryAttribute.getKeyword().equals(parsedAttribute.getAttributeName())) continue;
                                    Collection<IQuickQueryParameter> parameterProposals = quickQueryAttribute.getParameterProposals(false, parsedAttribute.getOperator(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    String prefix = null;
                                    if (position > parsedAttribute.getParameterStart()) {
                                        prefix = contents.substring(parsedAttribute.getParameterStart(), position);
                                    }
                                    ProposalMatcher parameterMatcher = new ProposalMatcher(prefix);
                                    for (IQuickQueryParameter parameter : parameterProposals) {
                                        if (!parameterMatcher.matches(parameter.getKeyword())) continue;
                                        proposals.add(new QuickQueryProposal(quickQueryAttribute, parameter, currentPredicate.getStartPosition(), currentPredicate.getEndPosition(), true));
                                    }
                                }
                            }
                        } else {
                            for (IQuickQueryAttribute filterOperation : allAttributes) {
                                proposals.add(new QuickQueryProposal(filterOperation, position, position));
                            }
                        }
                    }
                    catch (TeamRepositoryException e) {
                        PlanningUIPlugin.log(e);
                    }
                    IContentProposal[] elements = proposals.toArray(new IContentProposal[proposals.size()]);
                    Arrays.sort(elements, QuickQueryProposalProvider.this.fProposalComparator);
                    IContentProposal[] iContentProposalArray = elements;
                    return iContentProposalArray;
                }
                finally {
                    monitor.done();
                }
            }
        };
        final IContentProposal[][] result = new IContentProposal[1][];
        BusyIndicator.showWhile(null, (Runnable)new Runnable((TeamFuture)proposalComputerFuture){
            private final /* synthetic */ TeamFuture val$proposalComputerFuture;
            {
                this.val$proposalComputerFuture = teamFuture;
            }

            public void run() {
                try {
                    result[0] = (IContentProposal[])this.val$proposalComputerFuture.joinResult(2000);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException e) {
                    PlanningUIPlugin.log(e);
                }
            }
        });
        if (result[0] != null) {
            return result[0];
        }
        return new IContentProposal[]{new IContentProposal(){

            public String getContent() {
                return null;
            }

            public int getCursorPosition() {
                return 0;
            }

            public String getDescription() {
                return null;
            }

            public String getLabel() {
                return Messages.QuickQueryProposalProvider_COMPUTATION_FAILED;
            }
        }};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProposalComparator
    implements Comparator<IContentProposal> {
        private final int CATEGORY_RECENT_USED = 0;
        private final int CATEGORY_FILTER_OPERATION = 1;
        private final int CATEGORY_OTHER = Integer.MAX_VALUE;

        private ProposalComparator() {
        }

        private int category(IContentProposal proposal) {
            if (proposal instanceof ContentProposalRecentQuery) {
                return 0;
            }
            if (proposal instanceof QuickQueryProposal) {
                return 1;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int compare(IContentProposal p1, IContentProposal p2) {
            int c2;
            int c1 = this.category(p1);
            if (c1 != (c2 = this.category(p2))) {
                return c1 - c2;
            }
            if (c1 == 1) {
                return ((QuickQueryProposal)p1).compareTo((QuickQueryProposal)p2);
            }
            return Collator.getInstance().compare(p1.getLabel(), p2.getLabel());
        }
    }
}

