/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttribute;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryParameter;
import com.ibm.team.apt.ide.ui.quickquery.QuickQueryOperator;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.resource.ImageDescriptor;

public class QuickQueryProposal
implements IContentProposal {
    private final IQuickQueryAttribute fFilterOperation;
    private final IQuickQueryParameter fParameter;
    private final int fStart;
    private final int fEnd;
    private final boolean fAttributeMatched;

    public QuickQueryProposal(IQuickQueryAttribute filter, int start, int end) {
        this(filter, null, start, end, false);
    }

    public QuickQueryProposal(IQuickQueryAttribute filter, IQuickQueryParameter parameter, int start, int end, boolean attributeMatched) {
        this.fFilterOperation = filter;
        this.fParameter = parameter;
        this.fStart = start;
        this.fEnd = end;
        this.fAttributeMatched = attributeMatched;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public ImageDescriptor getIcon() {
        return this.fParameter == null ? this.fFilterOperation.getIcon() : this.fParameter.getIcon();
    }

    public int compareTo(QuickQueryProposal other) {
        if (!this.fFilterOperation.equals(other.fFilterOperation)) {
            return Collator.getInstance().compare(this.fFilterOperation.getKeyword(), other.fFilterOperation.getKeyword());
        }
        return (this.fParameter == null ? 0 : 1) - (other.fParameter == null ? 0 : 1);
    }

    public String getContent() {
        StringBuilder contentBuilder = new StringBuilder();
        contentBuilder.append(this.fFilterOperation.getKeyword());
        contentBuilder.append(QuickQueryOperator.DEFAULT.getToken());
        if (this.fParameter != null) {
            contentBuilder.append(this.escape(this.fParameter.getKeyword()));
        }
        return contentBuilder.toString();
    }

    public String getLabel() {
        if (!this.fAttributeMatched && this.fParameter == null) {
            return this.fFilterOperation.getKeyword();
        }
        if (this.fAttributeMatched && this.fParameter != null) {
            return this.fParameter.getKeyword();
        }
        return NLS.bind((String)Messages.QuickQueryProposal_KEYWORD_PARAMETER, (Object[])new Object[]{this.fFilterOperation.getKeyword(), this.fParameter.getKeyword()});
    }

    public String getDescription() {
        return this.fParameter == null ? this.fFilterOperation.getDescription() : this.fParameter.getDescription();
    }

    public int getCursorPosition() {
        int length = this.fFilterOperation.getKeyword().length();
        ++length;
        if (this.fParameter != null) {
            length += this.escape(this.fParameter.getKeyword()).length();
        }
        return length;
    }

    private String escape(String value) {
        boolean needsEscape = false;
        int i = 0;
        while (i < value.length()) {
            if (Character.isWhitespace(value.charAt(i))) {
                needsEscape = true;
                break;
            }
            ++i;
        }
        if (!needsEscape) {
            return value;
        }
        return NLS.bind((String)"\"{0}\"", (Object[])new Object[]{value.replace("\"", "\\\"")});
    }
}

