/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.AbstractQuickQueryParticipant;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.IQuickQueryEntryFinder;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryMode;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickQueryEntryFinder
extends AbstractQuickQueryParticipant
implements IQuickQueryEntryFinder {
    public QuickQueryEntryFinder(PlanViewModel viewModel) {
        super(QuickQueryMode.Find, viewModel);
    }

    @Override
    public boolean find(boolean searchAll) {
        if (this.isInstalled()) {
            boolean result = this.fViewModel.readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    Collection<OutlineEntry<?>> selectedEntries = QuickQueryEntryFinder.this.fViewModel.getSelectedEntries();
                    OutlineEntry<PlanItem> entry = EntryUtils.firstEntryOfType(selectedEntries, PlanItem.class);
                    if (entry != null && QuickQueryEntryFinder.this.fMatcher.matches(entry.getElement(), QuickQueryEntryFinder.this.fExpression)) {
                        QuickQueryEntryFinder.this.selectEntry(entry);
                        return true;
                    }
                    return false;
                }
            });
            return result || this.findNext(searchAll);
        }
        return false;
    }

    @Override
    public boolean findNext(final boolean searchAll) {
        if (this.isInstalled()) {
            return this.fViewModel.readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    OutlineEntry<PlanItem> candidate;
                    Collection<OutlineEntry<?>> selectedEntries = QuickQueryEntryFinder.this.fViewModel.getSelectedEntries();
                    EntryTreeWalker<PlanItem> walker = new EntryTreeWalker<PlanItem>(readAccessor, PlanItem.class);
                    walker.setCurrentEntry(EntryUtils.firstEntryOfType(selectedEntries, PlanItem.class));
                    boolean canReset = searchAll;
                    do {
                        if ((candidate = walker.getNext()) == null && canReset) {
                            walker = new EntryTreeWalker<PlanItem>(readAccessor, PlanItem.class);
                            candidate = walker.getNext();
                            canReset = false;
                            QuickQueryEntryFinder.this.beep();
                        }
                        if (candidate != null) continue;
                        return false;
                    } while (!QuickQueryEntryFinder.this.fMatcher.matches(candidate.getElement(), QuickQueryEntryFinder.this.fExpression));
                    QuickQueryEntryFinder.this.selectEntry(candidate);
                    return true;
                }
            });
        }
        return false;
    }

    @Override
    public boolean findPrevious(final boolean searchAll) {
        if (this.isInstalled()) {
            return this.fViewModel.readModel(new ModelReadRunnable<Boolean, RuntimeException>(){

                @Override
                public Boolean run(IOutlineModelReader readAccessor) throws RuntimeException {
                    OutlineEntry<PlanItem> candidate;
                    EntryTreeWalker<PlanItem> walker = new EntryTreeWalker<PlanItem>(readAccessor, PlanItem.class);
                    Collection<OutlineEntry<?>> selectedEntries = QuickQueryEntryFinder.this.fViewModel.getSelectedEntries();
                    walker.setCurrentEntry(EntryUtils.lastEntryOfType(selectedEntries, PlanItem.class));
                    boolean canReset = searchAll;
                    do {
                        if ((candidate = walker.getPrevious()) == null && canReset) {
                            walker = new EntryTreeWalker<PlanItem>(readAccessor, PlanItem.class);
                            candidate = walker.getPrevious();
                            canReset = false;
                            QuickQueryEntryFinder.this.beep();
                        }
                        if (candidate != null) continue;
                        return false;
                    } while (!QuickQueryEntryFinder.this.fMatcher.matches(candidate.getElement(), QuickQueryEntryFinder.this.fExpression));
                    QuickQueryEntryFinder.this.selectEntry(candidate);
                    return true;
                }
            });
        }
        return false;
    }

    @Override
    protected void doUnInstall() {
        boolean shouldBeInstalled;
        boolean bl = shouldBeInstalled = this.fExpression != null && this.fEnabled;
        if (this.fIsInstalled ^ shouldBeInstalled) {
            this.fIsInstalled = shouldBeInstalled;
        }
    }

    private void beep() {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                display.beep();
            }
        });
    }

    private void selectEntry(OutlineEntry<PlanItem> entry) {
        this.fViewModel.setSelectedEntry(entry);
        this.fViewModel.revealEntry(entry);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryTreeWalker<T> {
        private final IOutlineModelReader fReadAccessor;
        private final Class<T> fType;
        private OutlineEntry<T> fCurrentEntry;

        public EntryTreeWalker(IOutlineModelReader readAccessor, Class<T> type) {
            this.fReadAccessor = readAccessor;
            this.fType = type;
        }

        public void setCurrentEntry(OutlineEntry<T> currentEntry) {
            this.fCurrentEntry = currentEntry;
        }

        public OutlineEntry<T> getNext() {
            if (this.fCurrentEntry == null) {
                this.fCurrentEntry = this.getNextEntry(this.fReadAccessor.getRootEntry(), false);
                return this.fCurrentEntry;
            }
            this.fCurrentEntry = this.getNextEntry(this.fCurrentEntry, true);
            return this.fCurrentEntry;
        }

        public OutlineEntry<T> getPrevious() {
            if (this.fCurrentEntry == null) {
                this.fCurrentEntry = this.getPreviousEntry(this.fReadAccessor.getRootEntry(), false);
                return this.fCurrentEntry;
            }
            this.fCurrentEntry = this.getPreviousEntry(this.fCurrentEntry, true);
            return this.fCurrentEntry;
        }

        private OutlineEntry<T> getNextEntry(OutlineEntry<?> currentEntry, boolean skip) {
            OutlineEntry<Object> candidate;
            EntryNavigator n = this.fReadAccessor.getEntryNavigator(true);
            if (!skip && EntryUtils.isType(currentEntry, this.fType)) {
                return currentEntry;
            }
            Iterator<OutlineEntry<?>> childIterator = n.childEntries(currentEntry).iterator();
            if (childIterator.hasNext() && (candidate = this.getNextEntry(childIterator.next(), false)) != null) {
                return candidate;
            }
            do {
                if ((candidate = n.successorEntry(currentEntry)) == null) continue;
                return this.getNextEntry(candidate, false);
            } while ((currentEntry = n.parentEntry(currentEntry)) != null);
            return null;
        }

        private OutlineEntry<T> getPreviousEntry(OutlineEntry<?> currentEntry, boolean skip) {
            OutlineEntry<Object> candidate;
            EntryNavigator n = this.fReadAccessor.getEntryNavigator(true);
            List<OutlineEntry<?>> childEntries = n.childEntries(currentEntry);
            if (childEntries.size() > 0 && (candidate = this.getPreviousEntry(childEntries.get(childEntries.size() - 1), false)) != null) {
                return candidate;
            }
            if (!skip && EntryUtils.isType(currentEntry, this.fType)) {
                return currentEntry;
            }
            do {
                if ((candidate = n.predecessorEntry(currentEntry)) == null) continue;
                return this.getPreviousEntry(candidate, false);
            } while ((currentEntry = n.parentEntry(currentEntry)) != null);
            return null;
        }
    }
}

