/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.IEntryVisitor;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelUpdater;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUpdateRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.AbstractQuickQueryParticipant;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeTag;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryMode;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.graphics.RGB;

public class QuickQueryColorizer
extends AbstractQuickQueryParticipant {
    private final ColorizeRunnable fColorizer = new ColorizeRunnable();
    private AtomicInteger fUpdatesSuppressed = new AtomicInteger();
    private int fPriority;
    private RGB fColor;
    private String fLabel;
    private ColorizeTag fTag;
    private boolean fNeedsRefresh;

    public QuickQueryColorizer(PlanViewModel viewModel) {
        super(QuickQueryMode.Colorize, viewModel);
    }

    public void allowUpdates(boolean allow) {
        if (allow) {
            if (this.fUpdatesSuppressed.decrementAndGet() == 0) {
                this.doUnInstall();
            }
        } else {
            this.fUpdatesSuppressed.incrementAndGet();
        }
    }

    public void setPriority(int priority) {
        if (this.fPriority != priority) {
            this.fPriority = priority;
            this.doUnInstall();
        }
    }

    public void setLabel(String label) {
        if (this.fLabel == null && label != null || !this.fLabel.equals(label)) {
            this.fLabel = label;
            this.doUnInstall();
        }
    }

    public void setColor(RGB color) {
        if (this.fColor == null && color != null || !this.fColor.equals((Object)color)) {
            this.fColor = color;
            this.doUnInstall();
        }
    }

    protected void doUnInstall() {
        if (this.fUpdatesSuppressed.get() == 0) {
            this.fViewModel.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

                @Override
                public Void run(IOutlineModelUpdater updateAccessor) throws RuntimeException {
                    boolean shouldBeInstalled = QuickQueryColorizer.this.fExpression != null && QuickQueryColorizer.this.fColor != null && QuickQueryColorizer.this.fEnabled;
                    QuickQueryColorizer.this.fNeedsRefresh = true;
                    if (QuickQueryColorizer.this.fIsInstalled ^ shouldBeInstalled) {
                        if (shouldBeInstalled) {
                            QuickQueryColorizer.this.fViewModel.addPostUpdateRunnable(QuickQueryColorizer.this.fColorizer, true);
                            QuickQueryColorizer.this.fIsInstalled = true;
                        } else {
                            updateAccessor.executeAfterUpdate(new Runnable(){

                                public void run() {
                                    (this).QuickQueryColorizer.this.fViewModel.removePostUpdateRunnable(QuickQueryColorizer.this.fColorizer, true);
                                }
                            });
                            QuickQueryColorizer.this.fIsInstalled = false;
                        }
                    }
                    if (QuickQueryColorizer.this.fColor != null) {
                        QuickQueryColorizer.this.fTag = new ColorizeTag(QuickQueryColorizer.this, QuickQueryColorizer.this.fColor, QuickQueryColorizer.this.fPriority);
                    }
                    return null;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColorizeRunnable
    implements ModelUpdateRunnable<Void, RuntimeException> {
        private ColorizeRunnable() {
        }

        @Override
        public Void run(final IOutlineModelUpdater updateAccessor) throws RuntimeException {
            updateAccessor.accept(new IEntryVisitor(){

                @Override
                public boolean visit(OutlineEntry<?> entry) {
                    Object element = entry.getElement();
                    if (element instanceof PlanItem) {
                        boolean needsResort = false;
                        if (((ColorizeRunnable)ColorizeRunnable.this).QuickQueryColorizer.this.fIsInstalled) {
                            if (QuickQueryColorizer.this.fNeedsRefresh || updateAccessor.isModified(entry)) {
                                updateAccessor.clearTag(entry, QuickQueryColorizer.this.fTag);
                                if (((ColorizeRunnable)ColorizeRunnable.this).QuickQueryColorizer.this.fExpression != null && ((ColorizeRunnable)ColorizeRunnable.this).QuickQueryColorizer.this.fMatcher.matches((PlanItem)element, ((ColorizeRunnable)ColorizeRunnable.this).QuickQueryColorizer.this.fExpression)) {
                                    updateAccessor.setTag(entry, QuickQueryColorizer.this.fTag);
                                }
                                needsResort = true;
                            }
                        } else {
                            updateAccessor.clearTag(entry, QuickQueryColorizer.this.fTag);
                            needsResort = true;
                        }
                        if (needsResort) {
                            OutlineEntry<?> toSort = updateAccessor.getParent(entry);
                            updateAccessor.requestChildrenSort(toSort, false);
                        }
                    }
                    return true;
                }
            });
            QuickQueryColorizer.this.fNeedsRefresh = false;
            return null;
        }
    }
}

