/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.quickquery;

import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorSelectionImageDescriptor;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

abstract class AbstractSelectQuickColorizeColorAction
extends Action
implements IMenuCreator {
    private ColorDefinition[] DEFAULT_COLORS = new ColorDefinition[]{new ColorDefinition(new RGB(141, 198, 63), Messages.AbstractSelectQuickColorizeColorAction_GREEN), new ColorDefinition(new RGB(247, 148, 29), Messages.AbstractSelectQuickColorizeColorAction_ORANGE), new ColorDefinition(new RGB(228, 215, 61), Messages.AbstractSelectQuickColorizeColorAction_GOLD), new ColorDefinition(new RGB(90, 179, 163), Messages.AbstractSelectQuickColorizeColorAction_TURQUOISE), new ColorDefinition(new RGB(121, 121, 121), Messages.AbstractSelectQuickColorizeColorAction_GRAY), new ColorDefinition(new RGB(52, 122, 171), Messages.AbstractSelectQuickColorizeColorAction_DARK_TURQUOISE), new ColorDefinition(new RGB(67, 89, 160), Messages.AbstractSelectQuickColorizeColorAction_BLUE), new ColorDefinition(new RGB(199, 99, 99), Messages.AbstractSelectQuickColorizeColorAction_RED)};
    private RGB fColor = new RGB(255, 204, 153);
    private final Shell fShell;
    private ResourceManager fResourceManager;
    private Menu fMenu;
    private SelectionListener fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MenuItem item = (MenuItem)e.widget;
            if (item.getData() == null) {
                AbstractSelectQuickColorizeColorAction.this.run();
            } else if (item.getSelection()) {
                RGB rGB = (RGB)item.getData();
                AbstractSelectQuickColorizeColorAction.this.fColor = rGB;
                AbstractSelectQuickColorizeColorAction.this.colorChanged(rGB);
            }
        }
    };

    public AbstractSelectQuickColorizeColorAction(Shell shell, RGB color) {
        super(Messages.AbstractSelectQuickColorizeColorAction_LABEL);
        this.fShell = shell;
        this.fColor = color;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    }

    public IMenuCreator getMenuCreator() {
        return this;
    }

    public int getStyle() {
        return 4;
    }

    public ImageDescriptor getImageDescriptor() {
        return new ColorSelectionImageDescriptor((Device)this.fShell.getDisplay(), this.fColor);
    }

    public void run() {
        ColorDialog colorDialog = new ColorDialog(this.fShell);
        colorDialog.setText(Messages.AbstractSelectQuickColorizeColorAction_COLORDIALOG_TITLE);
        this.fColor = colorDialog.open();
        if (this.fColor != null) {
            this.colorChanged(this.fColor);
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
    }

    protected void updateColor(RGB color) {
        this.fColor = color;
    }

    protected abstract void colorChanged(RGB var1);

    protected void fillMenu(Menu menu) {
        ColorDefinition[] colorDefinitionArray = this.DEFAULT_COLORS;
        int n = this.DEFAULT_COLORS.length;
        int n2 = 0;
        while (n2 < n) {
            ColorDefinition colorDefinition = colorDefinitionArray[n2];
            MenuItem item = new MenuItem(menu, 16);
            item.setData((Object)colorDefinition.fValue);
            item.setSelection(colorDefinition.fValue.equals((Object)this.fColor));
            item.setText(colorDefinition.fName);
            item.addSelectionListener(this.fSelectionListener);
            item.setImage(this.fResourceManager.createImageWithDefault((ImageDescriptor)new ColorSelectionImageDescriptor((Device)this.fShell.getDisplay(), colorDefinition.fValue)));
            ++n2;
        }
        new MenuItem(menu, 2);
        MenuItem item = new MenuItem(menu, 0);
        item.setData(null);
        item.addSelectionListener(this.fSelectionListener);
        item.setText(Messages.AbstractSelectQuickColorizeColorAction_MENUITEM_OPEN_COLORDIALOG);
    }

    private class ColorDefinition {
        public final RGB fValue;
        public final String fName;

        public ColorDefinition(RGB color, String name) {
            this.fValue = color;
            this.fName = name;
        }
    }
}

