/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntryUpdateRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewer;
import com.ibm.team.apt.internal.ide.ui.common.model.UnfilteredState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoveEntryRunnable
extends OutlineEntryUpdateRunnable {
    private final boolean fSaveState;

    public RemoveEntryRunnable(OutlineModelViewer viewer, OutlineEntry<?> entry, boolean saveState) {
        super(viewer, entry);
        this.fSaveState = saveState;
        Assert.isLegal((!entry.isRootEntry() ? 1 : 0) != 0, (String)"Can't remove root entry from viewer!");
    }

    @Override
    protected void doRun() {
        OutlineEntry<?> entry = this.getEntry();
        if (this.fSaveState) {
            this.saveState(entry);
        }
        this.getViewer().remove(entry);
        super.doRun();
    }

    private void saveState(OutlineEntry<?> entry) {
        OutlineItem outlineItem = this.getViewer().findOutlineItem(entry);
        if (outlineItem != null) {
            UnfilteredState unfilteredState = new UnfilteredState();
            unfilteredState.setExpanded(outlineItem.getExpanded());
            entry.setUnfilteredState(unfilteredState);
            for (OutlineEntry<?> child : entry.getChildren()) {
                this.saveState(child);
            }
        }
    }
}

