/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.model;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.model.CopyResult;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryFilter;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryNavigator;
import com.ibm.team.apt.internal.ide.ui.common.model.EntrySorter;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryTag;
import com.ibm.team.apt.internal.ide.ui.common.model.IEntryVisitor;
import com.ibm.team.apt.internal.ide.ui.common.model.IModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelReader;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelRebuilder;
import com.ibm.team.apt.internal.ide.ui.common.model.IOutlineModelUpdater;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelReadRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUnlockedRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.ModelUpdateRunnable;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewer;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewerRunnable;
import com.ibm.team.apt.internal.ide.ui.common.structure.UnfilteredChildrenTag;
import com.ibm.team.apt.internal.ide.ui.util.RefreshRunnable;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineModel<I> {
    private static final ExpansionHull EMPTY_EXPANSION_HULL = new ExpansionHull(Collections.EMPTY_LIST);
    private OutlineModelViewer fViewer;
    private I fInput;
    private IModelTransformer<I, ? extends OutlineModel<I>> fModelTransformer;
    private List<EntryFilter> fFilters = new ArrayList<EntryFilter>();
    private EntrySorter fSorter;
    private OutlineEntry<?> fRootEntry;
    private final Map<Object, Set<OutlineEntry<?>>> fReverseItemMap = new WeakHashMap();
    private int fGenerationCounter = 0;
    private int fNestedUpdates = 0;
    private List<Runnable> fEndUpdateRunnables;
    private final ILock fModelLock = Job.getJobManager().newLock();
    private final ListenerList fPostUpdateBeforeFilterRunnables = new ListenerList();
    private final ListenerList fPostUpdateAfterFilterRunnables = new ListenerList();
    private final ModelSelectionManager fSelectionManager = new ModelSelectionManager();

    public void setViewer(OutlineModelViewer newViewer) {
        this.aquireWriteLock();
        try {
            OutlineModelViewer oldViewer = this.fViewer;
            this.fViewer = newViewer;
            this.fSelectionManager.viewerChanges(oldViewer, newViewer);
            this.fViewer.setInput(this);
            this.refresh();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void setInput(I input) {
        this.aquireWriteLock();
        try {
            this.fInput = input;
            if (this.fModelTransformer != null) {
                this.fModelTransformer.inputChanged(this, this.fInput);
            }
            this.refresh();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public I getInput() {
        this.aquireReadLock();
        try {
            I i = this.fInput;
            return i;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public IModelTransformer<I, ? extends OutlineModel<I>> getModelTransformer() {
        return this.fModelTransformer;
    }

    public void setModelTransformer(IModelTransformer<I, ? extends OutlineModel<I>> transformer) {
        this.aquireWriteLock();
        try {
            if (this.fModelTransformer != null) {
                this.fModelTransformer.inputChanged(null, null);
            }
            this.fModelTransformer = transformer;
            if (this.fModelTransformer != null) {
                this.fModelTransformer.inputChanged(this, this.getInput());
            }
            this.refresh();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void viewerPreservingRefresh() {
        Outline modelCanvas;
        final OutlineModelViewer modelViewer = this.getViewer();
        Outline outline = modelCanvas = modelViewer != null ? modelViewer.getOutline() : null;
        if (modelCanvas != null && modelViewer != null) {
            Runnable refreshRunnable = new Runnable(){

                public void run() {
                    modelCanvas.setRedraw(false);
                    try {
                        final ISelection selection = modelViewer.getSelection();
                        final int scrollY = modelCanvas.getTransformation().getY();
                        final List<OutlineModelViewer.ExpansionHullEntry> expansionHull = modelViewer.getExpansionHull(null);
                        OutlineModel.this.refresh();
                        OutlineModel.this.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

                            @Override
                            public Void run(IOutlineModelUpdater modifier) {
                                modifier.executeAfterUpdate(new Runnable(){

                                    public void run() {
                                        if (!modelCanvas.isDisposed()) {
                                            modelViewer.setExpansionHull(null, expansionHull);
                                            modelViewer.setSelection(selection);
                                            int newY = modelCanvas.getTransformation().getY();
                                            modelCanvas.scroll(0, scrollY - newY);
                                        }
                                    }
                                });
                                return null;
                            }
                        });
                    }
                    finally {
                        modelCanvas.setRedraw(true);
                    }
                }
            };
            if (!modelCanvas.isDisposed()) {
                Display display = modelCanvas.getDisplay();
                if (display.getThread() == Thread.currentThread()) {
                    refreshRunnable.run();
                } else {
                    UI.asyncExec((Control)modelCanvas, refreshRunnable);
                }
            }
        } else {
            this.refresh();
        }
    }

    public void refresh() {
        this.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

            @Override
            public Void run(IOutlineModelUpdater modifier) {
                if (OutlineModel.this.fRootEntry != null) {
                    OutlineModel.this.fRootEntry.dispose();
                }
                OutlineModel.this.fReverseItemMap.clear();
                OutlineModel.this.fRootEntry = null;
                ModelRebuildAccessor accessor = OutlineModel.this.createRebuildAccessor();
                try {
                    if (OutlineModel.this.fModelTransformer != null && OutlineModel.this.fInput != null) {
                        OutlineModel.this.fModelTransformer.refreshModel(accessor);
                        OutlineModel.this.resort();
                    }
                }
                finally {
                    accessor.revokeAccess();
                }
                return null;
            }
        });
    }

    public void setSorter(EntrySorter sorter) {
        this.aquireWriteLock();
        try {
            this.fSorter = sorter;
            this.resort();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void refreshSortOrder() {
        this.aquireWriteLock();
        try {
            this.resort();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void addFilter(EntryFilter filter) {
        this.aquireWriteLock();
        try {
            if (!this.fFilters.contains(filter)) {
                this.fFilters.add(filter);
            }
            this.refilter();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void removeFilter(EntryFilter filter) {
        this.aquireWriteLock();
        try {
            this.fFilters.remove(filter);
            this.refilter();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void refreshFilters() {
        this.aquireWriteLock();
        try {
            this.refilter();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public OutlineModelViewer getViewer() {
        return this.fViewer;
    }

    public void addPostUpdateRunnable(ModelUpdateRunnable<Void, ? extends RuntimeException> code, boolean runsBeforeFiltering) {
        this.aquireWriteLock();
        try {
            this.getPostUpdateRunnables(runsBeforeFiltering).add(code);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void removePostUpdateRunnable(ModelUpdateRunnable<Void, ? extends RuntimeException> code, boolean runsBeforeFiltering) {
        this.aquireWriteLock();
        try {
            this.getPostUpdateRunnables(runsBeforeFiltering).remove(code);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public <V, E extends Exception> V readModel(ModelReadRunnable<V, E> code) throws E {
        this.aquireReadLock();
        try {
            V v;
            ModelReadAccessor accessor = this.createReadAccessor();
            try {
                v = code.run(accessor);
            }
            catch (Throwable throwable) {
                accessor.revokeAccess();
                throw throwable;
            }
            accessor.revokeAccess();
            return v;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public <V, E extends Exception> V executeUnlocked(final ModelUnlockedRunnable<V, E> code) throws E {
        return this.updateModel(new ModelUpdateRunnable<V, E>(){

            @Override
            public V run(IOutlineModelUpdater updateAccessor) throws Exception {
                return updateAccessor.executeUnlocked(code);
            }
        });
    }

    public <V, E extends Exception> V updateModel(ModelUpdateRunnable<V, E> code) throws E {
        boolean gotReadLock = false;
        try {
            V result;
            List<Runnable> viewerUpdates = null;
            this.aquireWriteLock();
            try {
                ++this.fGenerationCounter;
                ModelUpdateAccessor accessor = this.createUpdateAccessor();
                try {
                    try {
                        if (++this.fNestedUpdates == 1) {
                            this.doStartUpdate();
                        }
                        result = code.run(accessor);
                    }
                    finally {
                        if (--this.fNestedUpdates == 0) {
                            viewerUpdates = this.doEndUpdate(accessor);
                        }
                    }
                }
                finally {
                    accessor.revokeAccess();
                }
                this.aquireReadLock();
                gotReadLock = true;
            }
            finally {
                this.releaseWriteLock();
            }
            if (viewerUpdates != null && viewerUpdates.size() > 0) {
                Assert.isNotNull((Object)((Object)this.fViewer));
                final int finalGenerationCount = this.fGenerationCounter;
                final List<Runnable> finalUpdateList = viewerUpdates;
                UI.syncExec(this.fViewer.getControl(), new Runnable(){

                    public void run() {
                        if (finalGenerationCount == OutlineModel.this.fGenerationCounter) {
                            for (Runnable runnable : finalUpdateList) {
                                runnable.run();
                            }
                        }
                    }
                });
            }
            V v = result;
            return v;
        }
        finally {
            if (gotReadLock) {
                this.releaseReadLock();
            }
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSelectionManager;
    }

    public Collection<OutlineEntry<?>> getSelectedEntries() {
        final Collection[] result = new Collection[1];
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                protected void doRun() {
                    result[0] = ((IStructuredSelection)OutlineModel.this.fViewer.getSelection()).toList();
                }
            }.syncExec();
        }
        return result[0] != null ? result[0] : Collections.EMPTY_SET;
    }

    public Collection<?> getSelectedElements() {
        Collection<OutlineEntry<?>> entries = this.getSelectedEntries();
        ArrayList result = new ArrayList(entries.size());
        for (OutlineEntry<?> outlineEntry : entries) {
            result.add(outlineEntry.getElement());
        }
        return result;
    }

    public <T> void setSelectedEntry(OutlineEntry<T> toSelect) {
        StructuredSelection selection = new StructuredSelection(toSelect);
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer, (IStructuredSelection)selection){
                private final /* synthetic */ IStructuredSelection val$selection;
                {
                    this.val$selection = iStructuredSelection;
                    super($anonymous0);
                }

                protected void doRun() {
                    OutlineModel.this.fViewer.setSelection((ISelection)this.val$selection);
                }
            }.syncExec();
        }
    }

    public void setSelectedEntries(Collection<? extends OutlineEntry<?>> toSelect) {
        StructuredSelection selection = new StructuredSelection(toSelect.toArray());
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer, (IStructuredSelection)selection){
                private final /* synthetic */ IStructuredSelection val$selection;
                {
                    this.val$selection = iStructuredSelection;
                    super($anonymous0);
                }

                protected void doRun() {
                    OutlineModel.this.fViewer.setSelection((ISelection)this.val$selection);
                }
            }.syncExec();
        }
    }

    public void expandEntries(final Collection<? extends OutlineEntry<?>> toExpand) {
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                protected void doRun() {
                    OutlineModel.this.fViewer.setExpandedElements(toExpand.toArray());
                }
            }.syncExec();
        }
    }

    public <T> void setEntryExpandState(final OutlineEntry<T> entry, final boolean expanded) {
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                protected void doRun() {
                    OutlineModel.this.fViewer.setExpandedState(entry, expanded);
                }
            }.syncExec();
        }
    }

    public <T> void revealEntry(final OutlineEntry<T> toReveal) {
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                protected void doRun() {
                    OutlineModel.this.fViewer.reveal(toReveal);
                }
            }.syncExec();
        }
    }

    public ExpansionHull getExpansionHull() {
        return this.getExpansionHull(null);
    }

    public ExpansionHull setExpansionHull(ExpansionHull hull) {
        return this.setExpansionHull(null, hull);
    }

    public ExpansionHull getExpansionHull(final OutlineEntry<?> rootEntry) {
        final List[] result = new List[1];
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                protected void doRun() {
                    result[0] = OutlineModel.this.fViewer.getExpansionHull(rootEntry);
                }
            }.syncExec();
        }
        return result[0] != null ? new ExpansionHull(result[0]) : EMPTY_EXPANSION_HULL;
    }

    public ExpansionHull setExpansionHull(final OutlineEntry<?> rootEntry, final ExpansionHull expansionHull) {
        final List[] result = new List[1];
        if (this.fViewer != null) {
            new OutlineModelViewerRunnable(this.fViewer){

                protected void doRun() {
                    result[0] = OutlineModel.this.fViewer.setExpansionHull(rootEntry, expansionHull.fExpansionHull);
                }
            }.syncExec();
        }
        return result[0] != null ? new ExpansionHull(result[0]) : EMPTY_EXPANSION_HULL;
    }

    EntrySorter getSorter() {
        return this.fSorter;
    }

    boolean calculateFilterState(OutlineEntry<?> entry, IOutlineModelReader readAccessor) {
        for (EntryFilter filter : this.fFilters) {
            if (filter.select(entry, readAccessor)) continue;
            return false;
        }
        return true;
    }

    private void doStartUpdate() {
        if (this.fRootEntry != null) {
            this.fRootEntry.accept(new StartUpdateVisitor(), false);
        }
        Assert.isTrue((this.fEndUpdateRunnables == null ? 1 : 0) != 0);
        this.fEndUpdateRunnables = new ArrayList<Runnable>();
    }

    private List<Runnable> doEndUpdate(IOutlineModelUpdater updateAccessor) {
        ArrayList<Runnable> viewerUpdates = new ArrayList<Runnable>();
        if (this.fRootEntry != null) {
            this.runPostUpdateRunnables(updateAccessor, true);
            for (OutlineEntry<?> child : this.fRootEntry.getChildren()) {
                this.filterRecursive(child, updateAccessor);
            }
            this.executePendingSortRequests(this.fRootEntry, updateAccessor);
            this.runPostUpdateRunnables(updateAccessor, false);
            if (this.fViewer != null) {
                this.fRootEntry.accept(new CollectUpdatesVisitor(this.fViewer, viewerUpdates), true);
            }
        } else if (this.fViewer != null) {
            viewerUpdates.add(new RefreshRunnable((StructuredViewer)this.fViewer, this));
        }
        Assert.isNotNull(this.fEndUpdateRunnables);
        if (this.fViewer != null) {
            viewerUpdates.addAll(this.fEndUpdateRunnables);
        }
        this.fEndUpdateRunnables = null;
        return viewerUpdates;
    }

    private void runPostUpdateRunnables(final IOutlineModelUpdater updateAccessor, boolean isBeforeFiltering) {
        Object[] objectArray = this.getPostUpdateRunnables(isBeforeFiltering).getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object runnable = objectArray[n2];
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((ModelUpdateRunnable)runnable).run(updateAccessor);
                }

                public void handleException(Throwable exception) {
                    PlanningUIPlugin.log(exception);
                }
            });
            ++n2;
        }
    }

    private ListenerList getPostUpdateRunnables(boolean beforeFiltering) {
        return beforeFiltering ? this.fPostUpdateBeforeFilterRunnables : this.fPostUpdateAfterFilterRunnables;
    }

    private boolean filterRecursive(OutlineEntry<?> entry, IOutlineModelUpdater updateAccessor) {
        boolean isFiltered;
        boolean hasUnfilteredChildren = false;
        for (OutlineEntry<?> child : entry.getChildren()) {
            hasUnfilteredChildren |= !this.filterRecursive(child, updateAccessor);
        }
        boolean bl = isFiltered = !this.calculateFilterState(entry, updateAccessor);
        if (isFiltered && !hasUnfilteredChildren && entry.isVisible()) {
            entry.hide(updateAccessor);
        } else if (!(isFiltered && !hasUnfilteredChildren || entry.isVisible())) {
            entry.show(updateAccessor);
        }
        if (isFiltered && hasUnfilteredChildren) {
            if (!entry.hasTag(UnfilteredChildrenTag.INSTANCE)) {
                updateAccessor.setTag(entry, UnfilteredChildrenTag.INSTANCE);
            }
        } else if (entry.hasTag(UnfilteredChildrenTag.INSTANCE)) {
            updateAccessor.clearTag(entry, UnfilteredChildrenTag.INSTANCE);
        }
        return isFiltered && !hasUnfilteredChildren;
    }

    private void executePendingSortRequests(OutlineEntry<?> entry, IOutlineModelUpdater updateAccessor) {
        for (OutlineEntry<?> child : entry.getChildren()) {
            this.executePendingSortRequests(child, updateAccessor);
        }
        entry.doPendingSort(updateAccessor);
    }

    protected void resort() {
        this.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

            @Override
            public Void run(final IOutlineModelUpdater modifier) {
                if (OutlineModel.this.fRootEntry != null) {
                    OutlineModel.this.fRootEntry.accept(new IEntryVisitor(){

                        @Override
                        public boolean visit(OutlineEntry<?> entry) {
                            entry.requestSortChildren(modifier, true);
                            return true;
                        }
                    }, false);
                }
                return null;
            }
        });
    }

    protected void refilter() {
        this.updateModel(new ModelUpdateRunnable<Void, RuntimeException>(){

            @Override
            public Void run(IOutlineModelUpdater modifier) {
                return null;
            }
        });
    }

    private <T> Collection<OutlineEntry<T>> doGetElementEntries(T element) {
        Set<OutlineEntry<?>> entries = this.fReverseItemMap.get(element);
        if (entries == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<OutlineEntry<T>> result = new ArrayList<OutlineEntry<T>>(entries.size());
        for (OutlineEntry<?> entry : entries) {
            result.add(entry);
        }
        return result;
    }

    private <T> OutlineEntry<T> doAddEntry(Object[] path, T newElement, IOutlineModelUpdater updateAccessor) {
        if (this.fRootEntry == null) {
            throw new IllegalStateException();
        }
        OutlineEntry<Object> parent = this.fRootEntry;
        Object[] objectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentElement = objectArray[n2];
            OutlineEntry<Object> currentEntry = this.getExistingEntry(parent, currentElement);
            if (currentEntry == null) {
                currentEntry = this.createEntry(currentElement, parent, updateAccessor);
            }
            currentEntry.added(false);
            parent = currentEntry;
            ++n2;
        }
        Assert.isNotNull(parent);
        OutlineEntry<T> newEntry = this.getExistingEntry(parent, newElement);
        if (newEntry == null) {
            newEntry = this.createEntry(newElement, parent, updateAccessor);
        }
        parent.requestSortChildren(updateAccessor, false);
        newEntry.added(true);
        return newEntry;
    }

    private <T> OutlineEntry<T> getExistingEntry(OutlineEntry<?> parent, T element) {
        for (OutlineEntry<?> candidate : parent.getChildren()) {
            if (!element.equals(candidate.getElement())) continue;
            return candidate;
        }
        return null;
    }

    private void doRemoveEntry(OutlineEntry<?> entry, IOutlineModelUpdater updateAccessor) {
        Assert.isLegal((entry != null ? 1 : 0) != 0);
        if (entry.removed(true)) {
            this.unregisterEntry(entry, updateAccessor);
        }
        OutlineEntry<?> parent = entry.getParent();
        while (parent != null && parent != this.fRootEntry) {
            if (parent.removed(false)) {
                this.unregisterEntry(parent, updateAccessor);
            }
            parent = parent.getParent();
        }
    }

    private <T> OutlineEntry<T> doReparentEntry(OutlineEntry<T> entry, Object[] path, IOutlineModelUpdater updateAccessor) {
        OutlineEntry<Object> parent = this.fRootEntry;
        Object[] objectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Object currentElement = objectArray[n2];
            parent = this.getExistingEntry(parent, currentElement);
            Assert.isNotNull(parent);
            ++n2;
        }
        return this.doReparentEntry(entry, parent, updateAccessor);
    }

    /*
     * WARNING - void declaration
     */
    private <T> OutlineEntry<T> doReparentEntry(OutlineEntry<T> entry, OutlineEntry<?> parent, IOutlineModelUpdater updateAccessor) {
        void var7_11;
        CopyResult<T> newEntry = entry.copy(parent);
        this.registerEntry(newEntry.entry, updateAccessor);
        parent.add(newEntry.entry, updateAccessor);
        OutlineEntry<Object> candidate = newEntry.entry;
        while (candidate != null) {
            int i = 0;
            while (i < newEntry.count) {
                candidate.added(newEntry.entry == candidate);
                ++i;
            }
            candidate = candidate.getParent();
        }
        ArrayList children = new ArrayList(entry.getChildren());
        for (OutlineEntry outlineEntry : children) {
            this.doReparentEntry(outlineEntry, newEntry.entry, updateAccessor);
        }
        boolean bl = false;
        while (var7_11 < newEntry.count) {
            this.doRemoveEntry(entry, updateAccessor);
            ++var7_11;
        }
        return newEntry.entry;
    }

    private <T> OutlineEntry<T> doCreateRootEntry(T element, IOutlineModelUpdater updateAccessor) {
        Assert.isTrue((this.fRootEntry == null ? 1 : 0) != 0);
        OutlineEntry<T> result = this.createEntry(element, null, updateAccessor);
        this.fRootEntry = result;
        return result;
    }

    private <T> OutlineEntry<T> createEntry(T element, OutlineEntry<?> parent, IOutlineModelUpdater updateAccessor) {
        OutlineEntry<T> childEntry = new OutlineEntry<T>(element, parent, this);
        this.registerEntry(childEntry, updateAccessor);
        if (parent != null) {
            parent.add(childEntry, updateAccessor);
        }
        return childEntry;
    }

    private void registerEntry(OutlineEntry<?> entry, IOutlineModelUpdater updateAccessor) {
        Object key = entry.getElement();
        Set<OutlineEntry<?>> entrySet = this.fReverseItemMap.get(key);
        if (entrySet == null) {
            entrySet = new IdentityHashSet();
            this.fReverseItemMap.put(key, entrySet);
        }
        entrySet.add(entry);
    }

    private void unregisterEntry(OutlineEntry<?> entry, IOutlineModelUpdater updateAccessor) {
        Object key = entry.getElement();
        Set<OutlineEntry<?>> entrySet = this.fReverseItemMap.get(key);
        Assert.isNotNull(entrySet);
        if (entrySet.size() > 1) {
            entrySet.remove(entry);
        } else {
            this.fReverseItemMap.remove(key);
        }
    }

    public <T> Collection<OutlineEntry<T>> getPrimaryEntries(final Collection<T> elements) {
        return (Collection)this.readModel(new ModelReadRunnable<Collection<OutlineEntry<T>>, RuntimeException>(){

            @Override
            public Collection<OutlineEntry<T>> run(IOutlineModelReader readAccessor) throws RuntimeException {
                ArrayList result = new ArrayList(elements.size());
                for (Object toSelect : elements) {
                    result.add(readAccessor.getEntryNavigator(true).findPrimaryEntry(toSelect));
                }
                return result;
            }
        });
    }

    private void aquireReadLock() {
        this.fModelLock.acquire();
    }

    private void releaseReadLock() {
        this.fModelLock.release();
    }

    private void aquireWriteLock() {
        this.fModelLock.acquire();
    }

    private void releaseWriteLock() {
        this.fModelLock.release();
    }

    protected ModelReadAccessor createReadAccessor() {
        return new ModelReadAccessor();
    }

    protected ModelUpdateAccessor createUpdateAccessor() {
        return new ModelUpdateAccessor();
    }

    protected ModelRebuildAccessor createRebuildAccessor() {
        return new ModelRebuildAccessor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectUpdatesVisitor
    implements IEntryVisitor {
        private final List<Runnable> fViewerUpdates;
        private final OutlineModelViewer fViewer;

        public CollectUpdatesVisitor(OutlineModelViewer viewer, List<Runnable> viewerUpdates) {
            this.fViewer = viewer;
            this.fViewerUpdates = viewerUpdates;
        }

        @Override
        public boolean visit(OutlineEntry<?> entry) {
            return entry.collectUpdates(this.fViewer, this.fViewerUpdates);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpansionHull {
        private final List<OutlineModelViewer.ExpansionHullEntry> fExpansionHull;

        private ExpansionHull(List<OutlineModelViewer.ExpansionHullEntry> expansionHull) {
            this.fExpansionHull = expansionHull;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IdentityHashSet<E>
    extends AbstractSet<E>
    implements Set<E> {
        private static final Object DUMMY = new Object();
        private transient IdentityHashMap<E, Object> fMap = new IdentityHashMap();

        @Override
        public Iterator<E> iterator() {
            return this.fMap.keySet().iterator();
        }

        @Override
        public int size() {
            return this.fMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.fMap.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.fMap.containsKey(o);
        }

        @Override
        public boolean add(E o) {
            return this.fMap.put(o, DUMMY) == null;
        }

        @Override
        public boolean remove(Object o) {
            return this.fMap.remove(o) == DUMMY;
        }

        @Override
        public void clear() {
            this.fMap.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class LimitedModelAccessor
    implements IOutlineModelReader {
        private boolean fIsAccessGranted = true;

        protected LimitedModelAccessor() {
        }

        public final void revokeAccess() {
            this.fIsAccessGranted = false;
        }

        protected final void checkAccess() {
            if (!this.fIsAccessGranted) {
                throw new IllegalStateException("The model access has been revoked");
            }
        }

        protected final void checkAccess(OutlineEntry<?> entry) {
            this.checkAccess();
            if (OutlineModel.this != entry.getModel()) {
                throw new IllegalArgumentException("ModelAccessor can't grant access to this OutlineEntry");
            }
        }

        @Override
        public <V, E extends Exception> V executeUnlocked(ModelUnlockedRunnable<V, E> code) throws E {
            this.checkAccess();
            this.fIsAccessGranted = false;
            this.unlock();
            try {
                V v = code.run();
                return v;
            }
            finally {
                this.lock();
                this.fIsAccessGranted = true;
            }
        }

        protected abstract void unlock();

        protected abstract void lock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ModelReadAccessor
    extends LimitedModelAccessor
    implements IOutlineModelReader {
        private EntryNavigator fVisibleEntryNavigator;
        private EntryNavigator fAllEntryNavigator;

        protected ModelReadAccessor() {
        }

        @Override
        public EntryNavigator getEntryNavigator(boolean navigateVisibleOnly) {
            EntryNavigator result;
            this.checkAccess();
            EntryNavigator entryNavigator = result = navigateVisibleOnly ? this.fVisibleEntryNavigator : this.fAllEntryNavigator;
            if (result == null) {
                result = new EntryNavigator(this, navigateVisibleOnly);
            }
            return result;
        }

        public final OutlineModel getModel() {
            this.checkAccess();
            return OutlineModel.this;
        }

        @Override
        public final void accept(IEntryVisitor visitor) {
            this.checkAccess();
            if (OutlineModel.this.fRootEntry != null) {
                OutlineModel.this.fRootEntry.accept(visitor, false);
            }
        }

        @Override
        public final void accept(OutlineEntry<?> startEntry, IEntryVisitor visitor) {
            this.checkAccess(startEntry);
            startEntry.accept(visitor, false);
        }

        @Override
        public final OutlineEntry<?> getRootEntry() {
            this.checkAccess();
            return OutlineModel.this.fRootEntry;
        }

        @Override
        public final boolean containsElement(Object element) {
            this.checkAccess();
            return OutlineModel.this.fReverseItemMap.containsKey(element);
        }

        @Override
        public final <T> Collection<OutlineEntry<T>> getElementEntries(T element) {
            this.checkAccess();
            return OutlineModel.this.doGetElementEntries(element);
        }

        @Override
        public final List<OutlineEntry<?>> getChildren(OutlineEntry<?> entry) {
            this.checkAccess(entry);
            return entry.getChildren();
        }

        @Override
        public final OutlineEntry<?> getParent(OutlineEntry<?> entry) {
            this.checkAccess(entry);
            return entry.getParent();
        }

        @Override
        protected void unlock() {
            OutlineModel.this.releaseReadLock();
        }

        @Override
        protected void lock() {
            OutlineModel.this.aquireReadLock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ModelRebuildAccessor
    extends ModelUpdateAccessor
    implements IOutlineModelRebuilder {
        protected ModelRebuildAccessor() {
        }

        @Override
        public final <T> OutlineEntry<T> createRootEntry(T element) {
            this.checkAccess();
            return OutlineModel.this.doCreateRootEntry(element, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelSelectionManager
    implements ISelectionProvider,
    ISelectionChangedListener {
        private final ListenerList fSelectionListeners = new ListenerList();

        private ModelSelectionManager() {
        }

        public void viewerChanges(OutlineModelViewer oldViewer, OutlineModelViewer newViewer) {
            if (oldViewer != null) {
                oldViewer.removeSelectionChangedListener(this);
            }
            if (newViewer != null) {
                newViewer.addSelectionChangedListener(this);
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fSelectionListeners.add((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fSelectionListeners.remove((Object)listener);
        }

        public ISelection getSelection() {
            return this.convertToSelection(OutlineModel.this.getSelectedEntries());
        }

        public void setSelection(ISelection selection) {
            OutlineModel.this.setSelectedEntries(this.convertToEntryList(selection));
        }

        public void selectionChanged(SelectionChangedEvent viewerEvent) {
            Object[] listeners = this.fSelectionListeners.getListeners();
            if (listeners.length > 0) {
                StructuredSelection newSelection = new StructuredSelection(this.convertToEntryList(viewerEvent.getSelection()));
                final SelectionChangedEvent modelEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)newSelection);
                Object[] objectArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    final Object listener = objectArray[n2];
                    SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            ((ISelectionChangedListener)listener).selectionChanged(modelEvent);
                        }

                        public void handleException(Throwable exception) {
                            PlanningUIPlugin.log(exception);
                        }
                    });
                    ++n2;
                }
            }
        }

        private IStructuredSelection convertToSelection(Collection<OutlineEntry<?>> entries) {
            return new StructuredSelection(entries.toArray());
        }

        private Collection<OutlineEntry<?>> convertToEntryList(ISelection selection) {
            ArrayList result = new ArrayList();
            if (selection instanceof IStructuredSelection) {
                Object[] selectedObjects = ((IStructuredSelection)selection).toArray();
                result.ensureCapacity(selectedObjects.length);
                Object[] objectArray = selectedObjects;
                int n = selectedObjects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof OutlineEntry) {
                        result.add((OutlineEntry)object);
                    }
                    ++n2;
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ModelUpdateAccessor
    extends ModelReadAccessor
    implements IOutlineModelUpdater {
        protected ModelUpdateAccessor() {
        }

        @Override
        public <T> OutlineEntry<T> addEntry(Object[] path, T element) {
            this.checkAccess();
            return OutlineModel.this.doAddEntry(path, element, this);
        }

        @Override
        public <T> OutlineEntry<T> reparentEntry(OutlineEntry<T> entry, Object[] path) {
            this.checkAccess();
            return OutlineModel.this.doReparentEntry(entry, path, this);
        }

        @Override
        public void update(OutlineEntry<?> entry, String[] properties) {
            this.checkAccess(entry);
            entry.update(properties, this);
        }

        @Override
        public void setTag(OutlineEntry<?> entry, EntryTag<?> tag) {
            this.checkAccess(entry);
            entry.setTag(tag);
        }

        @Override
        public void clearTag(OutlineEntry<?> entry, EntryTag<?> tag) {
            this.checkAccess(entry);
            entry.clearTag(tag);
        }

        @Override
        public void move(OutlineEntry<?> entry, int index) {
            this.checkAccess(entry);
            if (entry.isRootEntry()) {
                throw new IllegalArgumentException("Can't move root item");
            }
            entry.getParent().move(entry, index, this);
        }

        @Override
        public void requestChildrenSort(OutlineEntry<?> entry, boolean forceResort) {
            this.checkAccess(entry);
            entry.requestSortChildren(this, forceResort);
        }

        @Override
        public final void removeEntry(OutlineEntry<?> entry) {
            this.checkAccess(entry);
            OutlineModel.this.doRemoveEntry(entry, this);
        }

        @Override
        public boolean isModified(OutlineEntry<?> entry) {
            return entry.hasUpdates();
        }

        @Override
        protected void unlock() {
            OutlineModel.this.releaseWriteLock();
        }

        @Override
        protected void lock() {
            OutlineModel.this.aquireWriteLock();
        }

        @Override
        public void executeAfterUpdate(Runnable code) {
            this.checkAccess();
            Assert.isNotNull((Object)OutlineModel.this.fEndUpdateRunnables);
            OutlineModel.this.fEndUpdateRunnables.add(code);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StartUpdateVisitor
    implements IEntryVisitor {
        private StartUpdateVisitor() {
        }

        public boolean visit(OutlineEntry<? extends Object> entry) {
            return entry.doStartUpdate();
        }
    }
}

