/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.ide.core.util.ITeamFutureListener;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureAdapter;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UITeamFutureAdapter;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueSetDropDownAction<E>
extends Action
implements IMenuCreator {
    private Menu fMenu;
    private SelectionAdapter fListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            MenuItem item = (MenuItem)e.widget;
            ValueSetDropDownAction.this.setValue(item.getData());
        }
    };

    public ValueSetDropDownAction() {
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            if (this.fMenu.isDisposed()) {
                this.fMenu = null;
            } else if (!this.fMenu.isVisible()) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }
    }

    private boolean isDisposed() {
        return this.fMenu == null || this.fMenu.isDisposed();
    }

    public Menu getMenu(Control parent) {
        this.dispose();
        this.fMenu = new Menu(parent);
        List<E> values = this.fastResolveValues();
        if (values != null) {
            for (E element : values) {
                this.makeMenuItem(element);
            }
        } else {
            MenuItem item = new MenuItem(this.fMenu, 0);
            item.setText(Messages.ValueSetDropDownAction_LOADING_MESSAGE);
            final TeamFuture future = new TeamFuture<List<E>>(){

                public List<E> resolve(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ValueSetDropDownAction.this.slowResolveValues(monitor);
                }
            };
            future.addListener((ITeamFutureListener)UITeamFutureAdapter.create(parent.getDisplay(), new TeamFutureAdapter<List<E>>(){

                public void resolvingDone(TeamFutureEvent<List<E>> event) {
                    if (ValueSetDropDownAction.this.isDisposed()) {
                        return;
                    }
                    ValueSetDropDownAction.this.fMenu.getItems()[0].dispose();
                    List values = (List)event.getTeamFuture().getResult();
                    for (Object element : values) {
                        ValueSetDropDownAction.this.makeMenuItem(element);
                    }
                }

                public void resolvingFailed(TeamFutureEvent<List<E>> event) {
                    if (ValueSetDropDownAction.this.isDisposed()) {
                        return;
                    }
                    ErrorDialog.openError((Shell)ValueSetDropDownAction.this.fMenu.getShell(), (String)Messages.ValueSetDropDownAction_LOADING_FAILED_DIALOG_TITLE, (String)Messages.ValueSetDropDownAction_LOADING_FAILED_DIALOG_MESSAGE, (IStatus)event.getTeamFuture().getStatus());
                    ValueSetDropDownAction.this.dispose();
                }

                public void resolvingCanceled(TeamFutureEvent<List<E>> event) {
                    if (ValueSetDropDownAction.this.isDisposed()) {
                        return;
                    }
                    ValueSetDropDownAction.this.dispose();
                }
            }));
            this.fMenu.addDisposeListener(new DisposeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void widgetDisposed(DisposeEvent e) {
                    TeamFuture teamFuture = future;
                    synchronized (teamFuture) {
                        if (!future.isResolved()) {
                            future.cancel();
                        }
                    }
                    ValueSetDropDownAction.this.menuDisposed();
                }
            });
        }
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private void makeMenuItem(E value) {
        MenuItem item = this.createMenuItem(this.fMenu, value);
        item.addSelectionListener((SelectionListener)this.fListener);
        item.setData(value);
    }

    protected void menuDisposed() {
    }

    protected abstract List<E> fastResolveValues();

    protected abstract List<E> slowResolveValues(IProgressMonitor var1) throws TeamRepositoryException;

    protected abstract MenuItem createMenuItem(Menu var1, E var2);

    protected abstract void setValue(E var1);
}

