/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.AttributeDropDownAction;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.IPriority;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityDropDownAction
extends AttributeDropDownAction<IPriority> {
    private final OutlineResources fOutlineResources;

    public PriorityDropDownAction(PlanItem planItem, OutlineResources outlineResources) {
        super(planItem, planItem.getPlan().getPriorityAttribute(), false);
        this.fOutlineResources = outlineResources;
    }

    @Override
    protected void setValue(IPriority data) {
        this.getPlanItem().setPriority(data);
    }

    @Override
    protected List<IPriority> fastResolveValues() {
        IWorkItemClient wic = PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.getPlanItem().getPlan().getTeamRepository());
        IEnumeration enumeration = wic.findCachedEnumeration(this.getAttribute());
        if (enumeration == null) {
            return null;
        }
        return enumeration.getEnumerationLiterals();
    }

    @Override
    protected List<IPriority> slowResolveValues(IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient wic = PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.getPlanItem().getPlan().getTeamRepository());
        IEnumeration enumeration = wic.resolveEnumeration((IAttributeHandle)this.getAttribute(), monitor);
        return enumeration.getEnumerationLiterals();
    }

    @Override
    protected MenuItem createMenuItem(Menu menu, IPriority priority) {
        MenuItem item = new MenuItem(menu, 0);
        item.setImage(this.fOutlineResources.getImage(WorkItemUI.getImageDescriptor((IPriority)priority)));
        item.setText(priority.getName());
        return item;
    }
}

