/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.GAbstractLabelButton;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GPlannedIteration
extends GAbstractLabelButton {
    private PlanItem fPlanItem;

    public GPlannedIteration(CompositeGadget parent, PlanItem planItem) {
        super(parent);
        this.fPlanItem = planItem;
        IIteration target = planItem.getTarget();
        String label = target != null ? target.getLabel() : IWorkItem.UNASSIGNED_TARGET_NAME;
        this.setLabel(label);
        this.setAction((IAction)new SetTargetAction());
        this.setImage(((PlanOutlineResources)this.getOutlineResources()).getIterationImage());
    }

    private class SetTargetAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;
        private SelectionAdapter fListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MenuItem item = (MenuItem)event.widget;
                GPlannedIteration.this.fPlanItem.setTarget((IIteration)item.getData());
            }
        };

        public SetTargetAction() {
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.fMenu != null) {
                if (this.fMenu.isDisposed()) {
                    this.fMenu = null;
                } else if (!this.fMenu.isVisible()) {
                    this.fMenu.dispose();
                    this.fMenu = null;
                }
            }
        }

        public Menu getMenu(Control parent) {
            this.dispose();
            this.fMenu = new Menu(parent);
            ItemList relatedIterations = GPlannedIteration.this.fPlanItem.getRelatedIterations();
            for (IIteration iteration : relatedIterations) {
                MenuItem menuItem = this.createMenuItem(iteration.getLabel(), iteration);
                menuItem.setSelection(iteration.sameItemId((IItemHandle)GPlannedIteration.this.fPlanItem.getTargetHandle()));
            }
            MenuItem menuItem = this.createMenuItem(Messages.GPlannedIteration_NO_TARGET_ITERATION, null);
            menuItem.setSelection(GPlannedIteration.this.fPlanItem.getTargetHandle() == null);
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return this.fMenu;
        }

        private MenuItem createMenuItem(String label, IIteration iteration) {
            MenuItem result = new MenuItem(this.fMenu, 16);
            result.setText(label);
            result.setData((Object)iteration);
            result.addSelectionListener((SelectionListener)this.fListener);
            return result;
        }
    }
}

