/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.icu.text.MessageFormat;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLine;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GStatusLineItem;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.Messages;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.jface.calendar.DatePicker;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class GDueDate
extends GStatusLineItem {
    public static final int MAX_WIDTH = 100;
    private PlanItem fPlanItem;

    public GDueDate(GStatusLine parent, PlanItem planItem) {
        super(parent, Messages.GDueDate_LABEL, GDueDate.getImage(parent), GDueDate.getDueText(planItem), planItem, PlanItem.DUE_DATE);
        this.setAction((IAction)new DueDateAction());
        this.fPlanItem = planItem;
    }

    private static Image getImage(GStatusLine line) {
        return ((PlanOutlineResources)line.getOutlineResources()).getDueDateImage();
    }

    private static String getDueText(PlanItem planItem) {
        Timestamp dueDate = planItem.getDueDate();
        if (dueDate == null) {
            return Messages.GDueDate_NOT_SET;
        }
        return MessageFormat.format((String)Messages.GDueDate_SET, (Object[])new Object[]{dueDate});
    }

    private class DueDateAction
    extends Action {
        public void run() {
            Outline outline = GDueDate.this.getOutline();
            Rectangle bounds = GDueDate.this.getBounds();
            Point pickerLocation = new Point(bounds.x + bounds.width, bounds.y + bounds.height);
            pickerLocation = outline.toDisplay(GDueDate.this.getOutline().getTransformation().toViewPort(pickerLocation));
            DatePicker picker = new DatePicker(outline.getShell(), 2);
            picker.setLocation(pickerLocation.x, pickerLocation.y);
            if (GDueDate.this.fPlanItem.getDueDate() != null) {
                picker.setDate((Date)GDueDate.this.fPlanItem.getDueDate());
            }
            picker.open();
            if (picker.getDateObject() != null) {
                GDueDate.this.fPlanItem.setDueDate(new Timestamp(picker.getDateObject().getTime()));
            }
        }
    }
}

