/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common.gadgets;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.DurationSupport;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.common.duration.PlanDuration;
import com.ibm.team.workitem.common.model.Duration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DurationAttribute {
    ESTIMATE(PlanItem.ESTIMATE){

        public void setDuration(PlanItem planItem, Duration duration) {
            this.setCurrentEstimate(planItem, false, duration);
        }

        public boolean canEdit(PlanItem planItem) {
            return true;
        }
    }
    ,
    ORIGINAL_ESTIMATE(PlanItem.ORIGINAL_ESTIMATE){

        public void setDuration(PlanItem planItem, Duration duration) {
            this.setCurrentEstimate(planItem, false, duration);
        }

        public boolean canEdit(PlanItem planItem) {
            return !planItem.isEstimateCorrected();
        }
    }
    ,
    CORRECTED_ESTIMATE(PlanItem.CORRECTED_ESTIMATE){

        public void setDuration(PlanItem planItem, Duration duration) {
            this.setCurrentEstimate(planItem, true, duration);
        }

        public boolean canEdit(PlanItem planItem) {
            return true;
        }
    }
    ,
    TIME_SPENT(PlanItem.TIMESPENT){

        public boolean canEdit(PlanItem planItem) {
            return true;
        }
    }
    ,
    TIME_REMAINING(PlanItem.TIMESPENT){

        public void setDuration(PlanItem planItem, Duration duration) {
            this.setCurrentDuration(planItem, duration);
        }

        public Duration getDuration(PlanItem planItem) {
            PlanDuration duration = planItem.getDuration();
            long timeRemaining = duration.getTimeRemaining();
            if (timeRemaining == Duration.INVALID.longValue() && duration.getCorrectedEstimate() < duration.getTimeSpent()) {
                return new Duration(duration.getTimeSpent());
            }
            return new Duration(timeRemaining);
        }

        public boolean canEdit(PlanItem planItem) {
            return true;
        }
    };

    private final Attribute fDurationAttribute;

    private DurationAttribute(Attribute durationAttribute) {
        this.fDurationAttribute = durationAttribute;
    }

    public abstract boolean canEdit(PlanItem var1);

    public void setDuration(PlanItem planItem, Duration duration) {
        this.fDurationAttribute.setValue((Object)planItem, (Object)duration);
    }

    protected void setCurrentEstimate(PlanItem planItem, boolean editingCorrectedEstimate, Duration duration) {
        DurationSupport durationSupport = planItem.getPlan().getDurationSupport();
        durationSupport.setCurrentEstimate(planItem.getWorkItem(true), editingCorrectedEstimate, planItem.isResolved(), duration.longValue());
    }

    protected void setCurrentDuration(PlanItem planItem, Duration duration) {
        DurationSupport durationSupport = planItem.getPlan().getDurationSupport();
        durationSupport.setCurrentDuration(planItem.getWorkItem(true), planItem.isResolved(), duration.longValue());
    }

    public Duration getDuration(PlanItem planItem) {
        return (Duration)this.fDurationAttribute.getValue((Object)planItem);
    }

    /* synthetic */ DurationAttribute(String string, int n, Attribute attribute, DurationAttribute durationAttribute) {
        this(attribute);
    }
}

