/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.common;

import com.ibm.team.apt.internal.ide.core.util.ITeamFutureListener;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureAdapter;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.common.Messages;
import com.ibm.team.apt.internal.ide.ui.util.ItemResolver;
import com.ibm.team.apt.internal.ide.ui.util.RefreshRunnable;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IReconcileReport;
import com.ibm.team.workitem.common.model.IWorkItem;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;

public class SaveConflictItem {
    private TableViewer fViewer;
    private IReconcileReport fReport;
    private volatile IContributor fLastModifiedBy;
    private volatile String fMissingMessage;

    public SaveConflictItem(IReconcileReport report) {
        this.fReport = report;
        this.fMissingMessage = Messages.SaveConflictItem_CONTRIBUTOR_NAME_LOADING;
    }

    public void conntectTo(TableViewer viewer) {
        this.fViewer = viewer;
    }

    public String getItemType() {
        return this.getOutgoing().getWorkItemType();
    }

    public int getId() {
        return this.getOutgoing().getId();
    }

    public String getSummary() {
        return this.getOutgoing().getHTMLSummary().getPlainText();
    }

    public IWorkItem getBase() {
        return (IWorkItem)this.fReport.getBase();
    }

    public IWorkItem getOutgoing() {
        return (IWorkItem)this.fReport.getOutgoing();
    }

    public IWorkItem getIncoming() {
        return (IWorkItem)this.fReport.getIncoming();
    }

    public IReconcileReport getReconcileReport() {
        return this.fReport;
    }

    public IContributor getLastModifiedBy() {
        if (this.fLastModifiedBy != null) {
            return this.fLastModifiedBy;
        }
        ITeamRepository repository = (ITeamRepository)this.fReport.getBase().getOrigin();
        IContributorHandle handle = this.getIncoming().getModifiedBy();
        this.fLastModifiedBy = (IContributor)repository.itemManager().getSharedItemIfKnown((IItemHandle)handle);
        if (this.fLastModifiedBy != null) {
            return this.fLastModifiedBy;
        }
        TeamFuture future = new TeamFuture(new ItemResolver((IItemHandle)handle, null));
        future.addListener((ITeamFutureListener)new TeamFutureAdapter(){

            public void resolvingFailed(TeamFutureEvent event) {
                SaveConflictItem.this.fMissingMessage = Messages.SaveConflictItem_CONTRIBUTOR_NAME_LOADING_FAILED;
                new RefreshRunnable((StructuredViewer)SaveConflictItem.this.fViewer, SaveConflictItem.this).asyncExec();
            }

            public void resolvingDone(TeamFutureEvent event) {
                SaveConflictItem.this.fLastModifiedBy = (IContributor)event.getTeamFuture().getResult();
                new RefreshRunnable((StructuredViewer)SaveConflictItem.this.fViewer, SaveConflictItem.this).asyncExec();
            }

            public void resolvingCanceled(TeamFutureEvent event) {
                SaveConflictItem.this.fMissingMessage = Messages.SaveConflictItem_CONTRIBUTOR_NAME_LOADING_FAILED;
                new RefreshRunnable((StructuredViewer)SaveConflictItem.this.fViewer, SaveConflictItem.this).asyncExec();
            }
        });
        return null;
    }

    public String getMissingMessage() {
        return this.fMissingMessage;
    }
}

