/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.aspect.estimates;

import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.aspect.AbstractProcessAspectEditor;
import com.ibm.team.apt.internal.ide.ui.aspect.estimates.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.ide.ui.ProcessAspect;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class EstimationModeAspectEditor
extends AbstractProcessAspectEditor {
    private static final String ELEMENT_NAME = "estimationMode";
    private static final String ATTR_NAME = "name";
    public static final String ASPECT_ID = "com.ibm.team.apt.configuration.workItemProgressMode";
    private ComboViewer fViewer;
    private EstimateMode fMode;

    protected void createContents(Composite container) {
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)container);
        Label label = new Label(container, 131072);
        label.setImage(resources.createImage(ImagePool.DURATION));
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fViewer = new ComboViewer(container, 12);
        GridDataFactory.fillDefaults().applyTo(this.fViewer.getControl());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new EstimationLabelProvider());
        this.fViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fViewer.setInput((Object)EstimateMode.values());
        if (this.fMode != null) {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.fMode), true);
        } else {
            this.fViewer.setSelection((ISelection)new StructuredSelection((Object)EstimateMode.TimeSpent), true);
        }
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)new EstimateChangeListener());
    }

    protected void doSaveState(IMemento memento) {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        Object element = selection.getFirstElement();
        IMemento child = memento.createChild(ELEMENT_NAME);
        child.putString(ATTR_NAME, ((EstimateMode)element).name());
    }

    protected void doSetInput(ProcessAspect aspect) {
        ModelElement element = aspect.getConfigurationElement();
        if (element == null) {
            return;
        }
        List children = element.getChildElements();
        if (children.size() != 1) {
            return;
        }
        IProcessConfigurationElement item = (IProcessConfigurationElement)children.iterator().next();
        String value = item.getAttribute(ATTR_NAME);
        if (value == null) {
            return;
        }
        try {
            this.fMode = Enum.valueOf(EstimateMode.class, value);
        }
        catch (IllegalArgumentException e) {
            PlanningUIPlugin.log(e);
        }
    }

    protected String getOptionName() {
        return Messages.EstimationModeAspectEditor_OPTION_NAME;
    }

    private final class EstimateChangeListener
    implements ISelectionChangedListener {
        private EstimateChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            EstimationModeAspectEditor.this.setDirty();
        }
    }

    private final class EstimationLabelProvider
    extends LabelProvider {
        private EstimationLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof EstimateMode) {
                return ((EstimateMode)element).getDisplayName();
            }
            return super.getText(element);
        }
    }
}

