/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.client.util.Tags;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.TagsTextField;
import com.ibm.team.process.common.IProjectAreaHandle;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class TagSelectionDialog
extends StatusDialog {
    private static final int DEFAULT_HEIGHT = 150;
    private static final int DEFAULT_WIDTH = 360;
    private TagsTextField fInput;
    private String fResult;
    private final IProjectAreaHandle fProjectArea;

    public TagSelectionDialog(Shell parent, IProjectAreaHandle projectArea) {
        super(parent);
        this.fProjectArea = projectArea;
        this.setTitle(Messages.TagSelectionDialog_TITLE);
    }

    public String getResult() {
        return this.fResult;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        Label label = new Label(composite, 0);
        label.setText(Messages.TagSelectionDialog_INPUT_LABEL);
        this.fInput = new TagsTextField(composite, this.fProjectArea);
        this.fInput.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                List parsedTags = Tags.parseTags((String)TagSelectionDialog.this.fInput.getTags());
                switch (parsedTags.size()) {
                    case 0: {
                        TagSelectionDialog.this.updateStatus((IStatus)new Status(4, PlanningUI.getPluginId(), 4, Messages.TagSelectionDialog_MESSAGE_NO_TAG, null));
                        break;
                    }
                    case 1: {
                        TagSelectionDialog.this.fResult = (String)parsedTags.get(0);
                        if (!TagSelectionDialog.this.fInput.isKnownTag(TagSelectionDialog.this.fResult)) {
                            TagSelectionDialog.this.updateStatus((IStatus)new Status(2, PlanningUI.getPluginId(), 2, MessageFormat.format(Messages.TagSelectionDialog_MESSAGE_NEW_TAG, TagSelectionDialog.this.fResult), null));
                            break;
                        }
                        TagSelectionDialog.this.updateStatus(Status.OK_STATUS);
                        break;
                    }
                    default: {
                        TagSelectionDialog.this.updateStatus((IStatus)new Status(4, PlanningUI.getPluginId(), 4, Messages.TagSelectionDialog_MESSAGE_MULTIPLE_TAGS, null));
                    }
                }
            }
        });
        this.fInput.getTextField().setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)composite);
        this.updateStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), ""));
        return composite;
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        Rectangle rect = this.getParentShell().getBounds();
        shell.setBounds(Math.max(0, rect.x + (rect.width - 360) / 2), Math.max(0, rect.y + (rect.height - 150) / 2), 360, 150);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }
}

