/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.actions.ScheduleTime;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.internal.common.NLS;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulePlanItemAction
extends PlanViewModelAction<PlanItem> {
    private final ScheduleTime fScheduleTime;
    private final IIteration fIteration;

    public SchedulePlanItemAction(IWorkbenchSite site, PlanViewModel planViewModel, ScheduleTime scheduleTime, IIteration iteration) {
        super(site, planViewModel, PlanItem.class, ONE_OR_MORE);
        this.fScheduleTime = scheduleTime;
        this.fIteration = iteration;
        this.setText(NLS.bind((String)"{0}{1}", (Object)Messages.SchedulePlanItemAction_LABEL_INDENTATION, (Object)scheduleTime.getLabel()));
    }

    @Override
    protected boolean checkSelection(Collection<OutlineEntry<PlanItem>> selectedEntries) {
        boolean isCurrentTimeSlot = false;
        boolean isAvailable = true;
        for (OutlineEntry<PlanItem> entry : selectedEntries) {
            IIteration target;
            PlanItem item = entry.getElement();
            final Date[] lastScheduleDate = new Date[1];
            final ItemSequenceManager sequenceManager = item.getSequenceManager();
            if (sequenceManager != null) {
                sequenceManager.executeLocked(new Runnable(){

                    public void run() {
                        List scheduledItems = sequenceManager.getUnresolvedItems();
                        if (!scheduledItems.isEmpty()) {
                            IScheduleItem lastScheduled = (IScheduleItem)scheduledItems.get(scheduledItems.size() - 1);
                            Timespan scheduledTime = lastScheduled.getScheduledTime();
                            Assert.isNotNull((Object)scheduledTime);
                            lastScheduleDate[0] = scheduledTime.getEnd();
                        }
                        if (lastScheduleDate[0] == null) {
                            lastScheduleDate[0] = sequenceManager.getWorkStart();
                        }
                    }
                });
            }
            Timespan scheduledTime = item.getScheduledTime();
            if (item.getFixedStartDate() == null && scheduledTime != null && this.fScheduleTime.isInGroup(scheduledTime.getStart())) {
                isCurrentTimeSlot = true;
                continue;
            }
            if (!isAvailable || isCurrentTimeSlot) continue;
            if (!this.fScheduleTime.isAvailable() || this.fScheduleTime.getStartTime().after(lastScheduleDate[0])) {
                isAvailable = false;
                continue;
            }
            IIteration iIteration = target = this.fIteration != null ? this.fIteration : item.getTarget();
            if (item.isResolved() || target == null || !item.getPlan().getPlannedIterations().contains((Object)target)) {
                isAvailable = false;
                continue;
            }
            if (target.getEndDate() == null || !this.fScheduleTime.getStartTime().after(target.getEndDate())) continue;
            isAvailable = false;
        }
        this.setChecked(isCurrentTimeSlot);
        return isAvailable || isCurrentTimeSlot;
    }

    @Override
    public void run(Collection<OutlineEntry<PlanItem>> selectedEntries) {
        PlanItem firstScheduled = null;
        for (OutlineEntry outlineEntry : selectedEntries) {
            PlanItem item = (PlanItem)outlineEntry.getElement();
            ResolvedPlan plan = item.getPlan();
            plan.connectDeltaBuilder();
            try {
                if (this.fIteration != null) {
                    item.setTarget(this.fIteration);
                }
                if (firstScheduled == null) {
                    item.schedule(this.fScheduleTime.getScheduleTime());
                } else {
                    item.schedule(firstScheduled, null);
                }
                item.markRead();
            }
            finally {
                plan.disconnectDeltaBuilder();
            }
        }
        this.getPlanViewModel().setSelectedElements(EntryUtils.elements(selectedEntries));
    }
}

