/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Event;

public class RetargetAction
extends Action {
    private IAction fHandler;
    private String fDefaultLabel;
    private ImageDescriptor fDefaultDisabledImage;
    private IPropertyChangeListener fListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            RetargetAction.this.update(event);
        }
    };

    public RetargetAction(String label, ImageDescriptor defaultDisabledImage, String actionDefinitionId) {
        this.fDefaultLabel = label;
        this.fDefaultDisabledImage = defaultDisabledImage;
        this.setActionDefinitionId(actionDefinitionId);
        this.setId(actionDefinitionId);
        this.setText(label);
        this.setEnabled(false);
        this.setDisabledImageDescriptor(defaultDisabledImage);
    }

    public String getActionDefinitionId() {
        return super.getActionDefinitionId();
    }

    public void setHandler(IAction handler) {
        if (this.fHandler != null) {
            this.fHandler.removePropertyChangeListener(this.fListener);
            this.fHandler = null;
        }
        this.fHandler = handler;
        if (this.fHandler == null) {
            this.setEnabled(false);
            if (this.getStyle() == 2 || this.getStyle() == 8) {
                this.setChecked(false);
            }
            this.setText(this.fDefaultLabel);
            this.setToolTipText("");
            this.setImageDescriptor(this.fDefaultDisabledImage);
        } else {
            this.setEnabled(this.fHandler.isEnabled());
            if (this.fHandler.getStyle() == 2 || this.fHandler.getStyle() == 8) {
                super.setChecked(this.fHandler.isChecked());
            }
            this.setText(this.fHandler.getText());
            this.setToolTipText(this.fHandler.getToolTipText());
            this.setImageDescriptor(this.fHandler.getImageDescriptor());
            this.setDisabledImageDescriptor(this.fHandler.getDisabledImageDescriptor());
            this.fHandler.addPropertyChangeListener(this.fListener);
        }
    }

    public void run() {
        if (this.fHandler != null) {
            this.fHandler.run();
        }
    }

    public void runWithEvent(Event event) {
        if (this.fHandler != null) {
            this.fHandler.runWithEvent(event);
        }
    }

    private void update(PropertyChangeEvent event) {
        if ("enabled".equals(event.getProperty())) {
            Boolean bool = (Boolean)event.getNewValue();
            this.setEnabled(bool);
        } else if ("text".equals(event.getProperty())) {
            this.setText((String)event.getNewValue());
        } else if ("toolTipText".equals(event.getProperty())) {
            this.setToolTipText((String)event.getNewValue());
        } else if ("checked".equals(event.getProperty())) {
            Boolean bool = (Boolean)event.getNewValue();
            this.setChecked(bool);
        } else if ("image".equals(event.getProperty())) {
            this.setImageDescriptor(this.fHandler.getImageDescriptor());
            this.setDisabledImageDescriptor(this.fHandler.getDisabledImageDescriptor());
        }
    }
}

