/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.actions;

import com.ibm.icu.text.Collator;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.util.Categories;
import com.ibm.team.apt.internal.common.IWorkHoursDefinition;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.apt.internal.common.util.LinkedItemHashSet;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.actions.AssignCategoryAction;
import com.ibm.team.apt.internal.ide.ui.actions.AssignOwnerAction;
import com.ibm.team.apt.internal.ide.ui.actions.AssignPlanTargetAction;
import com.ibm.team.apt.internal.ide.ui.actions.AssignTagAction;
import com.ibm.team.apt.internal.ide.ui.actions.AssignTargetAction;
import com.ibm.team.apt.internal.ide.ui.actions.IRecentlyUsedTagsRegistry;
import com.ibm.team.apt.internal.ide.ui.actions.Messages;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.actions.SchedulePlanItemAction;
import com.ibm.team.apt.internal.ide.ui.actions.ScheduleTime;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineEntry;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.model.ICategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignActionFactory {
    private final IWorkbenchSite fSite;
    private final PlanViewModel fViewModel;
    private List<PlanViewModelAction<?>> fAssignTargetActions;
    private List<PlanViewModelAction<?>> fAssignOwnerActions;
    private List<PlanViewModelAction<?>> fAssignCategoryActions;

    public AssignActionFactory(IWorkbenchSite site, PlanViewModel viewModel) {
        this.fSite = site;
        this.fViewModel = viewModel;
    }

    public boolean isEnabled() {
        Collection<?> elements = this.fViewModel.getSelectedElements();
        for (Object elememt : elements) {
            if (!(elememt instanceof PlanItem)) {
                return false;
            }
            if (!((PlanItem)elememt).isProgressPlanItem()) continue;
            return false;
        }
        return true;
    }

    public IMenuManager getAssignTargetMenu() {
        if (this.fAssignTargetActions == null) {
            this.createAssignTargetActions();
        }
        return this.buildMenu(this.fAssignTargetActions, Messages.AssignActionFactory_MENU_PLAN_FOR_ITERATION_ONLY);
    }

    public IMenuManager getAssignOwnerMenu() {
        if (this.fAssignOwnerActions == null) {
            this.createAssignOwnerActions();
        }
        return this.buildMenu(this.fAssignOwnerActions, Messages.AssignActionFactory_MENU_ASSIGN_OWNER);
    }

    public IMenuManager getAssignCategoryMenu() {
        if (this.fAssignCategoryActions == null) {
            this.createAssignCategoryActions();
        }
        return this.buildMenu(this.fAssignCategoryActions, Messages.AssignActionFactory_MENU_ASSIGN_CATEGORY);
    }

    public IMenuManager getAssignTagMenu() {
        Collection<OutlineEntry<?>> selectedEntries = this.fViewModel.getSelectedEntries();
        MenuManager menu = new MenuManager(Messages.AssignActionFactory_MENU_ASSIGN_TAG);
        if (!selectedEntries.isEmpty()) {
            HashSet<String> allTags = new HashSet<String>();
            for (OutlineEntry<?> entry : selectedEntries) {
                Object node = entry.getElement();
                if (!(node instanceof PlanItem)) continue;
                allTags.addAll(((PlanItem)node).getTags());
            }
            ResolvedPlan input = (ResolvedPlan)this.fViewModel.getInput();
            allTags.addAll(input.getPopularTags(5));
            IRecentlyUsedTagsRegistry recentlyUsedTagsRegistry = PlanningUIPlugin.getDefault().getRecentlyUsedTagsRegistry();
            allTags.addAll(recentlyUsedTagsRegistry.getTags(3));
            ArrayList sortedTags = new ArrayList(allTags);
            Collections.sort(sortedTags, Collator.getInstance());
            for (String tag : sortedTags) {
                this.addToMenu(new AssignTagAction(this.fSite, this.fViewModel, tag, recentlyUsedTagsRegistry), (IMenuManager)menu, false);
            }
            this.addToMenu(new AssignTagAction(this.fSite, this.fViewModel, null, recentlyUsedTagsRegistry), (IMenuManager)menu, true);
        }
        return menu;
    }

    public IMenuManager getPlanningMenu() {
        Collection<OutlineEntry<?>> selectedEntries = this.fViewModel.getSelectedEntries();
        MenuManager menu = new MenuManager(Messages.AssignActionFactory_MENU_PLAN_FOR_WITH_SCHEDULE);
        if (!selectedEntries.isEmpty()) {
            LinkedItemHashSet allRelatedIterations = new LinkedItemHashSet();
            for (OutlineEntry<?> entry : selectedEntries) {
                Object node = entry.getElement();
                if (!(node instanceof PlanItem)) continue;
                for (IIteration iteration : ((PlanItem)node).getRelatedIterations()) {
                    if (allRelatedIterations.contains((Object)iteration)) continue;
                    allRelatedIterations.add((Object)iteration);
                }
            }
            ItemSet plannedIterations = this.getPlan().getPlannedIterations();
            boolean needsSeparator = false;
            for (IIteration iteration : plannedIterations) {
                if (!allRelatedIterations.contains((Object)iteration)) continue;
                needsSeparator = this.buildScheduleMenu(selectedEntries, iteration, (IMenuManager)menu, needsSeparator);
            }
            for (IIteration iteration : allRelatedIterations) {
                if (plannedIterations.contains((Object)iteration)) continue;
                needsSeparator &= !this.addToMenu(new AssignTargetAction(this.fSite, this.fViewModel, iteration, true), (IMenuManager)menu, needsSeparator);
            }
            this.addToMenu(new AssignTargetAction(this.fSite, this.fViewModel, null, true), (IMenuManager)menu, needsSeparator);
        }
        return menu;
    }

    private boolean buildScheduleMenu(Collection<OutlineEntry<?>> selectedEntries, IIteration iteration, IMenuManager menu, boolean needsSeparator) {
        ArrayList actions = new ArrayList();
        IWorkHoursDefinition workHours = null;
        for (OutlineEntry<?> entry : selectedEntries) {
            Object element = entry.getElement();
            if (!(element instanceof PlanItem)) continue;
            PlanItem planItem = (PlanItem)element;
            ResolvedPlan plan = planItem.getPlan();
            if (plan instanceof ResolvedIterationPlan) {
                IContributor owner = planItem.getOwner();
                if (plan.getNullOwner().sameItemId((IItemHandle)owner)) continue;
                workHours = ((ResolvedIterationPlan)plan).getWorkHourDefinitions((IContributorHandle)owner);
                continue;
            }
            if (!(plan instanceof ResolvedPersonalPlan)) continue;
            workHours = ((ResolvedPersonalPlan)plan).getWorkHourDefinitions();
        }
        actions.add(new AssignPlanTargetAction(this.fSite, this.fViewModel, iteration, true, iteration.getLabel()));
        if (workHours != null) {
            Date referenceTime = this.getPlan().getReferenceTime();
            ScheduleTime[] times = new ScheduleTime[]{new ScheduleTime.LaterToday(referenceTime, workHours), new ScheduleTime.Day(Messages.AssignActionFactory_PLAN_FOR_TOMORROW, 1, referenceTime, workHours), new ScheduleTime.DayWithDayLabel(2, referenceTime, workHours), new ScheduleTime.Weeks(Messages.AssignActionFactory_PLAN_FOR_LATER_THIS_WEEK, 0, 1, referenceTime, workHours), new ScheduleTime.Weeks(Messages.AssignActionFactory_PLAN_FOR_NEXT_WEEK, 1, 1, referenceTime, workHours), new ScheduleTime.Weeks(Messages.AssignActionFactory_PLAN_FOR_IN_TWO_WEEKS, 2, 2, referenceTime, workHours), new ScheduleTime.Weeks(Messages.AssignActionFactory_PLAN_FOR_IN_ONE_MONTH, 4, 4, referenceTime, workHours), new ScheduleTime.Future(Messages.AssignActionFactory_PLAN_FOR_FUTURE, 5, referenceTime, workHours)};
            int i = 0;
            while (i < times.length) {
                ScheduleTime time = times[i];
                if (i > 0) {
                    time.setPrevious(times[i - 1]);
                }
                actions.add(new SchedulePlanItemAction(this.fSite, this.fViewModel, time, iteration));
                ++i;
            }
        }
        return this.addToMenu(actions, menu, needsSeparator);
    }

    private void createAssignTargetActions() {
        this.fAssignTargetActions = new ArrayList();
        ItemList relatedIterations = null;
        if (this.getPlan() instanceof ResolvedIterationPlan) {
            relatedIterations = ((ResolvedIterationPlan)this.getPlan()).getRelatedIterations();
        }
        if (relatedIterations != null) {
            for (IIteration interval : relatedIterations) {
                this.fAssignTargetActions.add(new AssignTargetAction(this.fSite, this.fViewModel, interval, false));
            }
            this.fAssignTargetActions.add(new AssignTargetAction(this.fSite, this.fViewModel, null, false));
        }
    }

    private void createAssignOwnerActions() {
        this.fAssignOwnerActions = new ArrayList();
        ArrayList<IContributor> owners = new ArrayList<IContributor>();
        for (IContributor owner : this.getPlan().getOwners()) {
            owners.add(owner);
        }
        owners.remove(this.getPlan().getNullOwner());
        Collections.sort(owners, new Comparator<IContributor>(){

            @Override
            public int compare(IContributor o1, IContributor o2) {
                return Collator.getInstance().compare(o1.getName(), o2.getName());
            }
        });
        this.fAssignOwnerActions.add(new AssignOwnerAction(this.fSite, this.fViewModel, this.getPlan().getNullOwner()));
        for (IContributor contributor : owners) {
            this.fAssignOwnerActions.add(new AssignOwnerAction(this.fSite, this.fViewModel, contributor));
        }
    }

    private void createAssignCategoryActions() {
        this.fAssignCategoryActions = new ArrayList();
        ArrayList<ICategory> categories = new ArrayList<ICategory>();
        for (ICategory category : this.getPlan().getCategories()) {
            categories.add(category);
        }
        Categories.sort(categories);
        ICategory previousCategory = null;
        for (ICategory category : categories) {
            if (category.isArchived()) continue;
            this.fAssignCategoryActions.add(new AssignCategoryAction(this.fSite, this.fViewModel, previousCategory, category));
            previousCategory = category;
        }
    }

    private IMenuManager buildMenu(List<PlanViewModelAction<?>> actions, String label) {
        MenuManager menu = new MenuManager(label);
        this.addToMenu(actions, (IMenuManager)menu, false);
        return menu;
    }

    private boolean addToMenu(List<PlanViewModelAction<?>> actions, IMenuManager menu, boolean needsSeparator) {
        boolean result = false;
        for (PlanViewModelAction<?> action : actions) {
            boolean wasAdded;
            needsSeparator &= !(wasAdded = this.addToMenu(action, menu, needsSeparator));
            result |= wasAdded;
        }
        return result;
    }

    private boolean addToMenu(PlanViewModelAction<?> action, IMenuManager menu, boolean needsSeparator) {
        action.update();
        if (action.isEnabled()) {
            if (needsSeparator) {
                menu.add((IContributionItem)new Separator());
            }
            menu.add(action);
            return true;
        }
        return false;
    }

    private ResolvedPlan getPlan() {
        return (ResolvedPlan)this.fViewModel.getInput();
    }
}

