/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.ide.ui.quickquery;

import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttribute;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryAttributeFactory;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryContext;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryDefinition;
import com.ibm.team.apt.ide.ui.quickquery.IQuickQueryWordConsumer;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.quickquery.workitem.QuickQueryDefinition;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;

public class QuickQueryTypeRegistry {
    private static final String QUERYTYPE_EXTENSION_POINT_ID = String.valueOf(PlanningUIPlugin.getPluginId()) + ".quickQueryType";
    private static final String QUERYTYPE_EXTENSION_NAME = "quickQueryType";
    private static Map<String, DefinitionProxy> fgQueryDefinitions;
    private static Map<String, Object> fgInstantiatedFactories;
    private static final String ID_ATTRIBUTE = "id";
    private static final String DEFAULT_WORD_CONSUMER_ATTRIBUTE = "defaultWordConsumer";
    private static final String ATTRIBUTE_FACTORY_ELEMENT = "attributeFactory";
    private static final String WORD_CONSUMER_ELEMENT = "wordConsumer";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    private static final IQuickQueryDefinition fgNullDefinition;

    static {
        fgInstantiatedFactories = new HashMap<String, Object>();
        fgNullDefinition = new IQuickQueryDefinition(){

            @Override
            public IQuickQueryAttribute findAttribute(IQuickQueryContext context, String keyword) throws TeamRepositoryException {
                return null;
            }

            public List<IQuickQueryAttribute> findAllAttributes(IQuickQueryContext context) throws TeamRepositoryException {
                return Collections.EMPTY_LIST;
            }

            @Override
            public Expression buildWordExpression(IQuickQueryContext context, String word, IProgressMonitor monitor) throws TeamRepositoryException {
                return null;
            }

            @Override
            public Collection<String> getWordProposals(IQuickQueryContext context, IProgressMonitor monitor) throws TeamRepositoryException {
                return Collections.EMPTY_SET;
            }
        };
    }

    public static IQuickQueryDefinition getQuickQueryDefinition(String id) {
        QuickQueryTypeRegistry.initialize();
        DefinitionProxy proxy = fgQueryDefinitions.get(id);
        if (proxy != null) {
            try {
                return proxy.getQuickQueryDefinition();
            }
            catch (CoreException e) {
                PlanningUIPlugin.log(e);
            }
        }
        return fgNullDefinition;
    }

    private static synchronized void initialize() {
        if (fgQueryDefinitions != null) {
            return;
        }
        fgQueryDefinitions = new HashMap<String, DefinitionProxy>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(QUERYTYPE_EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(QUERYTYPE_EXTENSION_NAME)) {
                        IConfigurationElement[] wordConsumers;
                        IConfigurationElement[] factories;
                        String queryTypeId = element.getAttribute(ID_ATTRIBUTE);
                        DefinitionProxy proxy = fgQueryDefinitions.get(queryTypeId);
                        if (proxy == null) {
                            proxy = new DefinitionProxy(element);
                            fgQueryDefinitions.put(queryTypeId, proxy);
                        }
                        IConfigurationElement[] iConfigurationElementArray = factories = element.getChildren(ATTRIBUTE_FACTORY_ELEMENT);
                        int n = factories.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfigurationElement factory = iConfigurationElementArray[n2];
                            proxy.addAttributeFactoryConfig(factory);
                            ++n2;
                        }
                        IConfigurationElement[] iConfigurationElementArray2 = wordConsumers = element.getChildren(WORD_CONSUMER_ELEMENT);
                        int n3 = wordConsumers.length;
                        n = 0;
                        while (n < n3) {
                            IConfigurationElement wordConsumer = iConfigurationElementArray2[n];
                            proxy.addWordConsumerConfig(wordConsumer);
                            ++n;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private static Object createFactory(IConfigurationElement config, String attribute) throws CoreException {
        String className = config.getAttribute(attribute);
        Object factory = fgInstantiatedFactories.get(className);
        if (factory == null) {
            factory = config.createExecutableExtension(attribute);
            fgInstantiatedFactories.put(className, factory);
        }
        return factory;
    }

    private static class DefinitionProxy {
        private final List<IConfigurationElement> fAttributeFactoryConfigs = new ArrayList<IConfigurationElement>();
        private final List<IConfigurationElement> fWordConsumerConfigs = new ArrayList<IConfigurationElement>();
        private final IConfigurationElement fDefinitionConfig;
        private IQuickQueryDefinition fInstantiatedDefinition;

        public DefinitionProxy(IConfigurationElement definitionConfig) {
            this.fDefinitionConfig = definitionConfig;
        }

        public void addAttributeFactoryConfig(IConfigurationElement element) {
            if (this.fInstantiatedDefinition != null) {
                throw new IllegalStateException("Can't add factories requisites after creation");
            }
            this.fAttributeFactoryConfigs.add(element);
        }

        public void addWordConsumerConfig(IConfigurationElement element) {
            if (this.fInstantiatedDefinition != null) {
                throw new IllegalStateException("Can't add factories requisites after creation");
            }
            this.fWordConsumerConfigs.add(element);
        }

        public IQuickQueryDefinition getQuickQueryDefinition() throws CoreException {
            if (this.fInstantiatedDefinition == null) {
                Comparator<IConfigurationElement> comparator = new Comparator<IConfigurationElement>(){

                    @Override
                    public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                        return Integer.parseInt(o2.getAttribute(QuickQueryTypeRegistry.PRIORITY_ATTRIBUTE)) - Integer.parseInt(o1.getAttribute(QuickQueryTypeRegistry.PRIORITY_ATTRIBUTE));
                    }
                };
                Collections.sort(this.fAttributeFactoryConfigs, comparator);
                ArrayList<IQuickQueryAttributeFactory> attributeFactories = new ArrayList<IQuickQueryAttributeFactory>();
                for (IConfigurationElement factoryConfig : this.fAttributeFactoryConfigs) {
                    attributeFactories.add((IQuickQueryAttributeFactory)QuickQueryTypeRegistry.createFactory(factoryConfig, QuickQueryTypeRegistry.CLASS_ATTRIBUTE));
                }
                Collections.sort(this.fWordConsumerConfigs, comparator);
                ArrayList<IQuickQueryWordConsumer> wordConsumers = new ArrayList<IQuickQueryWordConsumer>();
                for (IConfigurationElement wordConsumerConfig : this.fWordConsumerConfigs) {
                    wordConsumers.add((IQuickQueryWordConsumer)QuickQueryTypeRegistry.createFactory(wordConsumerConfig, QuickQueryTypeRegistry.CLASS_ATTRIBUTE));
                }
                IQuickQueryWordConsumer defaultWordConsumer = (IQuickQueryWordConsumer)QuickQueryTypeRegistry.createFactory(this.fDefinitionConfig, QuickQueryTypeRegistry.DEFAULT_WORD_CONSUMER_ATTRIBUTE);
                this.fInstantiatedDefinition = new QuickQueryDefinition(defaultWordConsumer, wordConsumers, attributeFactories);
            }
            return this.fInstantiatedDefinition;
        }
    }
}

