/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.wiki.transformer;

import com.ibm.team.apt.internal.common.wiki.transformer.IItemReferenceDetector;
import com.ibm.team.apt.internal.common.wiki.transformer.IReferenceTransformer;
import com.ibm.team.apt.internal.common.wiki.transformer.IVariableResolver;
import com.ibm.team.apt.internal.common.wiki.transformer.Lexer;
import com.ibm.team.apt.internal.common.wiki.transformer.LexerInput;
import com.ibm.team.apt.internal.common.wiki.transformer.Symbol;
import com.ibm.team.apt.internal.common.wiki.transformer.Token;
import com.ibm.team.apt.internal.common.wiki.transformer.Tokens;
import com.ibm.team.apt.internal.common.wiki.transformer.TranslationScheme;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.ListIterator;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer {
    public static final EnumSet<Option> DEFAULT_OPTIONS = EnumSet.allOf(Option.class);
    private IItemReferenceDetector fItemReferenceDetector;
    private IReferenceTransformer fReferenceTransformer;
    private IVariableResolver fVariableResolver;
    private final ArrayList<OutputItem> fOutput = new ArrayList(70);
    private final StringBuilder fXhtmlBuffer = new StringBuilder(2048);
    private final Lexer fLexer = new Lexer();
    private Symbol fCurrent;
    private EnumSet<Option> fSettings;
    private IItemReferenceDetector.Reference fContext;
    private boolean escapeXhtmlChars = true;
    private boolean starStarColorAllowed = true;
    private static final Token[] LINE_START = Transformer.merge(Tokens.COLORS, Token.CHARACTER, Token.WHITESPACE, Token.TAB, Token.LINK_START, Token.IMG_START, Token.ITALICS, Token.UNDERLINE, Token.STRIKE_OUT, Token.LINE_BREAK);

    public static String format(String str, Object ... args) {
        if (args.length == 0) {
            return str;
        }
        if (args.length == 1) {
            return str.replace("%", String.valueOf(args[0]));
        }
        StringBuilder text = new StringBuilder();
        int index = 0;
        char[] chars = str.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c == '%') {
                if (index < args.length) {
                    text.append(args[index++]);
                } else {
                    text.append("null");
                }
            } else {
                text.append(c);
            }
            ++i;
        }
        return text.toString();
    }

    public String transform(String wiki) {
        return this.transform(wiki, DEFAULT_OPTIONS);
    }

    public String transform(String wiki, EnumSet<Option> settings) {
        if (wiki.length() == 0) {
            return wiki;
        }
        this.init(wiki, settings);
        this._text();
        return this.fXhtmlBuffer.toString();
    }

    private void init(String wiki, EnumSet<Option> settings) {
        this.fSettings = settings;
        this.fOutput.clear();
        this.fXhtmlBuffer.delete(0, this.fXhtmlBuffer.length());
        this.fXhtmlBuffer.ensureCapacity((int)((double)wiki.length() * 2.3));
        this.fLexer.setInput(new LexerInput(wiki));
        this.next();
    }

    public void setVariableResolver(IVariableResolver variableResolver) {
        this.fVariableResolver = variableResolver;
    }

    public void setItemReferenceDetector(IItemReferenceDetector itemReferenceDetector) {
        this.fItemReferenceDetector = itemReferenceDetector;
    }

    public void setReferenceTransformer(IReferenceTransformer itemReferenceCreator) {
        this.fReferenceTransformer = itemReferenceCreator;
    }

    protected void _text() {
        Token match = null;
        while (!this.matches(Token.EOF)) {
            match = this.find(Tokens.HEADINGS);
            if (match != null) {
                this._headings(match);
            } else {
                match = this.find(Token.BULLET_1, Token.NUMBERED_1);
                if (match != null) {
                    this._item(match);
                } else if (this.matches(Token.SEPARATOR)) {
                    this._table();
                } else if (this.matches(Token.HORIZONTAL_LINE)) {
                    this._hline();
                } else {
                    this._paragraph();
                }
            }
            for (OutputItem item : this.fOutput) {
                this.fXhtmlBuffer.append(item.fOutput);
            }
            this.fOutput.clear();
        }
    }

    protected boolean _headings(Token token) {
        if (!this.accept(token)) {
            return false;
        }
        int last = this.fOutput.size() - 1;
        this.fOutput.get(last).transform(TranslationScheme.start(token), new Object[0]);
        while (!this.matches(Tokens.EOL) && !this.matches(Token.EOF, Token.LINE_BREAK)) {
            if (this._lines()) continue;
            if (this.matches(token) && (this.sneak(Tokens.EOL) || this.sneak(Token.EOF))) {
                this.next();
                continue;
            }
            this.accept(new Token[0]);
        }
        this.fOutput.add(new OutputItem(TranslationScheme.end(token)));
        if (this.matches(Token.LINE_BREAK)) {
            this.next();
        } else {
            this.accept(new Token[0]);
        }
        if (!this.accept(Tokens.EOL) && !this.accept(Token.EOF)) {
            return false;
        }
        return !this.matches(Token.CHARACTER);
    }

    protected boolean _item(Token token) {
        this.accept(token);
        Stack<OutputItem> stack = new Stack<OutputItem>();
        this.starStarColorAllowed = false;
        this._itemInternal(stack, token, 1);
        this.starStarColorAllowed = true;
        while (!stack.isEmpty()) {
            this.fOutput.add(stack.pop());
        }
        return true;
    }

    private boolean _itemInternal(Stack<OutputItem> stack, Token token, int level) {
        int nextLevel;
        int last;
        boolean removeLast = true;
        if (stack.size() != level) {
            removeLast = false;
            last = this.fOutput.size() - 1;
            this.fOutput.remove(last);
            while (level < stack.size()) {
                this.fOutput.add(stack.pop());
            }
            while (level > stack.size()) {
                boolean ol = EnumSet.of(Token.NUMBERED_1, Token.NUMBERED_2, Token.NUMBERED_3, Token.NUMBERED_4, Token.NUMBERED_5).contains((Object)token);
                this.fOutput.add(new OutputItem(ol ? TranslationScheme.NUMBERED.start : TranslationScheme.BULLET.start));
                stack.push(new OutputItem(ol ? TranslationScheme.NUMBERED.end : TranslationScheme.BULLET.end));
            }
        }
        if (removeLast) {
            last = this.fOutput.size() - 1;
            this.fOutput.remove(last);
        }
        this.fOutput.add(new OutputItem(TranslationScheme.ITEM.start));
        this._formatted(true, new Token[0]);
        this.fOutput.add(new OutputItem(TranslationScheme.ITEM.end));
        if (this.accept(Token.EOF)) {
            return true;
        }
        this.accept(Tokens.EOL);
        Token nextToken = this.find(EnumSet.range(Token.BULLET_1, Token.NUMBERED_5).toArray(new Token[0]));
        if (nextToken != null && (nextLevel = this._itemLevel(nextToken)) != -1 && (nextLevel < level || nextLevel >= level && nextLevel - level <= 1)) {
            this.accept(nextToken);
            this._itemInternal(stack, nextToken, nextLevel);
        }
        return true;
    }

    private int _itemLevel(Token token) {
        switch (token) {
            case BULLET_1: 
            case NUMBERED_1: {
                return 1;
            }
            case BULLET_2: 
            case NUMBERED_2: {
                return 2;
            }
            case BULLET_3: 
            case NUMBERED_3: {
                return 3;
            }
            case BULLET_4: 
            case NUMBERED_4: {
                return 4;
            }
            case BULLET_5: 
            case NUMBERED_5: {
                return 5;
            }
        }
        return -1;
    }

    private boolean _paragraph() {
        this.fOutput.add(new OutputItem(TranslationScheme.PARAGRPH.start));
        this._formatted(true, new Token[0]);
        this.fOutput.add(new OutputItem(TranslationScheme.PARAGRPH.end));
        if (this.accept(Token.EOF)) {
            return true;
        }
        if (!this.accept(Tokens.EOL)) {
            return false;
        }
        return this.accept(Tokens.EOL) || this.accept(Token.EOF);
    }

    protected boolean _table() {
        int index = this.fOutput.size();
        if (this._tableRows(1)) {
            this.fOutput.add(index, new OutputItem(TranslationScheme.TABLE.start));
            this.fOutput.add(new OutputItem(TranslationScheme.TABLE.end));
            return true;
        }
        return false;
    }

    protected boolean _tableRows(int odd) {
        int index = this.fOutput.size();
        boolean match = this._tableCells();
        if (match) {
            this.fOutput.add(index, new OutputItem(Transformer.format(TranslationScheme.ROW.start, odd % 2 == 1 ? "odd" : "even")));
            this.fOutput.add(new OutputItem(TranslationScheme.ROW.end));
            if (this.accept(Tokens.EOL)) {
                this._tableRows(odd + 1);
            }
        }
        return match;
    }

    protected boolean _tableCells() {
        if (!this.accept(Token.SEPARATOR)) {
            return false;
        }
        int index = this.fOutput.size() - 1;
        boolean hCell = this.accept(Token.HEADING_1);
        if (hCell) {
            int last = this.fOutput.size() - 1;
            this.fOutput.remove(last);
        }
        if (!this._formatted(false, Token.SEPARATOR)) {
            if (hCell) {
                this.fOutput.add(index + 1, new OutputItem(Token.HEADING_1.wiki));
            }
            this.fOutput.remove(index);
            return false;
        }
        this.fOutput.get(index).transform(hCell ? TranslationScheme.HCELL.start : TranslationScheme.CELL.start, new Object[0]);
        this.fOutput.add(new OutputItem(hCell ? TranslationScheme.HCELL.end : TranslationScheme.CELL.end));
        this._tableCells();
        return true;
    }

    protected boolean _formatted(boolean eol, Token ... returnOn) {
        Stack<StackItem> stack = new Stack<StackItem>();
        boolean result = this._formattedInternal(stack, eol, returnOn);
        while (!stack.isEmpty()) {
            Token token = stack.peek().token;
            if (EnumSet.of(Token.COLOR, Token.LINK_START, Token.IMG_START).contains((Object)token)) {
                stack.pop();
                continue;
            }
            this.fOutput.add(new OutputItem(token.wiki));
            this.popClose(stack, token, TranslationScheme.start(token), new Object[0]);
        }
        return result;
    }

    private boolean _formattedInternal(Stack<StackItem> stack, boolean eol, Token ... returnOn) {
        boolean match;
        if (this.matches(returnOn)) {
            return false;
        }
        boolean bl = match = eol && this._lines() || this._characters() || this._linebreak() || this._code() || this._xhtml() || this._variable() || this._formats(stack) || this._wikilink(stack, eol, returnOn) || this._foreground(stack, eol, returnOn) || this._background(stack, eol, returnOn) || this._image(stack) || this._unspecified();
        if (match) {
            this._formattedInternal(stack, eol, returnOn);
            return true;
        }
        return false;
    }

    protected boolean _unspecified() {
        if (this.matches(Token.CR, Token.CR_LF, Token.LF, Token.EOF)) {
            return false;
        }
        this.accept(new Token[0]);
        return true;
    }

    protected boolean _linebreak() {
        if (!this.accept(Token.LINE_BREAK)) {
            return false;
        }
        int last = this.fOutput.size() - 1;
        this.fOutput.get(last).transform(TranslationScheme.LINE_BREAK.start, new Object[0]);
        return true;
    }

    protected boolean _formats(Stack<StackItem> stack) {
        Token token = this.find(Tokens.FORMATS);
        if (token == null) {
            return false;
        }
        this.accept(token);
        if (this.findOnStack(stack, token) == null) {
            this.pushOpen(stack, token);
        } else {
            this.popClose(stack, token, TranslationScheme.start(token), new Object[0]);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean _foreground(Stack<StackItem> stack, boolean eol, Token ... returnOn) {
        Token token = this.find(Tokens.COLORS);
        if (token == null) {
            return false;
        }
        StackItem item = this.findOnStack(stack, Token.COLOR);
        if (item != null) {
            return false;
        }
        this.accept(token);
        String fgColor = token.wiki;
        int index = this.fOutput.size() - 1;
        if (!this.accept(Token.COLOR)) return true;
        this.pushOpen(stack, Token.COLOR);
        if (!this._formattedInternal(stack, eol, Transformer.merge(returnOn, Token.COLOR, new Token[0]))) return false;
        if (!this.accept(Token.COLOR)) return false;
        Token match = this.find(Tokens.COLORS);
        if (match != null) {
            String bgColor = match.wiki;
            this.next();
            this.popClose(stack, Token.COLOR, TranslationScheme.FG_BG_COLOR.start, fgColor, bgColor);
        } else {
            this.popClose(stack, Token.COLOR, TranslationScheme.FG_COLOR.start, fgColor);
        }
        this.fOutput.remove(index);
        return true;
    }

    protected boolean _background(Stack<StackItem> stack, boolean eol, Token ... returnOn) {
        Token match;
        if (!this.accept(Token.COLOR)) {
            return false;
        }
        this.pushOpen(stack, Token.COLOR);
        if (this._formattedInternal(stack, eol, Transformer.merge(returnOn, Token.COLOR, new Token[0])) && this.accept(Token.COLOR) && (match = this.find(Tokens.COLORS)) != null) {
            String color = match.wiki;
            this.next();
            this.popClose(stack, Token.COLOR, TranslationScheme.BG_COLOR.start, color);
        }
        return true;
    }

    protected boolean _image(Stack<StackItem> stack) {
        if (!this.accept(Token.IMG_START)) {
            return false;
        }
        StringBuilder title = new StringBuilder();
        StringBuilder src = new StringBuilder();
        if (this._until(src, Token.SEPARATOR, Token.IMG_END, Token.CR, Token.CR_LF, Token.LF, Token.EOF)) {
            String id;
            this.pushOpen(stack, Token.IMG_START);
            title.append(src.toString());
            IItemReferenceDetector.Reference reference = null;
            if (this.fSettings.contains((Object)Option.REFERENCES) && this.fItemReferenceDetector != null && (reference = this.fItemReferenceDetector.detect(src.toString().trim())) != null) {
                if (this.fReferenceTransformer != null) {
                    this.fReferenceTransformer.transform(reference);
                }
                title.setLength(0);
                title.append(Token.IMG_START.wiki);
                title.append(src.toString());
                title.append(Token.IMG_END.wiki);
                src.setLength(0);
                src.append(reference.getReference());
            }
            String string = id = reference != null ? reference.getId() : null;
            if (this.matches(Token.SEPARATOR)) {
                this.next();
                title.delete(0, title.length());
                if (this._until(title, Token.IMG_END, Token.EOF, Token.CR, Token.CR_LF) && this.accept(Token.IMG_END)) {
                    this.popClose(stack, Token.IMG_START, TranslationScheme.IMAGE.start, src, title, id);
                    return true;
                }
            } else {
                if (this.accept(Token.IMG_END)) {
                    this.popClose(stack, Token.IMG_START, TranslationScheme.IMAGE.start, src, title, id);
                    return true;
                }
                this.fOutput.add(new OutputItem(src));
                return false;
            }
        }
        return false;
    }

    protected boolean _wikilink(Stack<StackItem> stack, boolean eol, Token ... returnOn) {
        if (!this.accept(Token.LINK_START)) {
            return false;
        }
        StringBuilder buffer = new StringBuilder();
        if (this._until(buffer, Token.SEPARATOR, Token.LINK_END, Token.CR, Token.CR_LF, Token.LF)) {
            this.pushOpen(stack, Token.LINK_START);
            String link = buffer.toString().trim();
            IItemReferenceDetector.Reference reference = null;
            if (this.fSettings.contains((Object)Option.REFERENCES) && this.fItemReferenceDetector != null) {
                reference = this.fItemReferenceDetector.detect(link);
            }
            this.fContext = reference;
            String label = buffer.toString();
            if (reference != null && this.fReferenceTransformer != null) {
                this.fReferenceTransformer.transform(reference);
            }
            String string = link = reference != null ? reference.getReference() : link;
            if (this.matches(Token.SEPARATOR)) {
                this.next();
                if (this._formattedInternal(stack, eol, Transformer.merge(returnOn, Token.LINK_END, new Token[0])) && this.accept(Token.LINK_END)) {
                    this.popClose(stack, Token.LINK_START, TranslationScheme.start(Token.LINK_START, link), new Object[0]);
                }
                this.fContext = null;
                return true;
            }
            if (this.matches(Token.LINK_END)) {
                this.fOutput.add(new OutputItem(label));
                this.accept(Token.LINK_END);
                this.popClose(stack, Token.LINK_START, TranslationScheme.start(Token.LINK_START, link), new Object[0]);
                this.fContext = null;
                return true;
            }
            this.fOutput.add(new OutputItem(label));
            this.fContext = null;
            return false;
        }
        return false;
    }

    protected boolean _hline() {
        if (!this.accept(Token.HORIZONTAL_LINE)) {
            return false;
        }
        int last = this.fOutput.size() - 1;
        this.fOutput.get(last).transform(TranslationScheme.HLINE.start, new Object[0]);
        return true;
    }

    protected boolean _xhtml() {
        if (!this.accept(Token.XHTML_START)) {
            return false;
        }
        int index = this.fOutput.size() - 1;
        this.escapeXhtmlChars = false;
        while (!this.matches(Token.XHTML_END, Token.EOF)) {
            this.accept(new Token[0]);
        }
        this.escapeXhtmlChars = true;
        if (this.accept(Token.XHTML_END)) {
            this.fOutput.remove(index);
            this.fOutput.remove(this.fOutput.size() - 1);
            return true;
        }
        return false;
    }

    protected boolean _code() {
        if (!this.accept(Token.CODE_START)) {
            return false;
        }
        int index = this.fOutput.size() - 1;
        while (!this.matches(Token.CODE_END, Token.EOF)) {
            this.accept(new Token[0]);
        }
        if (this.accept(Token.CODE_END)) {
            this.fOutput.get(index).transform(TranslationScheme.CODE.start, new Object[0]);
            int last = this.fOutput.size() - 1;
            this.fOutput.get(last).transform(TranslationScheme.CODE.end, new Object[0]);
            return true;
        }
        return false;
    }

    protected boolean _variable() {
        if (!this.accept(Token.VAR_START)) {
            return false;
        }
        StringBuilder buffer = new StringBuilder();
        if (!this._until(buffer, Token.VAR_END, Token.EOF, Token.CR, Token.CR_LF, Token.LF)) {
            return false;
        }
        if (!this.accept(Token.VAR_END)) {
            this.fOutput.add(new OutputItem(buffer));
            return false;
        }
        String variable = buffer.toString();
        String text = null;
        boolean resolved = false;
        if (!this.fSettings.contains((Object)Option.VARIABLES)) {
            resolved = true;
            text = variable;
        } else if (this.fVariableResolver != null) {
            text = this.fVariableResolver.revolve(this.fContext, variable.toLowerCase().trim());
            boolean bl = resolved = text != null;
        }
        if (!resolved) {
            int last = this.fOutput.size() - 1;
            this.fOutput.add(last, new OutputItem(buffer));
            return true;
        }
        int last = this.fOutput.size() - 1;
        this.fOutput.remove(last);
        this.fOutput.remove(last - 1);
        this.fOutput.add(new OutputItem(text));
        return true;
    }

    protected boolean _line() {
        if (this._characters()) {
            return true;
        }
        if (this.matches(Tokens.EOL) && (this.sneak(LINE_START) || this.starStarColorAllowed && this.sneak(Token.BOLD, Token.COLOR))) {
            this.accept(new Token[0]);
            this._characters();
            return true;
        }
        return false;
    }

    protected boolean _lines() {
        if (!this._line()) {
            return false;
        }
        while (this._line()) {
        }
        return true;
    }

    protected boolean _character() {
        return this.accept(Token.CHARACTER, Token.WHITESPACE, Token.TAB);
    }

    protected boolean _characters() {
        if (!this._character()) {
            return false;
        }
        while (this._character()) {
        }
        return true;
    }

    protected boolean _until(StringBuilder buffer, Token first, Token ... rest) {
        int length = buffer.length();
        while (!(this.matches(first) || this.matches(rest) || this.matches(Token.EOF))) {
            buffer.append(this.fCurrent.getData());
            this.next();
        }
        return length != buffer.length();
    }

    private void next() {
        this.fCurrent = this.fLexer.nextSymbol();
    }

    private boolean sneak(Token ... tokens) {
        Symbol symbol = this.fLexer.nextSymbol();
        boolean matches = symbol.couldBe(tokens) != null;
        this.fLexer.returnSymbol(symbol);
        return matches;
    }

    private boolean matches(Token ... tokens) {
        return this.fCurrent.couldBe(tokens) != null;
    }

    private Token find(Token ... tokens) {
        return this.fCurrent.couldBe(tokens);
    }

    protected boolean accept(Token ... token) {
        if (token.length == 0 || this.fCurrent.couldBe(token) != null) {
            this.addToOutput();
            this.next();
            return true;
        }
        return false;
    }

    private void addToOutput() {
        if (this.matches(Token.EOF)) {
            return;
        }
        if (this.matches(Tokens.EOL)) {
            this.fOutput.add(new OutputItem(Character.valueOf('\n')));
        } else if (this.escapeXhtmlChars && this.matches(Token.ANGLE_OPEN)) {
            this.fOutput.add(new OutputItem("&lt;"));
        } else if (this.escapeXhtmlChars && this.matches(Token.ANGLE_CLOSE)) {
            this.fOutput.add(new OutputItem("&gt;"));
        } else {
            this.fOutput.add(new OutputItem(this.fCurrent.getData()));
        }
    }

    private void pushOpen(Stack<StackItem> stack, Token token) {
        stack.add(new StackItem(token, this.fOutput.size() - 1));
    }

    private void popClose(Stack<StackItem> stack, Token token, String xhtml, Object ... args) {
        if (stack.isEmpty()) {
            throw new IllegalStateException();
        }
        if (stack.peek().token == token) {
            StackItem item = stack.pop();
            this.fOutput.get(item.index).transform(xhtml, args);
            this.fOutput.get(this.fOutput.size() - 1).transform(TranslationScheme.end(token), new Object[0]);
        } else {
            StackItem item = stack.pop();
            this.fOutput.get(item.index).transform(TranslationScheme.start(item.token), new Object[0]);
            int index = -1;
            ListIterator<OutputItem> iter = this.fOutput.listIterator(this.fOutput.size());
            while (iter.hasPrevious()) {
                OutputItem tmp = iter.previous();
                if (!token.wiki.equals(tmp.fOutput)) continue;
                index = iter.previousIndex() + 1;
                break;
            }
            this.fOutput.add(index, new OutputItem(TranslationScheme.end(item.token)));
            this.popClose(stack, token, xhtml, args);
            this.fOutput.add(new OutputItem(item.token.wiki));
            stack.push(new StackItem(item.token, this.fOutput.size() - 1));
        }
    }

    private StackItem findOnStack(Stack<StackItem> stack, Token token) {
        if (stack.isEmpty()) {
            return null;
        }
        ListIterator iter = stack.listIterator(stack.size());
        while (iter.hasPrevious()) {
            StackItem item = (StackItem)iter.previous();
            if (item.token != token) continue;
            return item;
        }
        return null;
    }

    private static Token[] merge(Token[] a, Token first, Token ... rest) {
        int len = a.length + 1 + rest.length;
        Token[] result = new Token[len];
        System.arraycopy(a, 0, result, 0, a.length);
        result[a.length] = first;
        if (rest.length != 0) {
            System.arraycopy(rest, 0, result, a.length + 1, rest.length);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Option {
        REFERENCES,
        VARIABLES;

    }

    private static final class OutputItem {
        private Object fOutput;

        public OutputItem(Object output) {
            this.fOutput = output;
        }

        public void transform(String str, Object ... args) {
            this.fOutput = args.length == 0 ? str : Transformer.format(str, args);
        }
    }

    private static final class StackItem {
        public final Token token;
        public final int index;

        public StackItem(Token token, int index) {
            this.token = token;
            this.index = index;
        }
    }
}

