/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.wiki;

import com.ibm.team.foundation.common.text.XMLString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class WikMarkupCleaner {
    private static final Pattern TAG_PATTERN = Pattern.compile("<\\w+>(.*)</\\w+>");
    private Tidy fTidy;
    private boolean fHeadless;

    public WikMarkupCleaner() {
        this(false);
    }

    public WikMarkupCleaner(boolean headless) {
        this.fHeadless = headless;
        this.fTidy = new Tidy();
        this.fTidy.setCharEncoding(3);
        this.fTidy.setErrout(new PrintWriter(new NullOutputStream()));
        this.fTidy.setQuiet(true);
        this.fTidy.setXHTML(true);
        this.fTidy.setXmlOut(true);
        this.fTidy.setMakeClean(true);
        this.fTidy.setDropEmptyParas(true);
        this.fTidy.setHideEndTags(true);
        this.fTidy.setIndentContent(true);
        this.fTidy.setSmartIndent(true);
        this.fTidy.setTidyMark(false);
        this.fTidy.setEmacs(false);
        this.fTidy.setIndentAttributes(false);
        this.fTidy.setBreakBeforeBR(false);
    }

    public XMLString clean(XMLString markup) {
        if (markup.getXMLText().length() == 0) {
            return markup;
        }
        Document document = this.parse(markup);
        if (document == null && !this.isTagEnclosed(markup)) {
            document = this.parse(XMLString.createFromXMLText((String)("<html>" + markup.getXMLText() + "</html>")));
        }
        if (document == null) {
            return markup;
        }
        Node head = null;
        if (document.getElementsByTagName("head").getLength() > 0) {
            head = document.getElementsByTagName("head").item(0);
        }
        if (!this.fHeadless) {
            if (head != null) {
                NodeList nodes = document.getElementsByTagName("title");
                if (nodes.getLength() > 0) {
                    head.removeChild(nodes.item(0));
                }
                Element metaElement = document.createElement("meta");
                metaElement.setAttribute("name", "com.ibm.team.apt.internal.service.wiki.WikMarkupCleaner");
                metaElement.setAttribute("content", "jazz://com.ibm.team.apt.internal.service.wiki.WikMarkupCleaner?version=1");
                head.appendChild(metaElement);
            }
        } else if (head != null) {
            Node parent = head.getParentNode();
            parent.removeChild(head);
        }
        ByteArrayOutputStream clean = new ByteArrayOutputStream();
        this.fTidy.pprint(document, (OutputStream)clean);
        markup = XMLString.createFromXMLText((String)new String(clean.toByteArray()));
        return markup;
    }

    private Document parse(XMLString markup) {
        return this.fTidy.parseDOM((InputStream)new ByteArrayInputStream(markup.getXMLText().getBytes()), null);
    }

    private boolean isTagEnclosed(XMLString markup) {
        return TAG_PATTERN.matcher(markup.getXMLText()).matches();
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int arg0) throws IOException {
        }
    }
}

