/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.duration;

import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.duration.IProgressItem;
import com.ibm.team.apt.internal.common.duration.PlanDuration;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressHelper {
    private static final ProgressInformation EMPTY_INPUT = new ProgressInformation();
    private IWorkItemHandle fRoot;
    private List<IProgressItem> fItems = new ArrayList<IProgressItem>();

    public ProgressHelper() {
        this(null);
    }

    public ProgressHelper(IWorkItemHandle root) {
        this.fRoot = root;
    }

    public void addItem(IProgressItem item) {
        this.fItems.add(item);
    }

    public void addAllItems(Collection<IProgressItem> items) {
        this.fItems.addAll(items);
    }

    public ProgressInformation computeProgress(long realTimeDone, long realTimeLeft) {
        if (this.fItems.isEmpty()) {
            return EMPTY_INPUT;
        }
        long workHoursDone = 0L;
        long workHoursLeft = 0L;
        int estimated = 0;
        int openCount = 0;
        int closeCount = 0;
        for (IProgressItem item : this.fItems) {
            if (this.fRoot != null && this.fRoot.sameItemId((IItemHandle)item.getWorkItem())) continue;
            PlanDuration planDuration = item.getDuration();
            switch (item.getStateGroup()) {
                case 1: 
                case 4: {
                    ++openCount;
                    if (planDuration.isSpecified() || item.isTopLevelItem()) {
                        ++estimated;
                    }
                    workHoursLeft += planDuration.getDuration();
                    if (planDuration.getTimeSpent() <= 0L) break;
                    workHoursDone += planDuration.getTimeSpent();
                    break;
                }
                case 2: {
                    ++closeCount;
                    workHoursDone += planDuration.getDuration();
                }
            }
        }
        return new ProgressInformation(workHoursDone, workHoursLeft, realTimeDone, realTimeLeft, openCount, closeCount, estimated);
    }
}

