/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

public final class ProgressInformation {
    private long fWorkHoursDone;
    private long fWorkHoursLeft;
    private long fRealTimeDone;
    private long fRealTimeLeft;
    private int fOpenCount;
    private int fCloseCount;
    private int fEstimatedCount;

    public ProgressInformation() {
        this(0L, 0L, 0L, 0L, 0, 0, 0);
    }

    public ProgressInformation(long workHoursDone, long workHoursLeft, long realTimeDone, long realTimeLeft, int openCount, int closeCount, int estimatedCount) {
        this.fWorkHoursDone = workHoursDone;
        this.fWorkHoursLeft = workHoursLeft;
        this.fRealTimeDone = realTimeDone;
        this.fRealTimeLeft = realTimeLeft;
        this.fOpenCount = openCount;
        this.fCloseCount = closeCount;
        this.fEstimatedCount = estimatedCount;
    }

    public void setWorkHoursDone(long workHoursDone) {
        this.fWorkHoursDone = workHoursDone;
    }

    public void setWorkHoursLeft(long workHoursLeft) {
        this.fWorkHoursLeft = workHoursLeft;
    }

    public void setRealTimeDone(long realTimeDone) {
        this.fRealTimeDone = realTimeDone;
    }

    public void setRealTimeLeft(long realTimeLeft) {
        this.fRealTimeLeft = realTimeLeft;
    }

    public void setOpenCount(int openCount) {
        this.fOpenCount = openCount;
    }

    public void setCloseCount(int closeCount) {
        this.fCloseCount = closeCount;
    }

    public void setEstimatedCount(int estimatedCount) {
        this.fEstimatedCount = estimatedCount;
    }

    public long getWorkHoursDone() {
        return this.fWorkHoursDone;
    }

    public long getWorkHoursLeft() {
        return this.fWorkHoursLeft;
    }

    public long getRealTimeDone() {
        return this.fRealTimeDone;
    }

    public long getRealTimeLeft() {
        return this.fRealTimeLeft;
    }

    public int getOpenCount() {
        return this.fOpenCount;
    }

    public int getCloseCount() {
        return this.fCloseCount;
    }

    public int getEstimatedCount() {
        return this.fEstimatedCount;
    }

    public float getQualityOfPlanning() {
        if (this.fOpenCount == 0) {
            return 0.0f;
        }
        return (float)this.fEstimatedCount / (float)this.fOpenCount * 100.0f;
    }

    public void deltaWorkHoursDone(long delta) {
        this.fWorkHoursDone = ProgressInformation.saveDelta(this.fWorkHoursDone, delta);
    }

    public void deltaWorkHoursLeft(long delta) {
        this.fWorkHoursLeft = ProgressInformation.saveDelta(this.fWorkHoursLeft, delta);
    }

    public void deltaRealTimeDone(long delta) {
        this.fRealTimeDone = ProgressInformation.saveDelta(this.fRealTimeDone, delta);
    }

    public void deltaRealTimeLeft(long delta) {
        this.fRealTimeLeft = ProgressInformation.saveDelta(this.fRealTimeLeft, delta);
    }

    public void deltaOpenCount(int delta) {
        this.fOpenCount = ProgressInformation.saveDelta(this.fOpenCount, delta);
    }

    public void deltaCloseCount(int delta) {
        this.fCloseCount = ProgressInformation.saveDelta(this.fCloseCount, delta);
    }

    public void deltaEstimateCount(int delta) {
        this.fEstimatedCount = ProgressInformation.saveDelta(this.fEstimatedCount, delta);
    }

    public void delta(ProgressInformation other, boolean considerRealTime) {
        this.deltaCloseCount(other.getCloseCount());
        this.deltaOpenCount(other.getOpenCount());
        this.deltaWorkHoursDone(other.getWorkHoursDone());
        this.deltaWorkHoursLeft(other.getWorkHoursLeft());
        this.deltaEstimateCount(other.getEstimatedCount());
        if (considerRealTime) {
            this.deltaRealTimeDone(other.getRealTimeDone());
            this.deltaRealTimeLeft(other.getRealTimeLeft());
        }
    }

    private static long saveDelta(long value, long delta) {
        if (delta < 0L) {
            return Math.max(0L, value + delta);
        }
        if (Long.MAX_VALUE - delta < value) {
            return Long.MAX_VALUE;
        }
        return value + delta;
    }

    private static int saveDelta(int value, int delta) {
        if (delta < 0) {
            return Math.max(0, value + delta);
        }
        if (Integer.MAX_VALUE - delta < value) {
            return Integer.MAX_VALUE;
        }
        return value + delta;
    }
}

