/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.internal.common.util.SortMode;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.workitem.common.internal.util.AuditablesHelper;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iterations {
    public static final String PARENT_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"parent");
    public static final String DEVELOPMENT_LINE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"developmentLine");
    public static final String ID_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"id");
    public static final String NAME_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"name");
    public static final String START_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"startDate");
    public static final String END_DATE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"endDate");
    public static final ItemProfile<IIteration> UI_PROFILE = ItemProfile.createProfile((IItemType)IIteration.ITEM_TYPE, (Collection)AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension((Collection)Arrays.asList(NAME_PROPERTY, ID_PROPERTY, START_DATE_PROPERTY, END_DATE_PROPERTY));
    public static final ItemProfile<IIteration> LARGE_PROFILE = ItemProfile.createProfile((IItemType)IIteration.ITEM_TYPE, (Collection)AuditablesHelper.AUDITABLE_SMALL_PROFILE).createExtension((Collection)Arrays.asList(PARENT_PROPERTY, DEVELOPMENT_LINE_PROPERTY, NAME_PROPERTY, ID_PROPERTY, START_DATE_PROPERTY, END_DATE_PROPERTY));
    public static final ItemProfile<IIteration> FULL_PROFILE = ItemProfile.createFullProfile((IItemType)IIteration.ITEM_TYPE);

    public static List<IIteration> sort(Collection<IIteration> intervals) {
        return Iterations.sort(intervals, SortMode.ASC);
    }

    public static List<IIteration> sort(Collection<IIteration> iterations, SortMode mode) {
        ArrayList<IIteration> sorted = new ArrayList<IIteration>();
        for (IIteration iteration : iterations) {
            sorted.add(iteration);
        }
        Iterations.sort(sorted, mode);
        return sorted;
    }

    public static void sort(List<IIteration> intervals, SortMode mode) {
        Collections.sort(intervals, new IterationComparator(mode));
    }

    public static List<IIteration>[] splitByTime(List<? extends IIteration> iterations) {
        ArrayList<IIteration> current = new ArrayList<IIteration>();
        ArrayList<IIteration> past = new ArrayList<IIteration>();
        ArrayList<IIteration> future = new ArrayList<IIteration>();
        long currentTime = System.currentTimeMillis();
        for (IIteration iIteration : iterations) {
            Date endDate = iIteration.getEndDate();
            Date startDate = iIteration.getStartDate();
            if (endDate == null || startDate == null || endDate.getTime() < currentTime) {
                past.add(iIteration);
                continue;
            }
            if (startDate.getTime() > currentTime) {
                future.add(iIteration);
                continue;
            }
            current.add(iIteration);
        }
        Iterations.sort(current, SortMode.ASC);
        Iterations.sort(past, SortMode.DESC);
        Iterations.sort(future, SortMode.ASC);
        return new List[]{past, current, future};
    }

    public static boolean hasDates(IIteration iteration) {
        return iteration.getStartDate() != null && iteration.getEndDate() != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IterationComparator
    implements Comparator<IIteration> {
        private final SortMode fMode;

        private IterationComparator(SortMode mode) {
            this.fMode = mode;
        }

        @Override
        public int compare(IIteration o1, IIteration o2) {
            boolean noDate2;
            boolean isAscending;
            if (o1 == o2) {
                return 0;
            }
            boolean bl = isAscending = this.fMode == SortMode.ASC;
            if (o1 == null) {
                return isAscending ? -1 : 1;
            }
            if (o2 == null) {
                return isAscending ? 1 : -1;
            }
            boolean noDate1 = o1.getStartDate() == null || o1.getEndDate() == null;
            boolean bl2 = noDate2 = o2.getStartDate() == null || o2.getEndDate() == null;
            if (noDate1 && noDate2) {
                return 0;
            }
            if (noDate1) {
                return isAscending ? -1 : 1;
            }
            if (noDate2) {
                return isAscending ? 1 : -1;
            }
            if (o1.getEndDate().getTime() <= o2.getStartDate().getTime()) {
                return isAscending ? -1 : 1;
            }
            if (o1.getStartDate().getTime() >= o2.getEndDate().getTime()) {
                return isAscending ? 1 : -1;
            }
            return 0;
        }
    }
}

