/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFUtils {
    public static void assign(EObject to, EObject from, String ... excludes) {
        Assert.isTrue((to.eClass() == from.eClass() ? 1 : 0) != 0);
        EMFUtils.assign(to, from, from.eClass(), EMFUtils.computeExcludeList(from, excludes));
    }

    public static void assign(EObject to, EObject from, EClass features, String ... excludes) {
        Assert.isTrue((to.eClass() == from.eClass() ? 1 : 0) != 0);
        EMFUtils.assign(to, from, features, EMFUtils.computeExcludeList(from, excludes));
    }

    private static List<EStructuralFeature> computeExcludeList(EObject from, String ... excludes) {
        if (excludes == null) {
            return null;
        }
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        String[] stringArray = excludes;
        int n = excludes.length;
        int n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            EStructuralFeature feature = from.eClass().getEStructuralFeature(exclude);
            if (feature != null) {
                result.add(feature);
            }
            ++n2;
        }
        return result;
    }

    private static void assign(EObject to, EObject from, EClass features, List<EStructuralFeature> excludeList) {
        Assert.isTrue((to.eClass() == from.eClass() ? 1 : 0) != 0);
        for (EStructuralFeature feature : features.getEAllStructuralFeatures()) {
            boolean isSet;
            if (excludeList != null && excludeList.contains(feature) || !(isSet = from.eIsSet(feature))) continue;
            to.eSet(feature, from.eGet(feature));
        }
    }
}

