/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.util;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.IterationHierarchy;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationClient {
    private static IterationHierarchy.ItemAccessHelper fgItemAccessHelper = new IterationHierarchy.ItemAccessHelper(){

        public IItem fetchCompleteItem(IItemHandle itemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
            return PlanningClientPlugin.getTeamRepository(itemHandle).itemManager().fetchCompleteItem(itemHandle, 0, monitor);
        }

        public IItem[] fetchCompleteItems(IItemHandle[] itemHandles, IProgressMonitor monitor) throws TeamRepositoryException {
            if (itemHandles.length == 0) {
                return new IItem[0];
            }
            IItemManager itemManager = PlanningClientPlugin.getTeamRepository(itemHandles[0]).itemManager();
            List items = itemManager.fetchCompleteItems(Arrays.asList(itemHandles), 0, monitor);
            return items.toArray(new IItem[items.size()]);
        }

        public IIteration[] getCurrentIterations(IDevelopmentLineHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
            return PlanningClientPlugin.getProcessItemService((IItemHandle)handle).getCurrentIterations(handle, monitor);
        }
    };

    public static IterationHierarchy fetchIterationHierarchy(IDevelopmentLineHandle devLineHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return IterationHierarchy.create((IDevelopmentLineHandle)devLineHandle, (IterationHierarchy.ItemAccessHelper)fgItemAccessHelper, (IProgressMonitor)monitor);
    }

    public static IIteration getCurrentPlanLeafIteration(IDevelopmentLineHandle devLineHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService pis = PlanningClientPlugin.getProcessItemService((IItemHandle)devLineHandle);
        IIteration[] ci = pis.getCurrentIterations(devLineHandle, monitor);
        int i = ci.length - 1;
        while (i >= 0) {
            if (ci[i].hasDeliverable() && !ci[i].isArchived()) {
                return ci[i];
            }
            --i;
        }
        return null;
    }

    public static ItemList<IIteration> getAllIterations(IDevelopmentLineHandle devLineHandle, ArchiveMode archiveMode, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)devLineHandle);
        Assert.isNotNull((Object)((Object)archiveMode));
        ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)devLineHandle);
        IItemManager manager = repository.itemManager();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 3);
        ItemArrayList result = new ItemArrayList();
        IDevelopmentLine line = (IDevelopmentLine)manager.fetchCompleteItem((IItemHandle)devLineHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        IIterationHandle[] handles = line.getIterations();
        List iterations = manager.fetchCompleteItems(Arrays.asList(handles), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
        sub.beginTask("", iterations.size());
        for (IIteration iteration : iterations) {
            result.add((Object)iteration);
            List children = manager.fetchCompleteItems(Arrays.asList(iteration.getChildren()), 0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)sub, 1));
            if (ArchiveMode.BOTH == archiveMode) {
                result.addAll((Collection)children);
                continue;
            }
            boolean archived = archiveMode == ArchiveMode.ARCHIVED;
            for (IIteration child : children) {
                if (child.isArchived() != archived) continue;
                result.add((Object)child);
            }
        }
        sub.done();
        monitor.done();
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArchiveMode {
        ARCHIVED,
        IN_USE,
        BOTH;

    }
}

