/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.problems;

import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.problems.Messages;
import com.ibm.team.apt.internal.client.problems.PlanItemCheck;
import com.ibm.team.apt.internal.client.problems.PlanItemProblemReport;
import com.ibm.team.apt.internal.client.problems.PlanProblemReport;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.apt.internal.client.problems.SchedulingProblem;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchedulingCheck
extends PlanItemCheck {
    @Override
    public Collection<PlanItem> computeItemsToCheck(PlanItem item, IPlanElementDelta delta) {
        return Collections.singletonList(item);
    }

    @Override
    public void run(PlanProblemReport report, Collection<? extends PlanItem> planItems, IProgressMonitor monitor) throws TeamRepositoryException {
        if (planItems.isEmpty()) {
            return;
        }
        ResolvedPlan plan = report.getPlan();
        this.checkCanceled(monitor);
        monitor.beginTask("", planItems.size());
        for (PlanItem planItem : planItems) {
            this.checkCanceled(monitor);
            if (!planItem.isConnected() || planItem.isResolved() || planItem.isAuxiliaryPlanItem()) continue;
            PlanItemProblemReport planItemReport = report.createReport(planItem);
            monitor.setTaskName(NLS.bind((String)Messages.SchedulingCheck_MONITOR_CHECK_WORK_ITEM, (Object[])new Object[]{String.valueOf(planItem.getId())}));
            Timespan scheduledTime = planItem.getScheduledTime();
            if (scheduledTime != null) {
                Date planEnd;
                IIteration target;
                Timestamp dueDate;
                if (!planItem.getDuration().isSpecified()) {
                    String message = MessageFormat.format(Messages.SchedulingCheck_PLANED_BUT_NO_ESTIMATE, new Object[0]);
                    planItemReport.addProblem(new SchedulingProblem(Problem.Severity.WARNING, 9, message, planItem, SchedulingCheck.class));
                }
                if ((dueDate = planItem.getDueDate()) != null) {
                    String message;
                    if (this.before(dueDate, plan.getReferenceTime())) {
                        message = MessageFormat.format(Messages.SchedulingCheck_HAS_DUE_DATE, dueDate);
                        planItemReport.addProblem(new SchedulingProblem(Problem.Severity.WARNING, 8, message, planItem, SchedulingCheck.class));
                    } else if (this.before(dueDate, scheduledTime.getEnd())) {
                        message = MessageFormat.format(Messages.SchedulingCheck_IS_DUE_ON, dueDate, scheduledTime.getEnd());
                        planItemReport.addProblem(new SchedulingProblem(Problem.Severity.WARNING, 3, message, planItem, SchedulingCheck.class));
                    }
                }
                if ((target = planItem.getTarget()) != null && (planEnd = target.getEndDate()) != null && this.before(planEnd, scheduledTime.getEnd())) {
                    String message = MessageFormat.format(Messages.SchedulingCheck_COMPLETED_AFTER_ITERATION_END, scheduledTime.getEnd(), planEnd);
                    planItemReport.addProblem(new SchedulingProblem(Problem.Severity.WARNING, 4, message, planItem, SchedulingCheck.class));
                }
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private List<PlanItem> findBadReferences(ResolvedPlan plan, Timespan scheduledTime, List<IReference> references, boolean findReferencesBeforeScheduledTime) {
        ArrayList<PlanItem> result = new ArrayList<PlanItem>();
        for (IReference reference : references) {
            Timespan otherScheduledTime;
            PlanItem otherItem;
            IItemHandle referencedItem = ((IItemReference)reference).getReferencedItem();
            if (!(referencedItem instanceof IWorkItemHandle) || (otherItem = plan.getPlanItem((IWorkItemHandle)referencedItem)) == null || (otherScheduledTime = otherItem.getScheduledTime()) == null || (!findReferencesBeforeScheduledTime || !this.before(otherScheduledTime.getStart(), scheduledTime.getEnd())) && (findReferencesBeforeScheduledTime || !this.before(scheduledTime.getStart(), otherScheduledTime.getEnd()))) continue;
            result.add(otherItem);
        }
        return result;
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private boolean before(Date t1, Date t2) {
        return this.trimToDay(t1).before(this.trimToDay(t2));
    }

    private Calendar trimToDay(Date t) {
        Calendar c = Calendar.getInstance();
        c.setTime(t);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c;
    }
}

