/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.problems;

import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.problems.AttributeProblem;
import com.ibm.team.apt.internal.client.problems.Messages;
import com.ibm.team.apt.internal.client.problems.PlanCheck;
import com.ibm.team.apt.internal.client.problems.PlanItemCheck;
import com.ibm.team.apt.internal.client.problems.PlanItemProblemReport;
import com.ibm.team.apt.internal.client.problems.PlanProblemReport;
import com.ibm.team.apt.internal.client.problems.Problem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.IPriority;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityMismatchCheck
extends PlanItemCheck {
    @Override
    public Collection<PlanItem> computeItemsToCheck(PlanItem item, IPlanElementDelta delta) {
        if (delta.isChanged() && delta.getAttributeDelta(PlanItem.PRIORITY) != null) {
            return Collections.singletonList(item);
        }
        if (delta.isAdded()) {
            if (delta.isMoveChange() && delta.getMovedFrom() instanceof PlanItem) {
                ArrayList<PlanItem> result = new ArrayList<PlanItem>(2);
                result.add(item);
                result.add((PlanItem)delta.getMovedFrom());
            } else {
                return Collections.singletonList(item);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void run(PlanProblemReport report, Collection<? extends PlanItem> planItems, IProgressMonitor monitor) throws TeamRepositoryException {
        for (PlanItem planItem : planItems) {
            PlanElement[] children;
            PlanItem parentItem;
            if (!planItem.isConnected()) continue;
            IPriority priority = planItem.getPriority();
            PlanElement parent = planItem.getParent();
            if (parent instanceof PlanItem && (parentItem = (PlanItem)parent).isGroupItem() && priority.compareTo(parentItem.getPriority()) <= -1) {
                PlanItemProblemReport planItemReport = report.createReport(planItem);
                planItemReport.addProblem(new AttributeProblem(Problem.Severity.WARNING, 2, NLS.bind((String)Messages.PriorityMismatchCheck_LOWER_PRIORITY_THAN_PARENT, (Object[])new Object[]{parentItem.getHTMLSummary().getPlainText()}), planItem, PlanItem.PRIORITY, PriorityMismatchCheck.class));
                break;
            }
            if (!planItem.isGroupItem()) continue;
            PlanElement[] planElementArray = children = planItem.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                PlanElement child = planElementArray[n2];
                if (child instanceof PlanItem) {
                    PlanItem childItem = (PlanItem)child;
                    PlanItemProblemReport childItemReport = report.createReport(childItem);
                    childItemReport.clearProblems((Class<? extends PlanCheck>)PriorityMismatchCheck.class);
                    if (priority.compareTo(childItem.getPriority()) >= 1) {
                        childItemReport.addProblem(new AttributeProblem(Problem.Severity.WARNING, 2, NLS.bind((String)Messages.PriorityMismatchCheck_LOWER_PRIORITY_THAN_PARENT, (Object[])new Object[]{planItem.getHTMLSummary().getPlainText()}), childItem, PlanItem.PRIORITY, PriorityMismatchCheck.class));
                    }
                }
                ++n2;
            }
        }
    }
}

