/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client.nodes;

import com.ibm.team.apt.internal.client.Attribute;
import com.ibm.team.apt.internal.client.nodes.AttributeDelta;
import com.ibm.team.apt.internal.client.nodes.ElementNode;
import com.ibm.team.apt.internal.client.nodes.ElementNodeDelta;
import com.ibm.team.apt.internal.client.nodes.ElementNodeDeltaFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementNodeDeltaBuilder<T extends ElementNode<T>, D extends ElementNodeDelta<T, D>, R extends T, E> {
    private ElementNodeDeltaFactory<T, D, E> fFactory;
    private R fPlanRoot;
    private D fDeltaRoot;
    private T fOldParent;
    private T fNewParent;
    private List<Runnable> fPostRunnables;

    public ElementNodeDeltaBuilder(ElementNodeDeltaFactory<T, D, E> factory, R root) {
        this.fFactory = factory;
        this.fPlanRoot = root;
        this.fDeltaRoot = this.fFactory.createDelta(null, this.fPlanRoot);
        this.fPostRunnables = new ArrayList<Runnable>();
    }

    public synchronized boolean isEmpty() {
        return ((ElementNodeDelta)this.fDeltaRoot).isNoChange() && !((ElementNodeDelta)this.fDeltaRoot).hasChildren();
    }

    public synchronized E getEvent() {
        return this.fFactory.createEvent(this.fDeltaRoot);
    }

    public void sendPostNotifications() {
        for (Runnable runnable : this.fPostRunnables) {
            runnable.run();
        }
    }

    public synchronized void addPostNotification(Runnable runnable) {
        Assert.isNotNull((Object)runnable);
        this.fPostRunnables.add(runnable);
    }

    public synchronized boolean isInMove() {
        return this.fOldParent != null && this.fNewParent != null;
    }

    public synchronized void aboutToMove(T oldParent, T newParent) {
        Assert.isNotNull(oldParent);
        Assert.isNotNull(newParent);
        this.fOldParent = oldParent;
        this.fNewParent = newParent;
        if (this.fNewParent != null) {
            int childrenCount = ((ElementNode)this.fNewParent).getChildrenCount();
            this.changed(this.fNewParent, ElementNode.CHILDREN_COUNT, childrenCount, childrenCount + 1);
            if (childrenCount == 0) {
                this.changed(this.fNewParent, ElementNode.CHILDREN, Boolean.FALSE, Boolean.TRUE);
            }
        }
    }

    public synchronized void moved() {
        if (this.fOldParent != null) {
            int childrenCount = ((ElementNode)this.fOldParent).getChildrenCount();
            this.changed(this.fOldParent, ElementNode.CHILDREN_COUNT, childrenCount + 1, childrenCount);
            if (childrenCount == 0) {
                this.changed(this.fOldParent, ElementNode.CHILDREN, Boolean.TRUE, Boolean.FALSE);
            }
        }
        this.fOldParent = null;
        this.fNewParent = null;
    }

    public synchronized void changed(T element, Attribute attribute, Object oldValue, Object newValue) {
        D delta = this.getDelta(element);
        if (((ElementNodeDelta)delta).isNoChange()) {
            ((ElementNodeDelta)delta).setChanged();
        }
        ((ElementNodeDelta)delta).setContentChange();
        ((ElementNodeDelta)delta).addAttribute(new AttributeDelta(attribute, oldValue, newValue));
    }

    public synchronized void added(T element) {
        Object parent = ((ElementNode)element).getParent();
        Assert.isNotNull(parent);
        D parentDelta = this.getDelta(parent);
        if (((ElementNodeDelta)parentDelta).isNoChange()) {
            ((ElementNodeDelta)parentDelta).setChanged();
        }
        ((ElementNodeDelta)parentDelta).setStructuralChange();
        D delta = this.getDelta(element);
        ((ElementNodeDelta)delta).setAdded();
        if (this.fOldParent != null) {
            ((ElementNodeDelta)delta).setMoveParent(this.fOldParent);
            ((ElementNodeDelta)delta).setOtherMoveDelta(this.getDelta(this.getPath(this.fOldParent, element)));
        }
    }

    public synchronized void removed(T element) {
        Object parent = ((ElementNode)element).getParent();
        Assert.isNotNull(parent);
        D parentDelta = this.getDelta(parent);
        if (((ElementNodeDelta)parentDelta).isNoChange()) {
            ((ElementNodeDelta)parentDelta).setChanged();
        }
        ((ElementNodeDelta)parentDelta).setStructuralChange();
        D delta = this.getDelta(element);
        ((ElementNodeDelta)delta).setRemoved();
        if (this.fNewParent != null) {
            ((ElementNodeDelta)delta).setMoveParent(this.fNewParent);
            ((ElementNodeDelta)delta).setOtherMoveDelta(this.getDelta(this.getPath(this.fNewParent, element)));
        } else {
            List children = ((ElementNode)element).getChildren();
            for (ElementNode child : children) {
                this.removed(child);
            }
        }
    }

    private D getDelta(T element) {
        return this.getDelta(this.getPath(element, null));
    }

    private D getDelta(List<T> path) {
        if (path.size() == 1) {
            return this.fDeltaRoot;
        }
        Object current = this.fDeltaRoot;
        int i = path.size() - 2;
        while (i >= 0) {
            Object child = ((ElementNodeDelta)current).getChild((ElementNode)((ElementNode)path.get(i)));
            if (child == null) {
                child = this.fFactory.createDelta(current, (ElementNode)path.get(i));
                ((ElementNodeDelta)current).addChild(child);
            }
            current = child;
            --i;
        }
        return current;
    }

    private List<T> getPath(T element, T child) {
        ArrayList result = new ArrayList();
        if (child != null) {
            result.add(child);
        }
        result.add(element);
        Object parent = ((ElementNode)element).getParent();
        while (parent != null) {
            result.add(parent);
            parent = ((ElementNode)parent).getParent();
        }
        return result;
    }
}

