/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.common.resource.IContributorAbsenceHandle;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.SequenceValue;
import com.ibm.team.apt.internal.client.problems.ProblemReport;
import com.ibm.team.apt.internal.common.BookedTimeType;
import com.ibm.team.apt.internal.common.IBookedTime;
import com.ibm.team.apt.internal.common.Timespan;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.IContributor;
import java.util.Date;

public class OutOfOfficeItem
extends PlanElement
implements IScheduleItem,
IBookedTime {
    private IContributorAbsence fAbsence;
    private final ResolvedPlan fPlan;
    private final ItemSequenceManager fItemSequenceManager;

    public OutOfOfficeItem(ResolvedPlan plan, IContributorAbsence absence, ItemSequenceManager itemSequenceManager) {
        this.fPlan = plan;
        this.fAbsence = absence;
        this.fItemSequenceManager = itemSequenceManager;
    }

    public IContributorAbsenceHandle getAbsenceHandle() {
        return (IContributorAbsenceHandle)this.fAbsence.getItemHandle();
    }

    public Date getStart() {
        return this.fAbsence.getStartDate();
    }

    public Date getFixedStartDate() {
        return this.getStart();
    }

    public Date getEnd() {
        return this.fAbsence.getEndDate();
    }

    public BookedTimeType getType() {
        return BookedTimeType.OUT_OF_OFFICE;
    }

    public String getSummary() {
        return this.fAbsence.getSummary();
    }

    public XMLString getHTMLSummary() {
        return XMLString.createFromXMLText((String)this.fAbsence.getSummary());
    }

    public void setSummary(String summary) {
        throw new UnsupportedOperationException();
    }

    public void setHTMLSummary(XMLString summary) {
        throw new UnsupportedOperationException();
    }

    public IContributor getOwner() {
        return this.fPlan.getResolvedContributor(this.fAbsence.getContributor());
    }

    public ItemSequenceManager getSequenceManager() {
        return this.fItemSequenceManager;
    }

    public SequenceValue getSequenceValue() {
        return SequenceValue.ACCEPTED;
    }

    public Timespan getScheduledTime() {
        return this.fItemSequenceManager.getScheduledTime(this);
    }

    public boolean isOpen() {
        return this.fPlan.getReferenceTime().before(this.fAbsence.getStartDate());
    }

    public boolean isInProgress() {
        return !this.isOpen() && !this.isResolved();
    }

    public boolean isResolved() {
        return !this.fAbsence.getEndDate().after(this.fPlan.getReferenceTime());
    }

    public boolean isDirty() {
        return false;
    }

    public ResolvedPlan getPlan() {
        return this.fPlan;
    }

    public ProblemReport getProblemReport() {
        return null;
    }

    public PlanElement getParent() {
        return null;
    }

    public void moveTo(PlanElement newParent) {
        throw new UnsupportedOperationException();
    }

    public void addChild(PlanElement element) {
        throw new UnsupportedOperationException();
    }

    protected void doChildAdded(PlanElement parent, PlanElement child) {
        throw new UnsupportedOperationException();
    }

    protected void doChildRemoved(PlanElement parent, PlanElement child) {
        throw new UnsupportedOperationException();
    }
}

