/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.client;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.ICorePlanItemFilter;
import com.ibm.team.apt.internal.client.IItemResolveService;
import com.ibm.team.apt.internal.client.IPlanAttributeDelta;
import com.ibm.team.apt.internal.client.IPlanElementChangeEvent;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementListener;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanDataListener;
import com.ibm.team.apt.internal.client.IterationPlanSaveResult;
import com.ibm.team.apt.internal.client.Messages;
import com.ibm.team.apt.internal.client.PlanSaveResult;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.client.wiki.IWikiPageSafeRunnable;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPage;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAdapter;
import com.ibm.team.apt.internal.client.wiki.WikiClient;
import com.ibm.team.apt.internal.client.wiki.WikiManager;
import com.ibm.team.apt.internal.common.ProgressInformation;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.wiki.IWikiPage;
import com.ibm.team.apt.internal.common.wiki.IWikiPageHandle;
import com.ibm.team.apt.internal.common.wiki.model.WikiPage;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IReconcileReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.ICategory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationPlanData {
    public static final String OVERVIEW_PAGE_ID = "overview";
    public static final String OVERVIEW_PAGE_NAME = Messages.IterationPlanData_OVERVIEW_PAGE_NAME;
    private IIterationPlanRecord fRecord;
    private final IDevelopmentLine fDevelopmentLine;
    private final IProjectArea fProjectArea;
    private final ITeamArea fTeamArea;
    private final IIteration fIteration;
    private final ItemList<ICategory> fCategories;
    private final ItemList<IIteration> fRelatedIterations;
    private final ProgressInformation fProgress;
    private final boolean fCanSave;
    private final boolean fCanSavePages;
    private final boolean fShowChartPage;
    private ResolvedIterationPlan fPlan;
    private IPlanElementListener fPlanListener;
    private ICorePlanItemFilter[] fFilters;
    private IItemResolveService fItemResolveService;
    private ListenerList fPlanListeners;
    private final ItemList<IWikiPage> fWikiPages;
    private final List<ResolvedWikiPage> fResolvedWikiPages;
    private final ListenerList fListeners;

    public IterationPlanData(IIterationPlanRecord record, IDevelopmentLine developmentLine, IProjectArea projectArea, ITeamArea teamArea, IIteration interval, ItemList<ICategory> categories, ItemList<IIteration> relatedIntervals, ProgressInformation progressDescription, ItemList<IWikiPage> wikiPages, boolean canSave, boolean canSavePages, boolean showChartPage) {
        this.fRecord = record;
        this.fDevelopmentLine = developmentLine;
        this.fProjectArea = projectArea;
        this.fTeamArea = teamArea;
        this.fIteration = interval;
        this.fCategories = categories;
        this.fRelatedIterations = relatedIntervals;
        this.fProgress = progressDescription;
        this.fWikiPages = wikiPages;
        this.fResolvedWikiPages = new ArrayList<ResolvedWikiPage>(this.fWikiPages.size());
        this.fCanSave = canSave;
        this.fCanSavePages = canSavePages;
        this.fShowChartPage = showChartPage;
        this.fPlanListeners = new ListenerList(1);
        this.fListeners = new ListenerList(1);
        this.fPlanListener = new IPlanElementListener(){

            public void planElementChanged(IPlanElementChangeEvent event) {
                IPlanAttributeDelta dirtyDelta;
                IPlanElementDelta delta = event.getDelta();
                if (delta.getPlanElement() == IterationPlanData.this.fPlan && (dirtyDelta = delta.getAttributeDelta(ResolvedPlan.DIRTY)) != null) {
                    boolean oldDirty;
                    boolean bl = oldDirty = IterationPlanData.this.isWikiPageDirty(null) || (Boolean)dirtyDelta.getOldValue() != false;
                    if (oldDirty != (Boolean)dirtyDelta.getNewValue()) {
                        IterationPlanData.this.fireDirtyStateChanged(oldDirty, !oldDirty);
                    }
                }
            }
        };
    }

    public boolean waitForDisconnect(IProgressMonitor monitor) {
        try {
            boolean bl = this.fPlan != null ? this.fPlan.waitForDisconnect(monitor) : true;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized void disconnect() {
        if (this.fPlan != null) {
            if (this.fPlanListener != null) {
                this.fPlan.removeListener(this.fPlanListener);
            }
            this.fPlan.disconnect();
        }
    }

    public ITeamRepository getTeamRepository() {
        return PlanningClientPlugin.getTeamRepository((IItemHandle)this.fRecord);
    }

    public IIterationPlanRecord getPlanRecord() {
        return this.fRecord;
    }

    public String getName() {
        return this.fRecord.getName();
    }

    public IDevelopmentLine getDevelopmentLine() {
        return this.fDevelopmentLine;
    }

    public IProjectArea getProjectArea() {
        return this.fProjectArea;
    }

    public ITeamArea getTeamArea() {
        return this.fTeamArea;
    }

    public IIteration getIteration() {
        return this.fIteration;
    }

    public ItemList<IIteration> getRelatedIterations() {
        return this.fRelatedIterations;
    }

    public ItemList<IIteration> getFutureIterations() {
        if (this.fRelatedIterations.isEmpty()) {
            return ItemCollections.emptyList();
        }
        ItemArrayList result = new ItemArrayList(this.fRelatedIterations);
        result.remove((Object)this.fIteration);
        return result;
    }

    public ItemList<ICategory> getCategories() {
        return this.fCategories;
    }

    public ProgressInformation getProgress() {
        return this.fProgress;
    }

    public boolean canSavePlan() {
        return this.fCanSave;
    }

    public boolean canSavePages() {
        return this.fCanSavePages;
    }

    public boolean showChartPage() {
        return this.fShowChartPage;
    }

    public synchronized boolean isDirty() {
        boolean result = false;
        if (this.fPlan != null) {
            result = this.fPlan.isDirty();
        }
        for (ResolvedWikiPage page : this.fResolvedWikiPages) {
            boolean bl = result = result || page.isDirty();
            if (!result) continue;
            return result;
        }
        return result;
    }

    public synchronized boolean isPlanDirty() {
        if (this.fPlan != null) {
            return this.fPlan.isDirty();
        }
        return false;
    }

    public synchronized boolean isWikiPageDirty(ResolvedWikiPage exclude) {
        boolean result = false;
        for (ResolvedWikiPage page : this.fResolvedWikiPages) {
            if (page == exclude) continue;
            boolean bl = result = result || page.isDirty();
            if (!result) continue;
            return result;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlanSaveResult save(IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        try {
            monitor.beginTask(Messages.IterationPlanData_MONITOR_SAVING_PLAN, this.fResolvedWikiPages.size() + 1);
            WikiManager wikiManager = WikiClient.getWikiManager(this.getTeamRepository());
            ArrayList<IWikiPageSafeRunnable> pagesToSave = new ArrayList<IWikiPageSafeRunnable>(this.fResolvedWikiPages.size());
            for (ResolvedWikiPage page : this.fResolvedWikiPages) {
                if (!page.isDirty()) continue;
                pagesToSave.add(wikiManager.createWikiPageSafeRunnable(page, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            }
            IWikiPageSafeRunnable[] wikiSafeRunnables = pagesToSave.toArray(new IWikiPageSafeRunnable[pagesToSave.size()]);
            ResolvedIterationPlan plan = null;
            IterationPlanData iterationPlanData = this;
            synchronized (iterationPlanData) {
                plan = this.fPlan;
            }
            if (plan != null) {
                PlanSaveResult planSaveResult = this.fPlan.save(wikiSafeRunnables, monitor);
                return planSaveResult;
            }
            IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient(this.getTeamRepository());
            IterationPlanSaveResult iterationPlanSaveResult = client.save(this.canSavePlan(), this.getPlanRecord(), null, new WorkItemWorkingCopy[0], null, wikiSafeRunnables, monitor);
            return iterationPlanSaveResult;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized ItemList<IWikiPage> getWikiPages() {
        return ItemCollections.unmodifiableItemList(this.fWikiPages);
    }

    public synchronized void addResolvedWikiPage(final ResolvedWikiPage page) {
        this.fResolvedWikiPages.add(page);
        if (!this.fWikiPages.contains((Object)page.getWikiPage().getItemHandle())) {
            this.fWikiPages.add((Object)page.getWikiPage());
        }
        page.addListener(new ResolvedWikiPageAdapter(){

            public void dirtyStateChanged(boolean oldValue, boolean newValue) {
                boolean oldDirty;
                boolean bl = oldDirty = IterationPlanData.this.isPlanDirty() || IterationPlanData.this.isWikiPageDirty(page);
                if (oldDirty != newValue) {
                    IterationPlanData.this.fireDirtyStateChanged(oldValue, newValue);
                }
            }
        });
    }

    public void deleteAttachedPage(IWikiPage page, IProgressMonitor monitor) throws TeamRepositoryException {
        IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)page);
        client.deleteAttachedPage((IWikiPageHandle)page, monitor);
        Iterator iter = this.fWikiPages.iterator();
        while (iter.hasNext()) {
            IWikiPage attachedPage = (IWikiPage)iter.next();
            if (!attachedPage.sameItemId((IItemHandle)page)) continue;
            iter.remove();
        }
        Iterator<ResolvedWikiPage> iterResolved = this.fResolvedWikiPages.iterator();
        while (iterResolved.hasNext()) {
            IWikiPage resolvedPage = iterResolved.next().getWikiPage();
            if (!resolvedPage.sameItemId((IItemHandle)page)) continue;
            iterResolved.remove();
        }
    }

    public void renameAttachedPage(ResolvedWikiPage page, String name, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        this.fWikiPages.remove((Object)page.getWikiPage());
        IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)page.getWikiPage());
        IWikiPageSafeRunnable runnable = WikiClient.getWikiManager((IItem)page.getWikiPage()).createWikiPageSafeRunnable(page, true, monitor);
        client.renameAttachedPage(this.getPlanRecord(), runnable, name, monitor);
        this.fWikiPages.add((Object)runnable.getWikiPage());
    }

    public void upgradeAttachedPage(ResolvedWikiPage resolvedPage, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IWikiPage page = resolvedPage.getWikiPage();
        IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)page);
        IWikiPageSafeRunnable safeRunnable = WikiClient.getWikiManager((IItem)page).createWikiPageSafeRunnable(resolvedPage, false, monitor);
        ((WikiPage)safeRunnable.getWikiPage()).setVersion("2.0");
        client.save(this.canSavePlan(), this.getPlanRecord(), null, new WorkItemWorkingCopy[0], null, new IWikiPageSafeRunnable[]{safeRunnable}, monitor);
        this.fWikiPages.remove((Object)page);
        this.fWikiPages.add((Object)safeRunnable.getWikiPage());
    }

    public synchronized ResolvedIterationPlan getIterationPlan() {
        return this.fPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIterationPlan(ResolvedIterationPlan plan) {
        IterationPlanData iterationPlanData = this;
        synchronized (iterationPlanData) {
            Object listener;
            int n;
            int n2;
            Object[] objectArray;
            Object[] listeners;
            if (this.fPlan != null) {
                this.fPlan.setItemResolveService(null);
                objectArray = listeners = this.fPlanListeners.getListeners();
                n2 = listeners.length;
                n = 0;
                while (n < n2) {
                    listener = objectArray[n];
                    this.fPlan.removeListener((IPlanElementListener)listener);
                    ++n;
                }
                this.fPlan.removeListener(this.fPlanListener);
            }
            this.fPlan = plan;
            if (this.fPlan != null) {
                if (this.fFilters != null) {
                    this.fPlan.setCoreElementCriteria(this.fFilters);
                }
                if (this.fItemResolveService != null) {
                    this.fPlan.setItemResolveService(this.fItemResolveService);
                }
                objectArray = listeners = this.fPlanListeners.getListeners();
                n2 = listeners.length;
                n = 0;
                while (n < n2) {
                    listener = objectArray[n];
                    this.fPlan.addListener((IPlanElementListener)listener);
                    ++n;
                }
                this.fPlan.addListener(this.fPlanListener);
                this.fireIterationPlanResolved(plan);
            }
        }
    }

    public synchronized void setCoreElementCriteria(ICorePlanItemFilter[] filters) {
        this.fFilters = filters;
        if (this.fPlan != null) {
            this.fPlan.setCoreElementCriteria(filters);
        }
    }

    public synchronized void setItemResolveService(IItemResolveService itemResolveService) {
        this.fItemResolveService = itemResolveService;
        if (this.fPlan != null) {
            this.fPlan.setItemResolveService(itemResolveService);
        }
    }

    public synchronized void addPlanListener(IPlanElementListener listener) {
        this.fPlanListeners.add((Object)listener);
        if (this.fPlan != null) {
            this.fPlan.addListener(listener);
        }
    }

    public synchronized void removePlanListener(IPlanElementListener listener) {
        this.fPlanListeners.remove((Object)listener);
        if (this.fPlan != null) {
            this.fPlan.removeListener(listener);
        }
    }

    public synchronized void autoMerge(IReconcileReport[] reports) {
        if (this.fPlan != null) {
            this.fPlan.autoMerge(reports);
        }
    }

    public synchronized void revert(IReconcileReport[] reports) {
        if (this.fPlan != null) {
            this.fPlan.revert(reports);
        }
    }

    public synchronized void refresh(IReconcileReport[] reports) {
        if (this.fPlan != null) {
            this.fPlan.refresh(reports);
        }
    }

    public synchronized void overwriteRecord(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fPlan != null) {
            this.fRecord = this.fPlan.overwriteRecord(monitor);
        }
    }

    public void addListener(IterationPlanDataListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IterationPlanDataListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void fireIterationPlanResolved(ResolvedIterationPlan plan) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IterationPlanDataListener)listener).iterationPlanResolved(plan);
            ++n2;
        }
    }

    private void fireDirtyStateChanged(boolean oldValue, boolean newValue) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IterationPlanDataListener)listener).dirtyStateChanged(oldValue, newValue);
            ++n2;
        }
    }
}

