/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rdm.ba.resource;

import com.ibm.rdm.ba.resource.IAutonameHelper;
import com.ibm.rdm.base.BasePackage;
import com.ibm.rdm.base.Element;
import com.ibm.rdm.richtext.model.Link;
import com.ibm.rdm.richtext.model.RichtextPackage;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonAutonameHelper
implements IAutonameHelper {
    public static final CommonAutonameHelper INSTANCE = new CommonAutonameHelper();
    private static final String AUTONAME_PREFIX = "<";
    private static final String AUTONAME_POSTFIX = ">";

    protected CommonAutonameHelper() {
    }

    protected EStructuralFeature getNameFeature(EObject object) {
        if (object instanceof Element) {
            return BasePackage.Literals.ELEMENT__NAME;
        }
        if (object instanceof Link) {
            return RichtextPackage.Literals.LINK__TITLE;
        }
        return null;
    }

    @Override
    public void autoname(EObject object) {
        assert (object != null);
        EStructuralFeature nameFeature = this.getNameFeature(object);
        if (nameFeature == null) {
            return;
        }
        this.autoname(object, nameFeature);
    }

    private void autoname(EObject object, EStructuralFeature nameFeature) {
        EReference containmentFeature = object.eContainmentFeature();
        List containment = Collections.emptyList();
        if (containmentFeature != null && containmentFeature.isMany()) {
            containment = (List)object.eContainer().eGet((EStructuralFeature)containmentFeature);
        }
        this.autoname(containment, object, nameFeature);
    }

    protected void autoname(List<? extends EObject> containmentList, EObject newObject, EStructuralFeature nameFeature) {
        if (!newObject.eIsSet(nameFeature)) {
            String autoname = this.getAutoname(containmentList, newObject, nameFeature);
            newObject.eSet(nameFeature, (Object)autoname);
        }
    }

    protected String getAutoname(List<? extends EObject> containmentList, EObject newObject, EStructuralFeature nameFeature) {
        String baseName = this.getBaseName(newObject);
        return this.getAutonameRecursive(containmentList, newObject, nameFeature, 1, baseName);
    }

    protected String getAutonameRecursive(List<? extends EObject> containmentList, EObject newObject, EStructuralFeature nameFeature, int postfix, String baseName) {
        String proposedName = AUTONAME_PREFIX + baseName + postfix + AUTONAME_POSTFIX;
        boolean matched = false;
        for (EObject eObject : containmentList) {
            String name = this.getName(eObject, nameFeature);
            if (name == null || !name.equals(proposedName)) continue;
            matched = true;
            break;
        }
        if (!matched) {
            return proposedName;
        }
        return this.getAutonameRecursive(containmentList, newObject, nameFeature, postfix + 1, baseName);
    }

    protected String getBaseName(EObject newObject) {
        return newObject.eClass().getName();
    }

    protected String getName(EObject obj, EStructuralFeature nameFeature) {
        return (String)obj.eGet(nameFeature);
    }
}

