/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rdm.ba;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trace {
    protected static String THROWING = "Throwing";
    protected static String CATCHING = "Catching";

    public static boolean isTracingEnabled(Plugin plugin) {
        if (plugin != null) {
            return plugin.isDebugging();
        }
        return false;
    }

    public static boolean isTracingEnabled(String pluginName) {
        String key;
        String value;
        if (pluginName != null && (value = Platform.getDebugOption((String)(key = String.valueOf(pluginName) + "/debug"))) != null) {
            return value.equalsIgnoreCase("true");
        }
        return false;
    }

    public static boolean isDebugOptionEnabled(String debugOption) {
        if (debugOption != null) {
            return "true".equalsIgnoreCase(Platform.getDebugOption((String)debugOption));
        }
        return false;
    }

    public static void traceThrowing(Plugin plugin, Class<?> clazz, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(THROWING) + " in Plugin: " + plugin.toString() + "\t\t Class: " + clazz.toString() + "\n>>>>" + message);
        System.out.print(buffer.toString());
    }

    public static void traceThrowing(String pluginName, Class<?> clazz, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(THROWING) + " in Plugin: " + pluginName + "\t\t Class: " + clazz.toString() + "\n>>>>" + message);
        System.out.print(buffer.toString());
    }

    public static void traceCatching(Plugin plugin, Class<?> clazz, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(CATCHING) + " in Plugin: " + plugin.toString() + "\t\t Class: " + clazz.toString() + "\n>>>>" + message);
        System.out.print(buffer.toString());
    }

    public static void traceCatching(String pluginName, Class<?> clazz, String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(CATCHING) + " in Plugin: " + pluginName + "\t\t Class: " + clazz.toString() + "\n>>>>" + message);
        System.out.print(buffer.toString());
    }
}

