/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rdm.attribute.style;

import com.ibm.rdm.attribute.Messages;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AttributeType implements Enumerator
{
    ENUM(0, Messages.AttributeType_List, "Enum"),
    STRING(1, Messages.AttributeType_String, "String"),
    DATE(2, Messages.AttributeType_Date, "Date"),
    INTEGER(3, Messages.AttributeType_Integer, "Integer"),
    BOOLEAN(4, Messages.AttributeType_Boolean, "Boolean"),
    DECIMAL(5, Messages.AttributeType_Decimal, "Decimal"),
    FLOAT(6, "Float", "Float"),
    URI(7, Messages.AttributeType_URI, "URI"),
    COLLECTION(8, "Users", "Collection");

    public static final int ENUM_VALUE = 0;
    public static final int STRING_VALUE = 1;
    public static final int DATE_VALUE = 2;
    public static final int INTEGER_VALUE = 3;
    public static final int BOOLEAN_VALUE = 4;
    public static final int DECIMAL_VALUE = 5;
    public static final int FLOAT_VALUE = 6;
    public static final int URI_VALUE = 7;
    public static final int COLLECTION_VALUE = 8;
    private static final AttributeType[] VALUES_ARRAY;
    public static final List<AttributeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AttributeType[]{ENUM, STRING, DATE, INTEGER, BOOLEAN, DECIMAL, URI};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AttributeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeType get(int value) {
        switch (value) {
            case 0: {
                return ENUM;
            }
            case 1: {
                return STRING;
            }
            case 2: {
                return DATE;
            }
            case 3: {
                return INTEGER;
            }
            case 4: {
                return BOOLEAN;
            }
            case 5: {
                return DECIMAL;
            }
            case 6: {
                return FLOAT;
            }
            case 7: {
                return URI;
            }
            case 8: {
                return COLLECTION;
            }
        }
        return null;
    }

    private AttributeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

