/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.textanalyzer.internal;

import com.ibm.rcp.textanalyzer.TextAnalyzerException;
import com.ibm.rcp.textanalyzer.dictionarymanager.DictionaryInfo;
import com.ibm.rcp.textanalyzer.internal.DuplicateWordTableInfo;
import com.ibm.rcp.textanalyzer.internal.EngineExtensionInfo;
import com.ibm.rcp.textanalyzer.internal.RuntimeEngineTable;
import com.ibm.rcp.textanalyzer.internal.SpellCheckerCommon;
import com.ibm.rcp.textanalyzer.internal.TextAnalyzerLogger;
import com.ibm.rcp.textanalyzer.internal.UserDictionaryData;
import com.ibm.rcp.textanalyzer.internal.UserDictionaryImpl;
import com.ibm.rcp.textanalyzer.spellchecker.SpellCheckerEngine;
import com.ibm.rcp.textanalyzer.spellchecker.udm.UserDictionary;
import com.ibm.rcp.textanalyzer.spellchecker.udm.UserDictionaryEvent;
import com.ibm.rcp.textanalyzer.spellchecker.udm.UserDictionaryListener;
import com.ibm.rcp.textanalyzer.spellchecker.udm.UserDictionaryManager;
import com.ibm.rcp.textanalyzer.spellchecker.udm.UserWord;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserDictionaryManagerImpl
implements UserDictionaryManager {
    private static List items = null;
    private static List binaryUDIList = null;
    private static List UDMInfoList = null;
    private static List duplicateWordList = null;
    private static Document doc = null;
    private static ILock docLock = null;
    private static Document UDIPersistDoc = null;
    private static ILock UDIPersistDocLock = null;
    private static final long delayTime = 500L;
    private static final String userDictionaryFileName = "UserDictionary.xml";
    private static final String userDictionaryTag = "userdictionary";
    private static final String dictionaryTag = "dictionary";
    private static final String subDictionaryTag = "subDictionary";
    private static final String localeTag = "locale";
    private static final String userWordTag = "userword";
    private static final String replaceWordTag = "replaceword";
    private static final String userWordTypeTag = "userWordType";
    private static final String nameTag = "name";
    private static final String userDicInfoPersistFile = "UDIPersist.xml";
    private static final String userBinaryDictInfoTag = "userbinarydictinfo";
    private static final String dicInfoTag = "dicInfo";
    private static final String engineTag = "engine";
    private static final String dictionaryNameTag = "dictionaryName";
    private static final String filePathTag = "filePath";
    private static final String lastModifyDateTag = "lastModifyDate";
    private static final String versionTag = "version";
    private static final String languageTag = "language";
    private static final String providerTag = "provider";
    private static final String descriptionTag = "description";
    private static final String UDMDataInfoTag = "UDMDataInfo";
    private static final String UDIPersistTag = "udiPersist";
    private static final String dataInfoTag = "dataInfo";
    private static String clazzName;
    private static String pkgName;
    private static Node dictionaryRootNode;
    private static Node binaryUserDictNode;
    private static Node udmDataNode;
    private static Node UDIPersistNode;
    static ArrayList userDictionaryEventListeners;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.rcp.textanalyzer.internal.UserDictionaryManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        clazzName = clazz.getName();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.ibm.rcp.textanalyzer.internal.UserDictionaryManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        pkgName = clazz2.getPackage().getName();
        dictionaryRootNode = null;
        binaryUserDictNode = null;
        udmDataNode = null;
        UDIPersistNode = null;
        userDictionaryEventListeners = new ArrayList();
    }

    public UserDictionaryManagerImpl() {
        this.initDoc();
        this.initUDIDocument();
        this.initRootNode();
        this.initDuplicateWordTable();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserDictionary createUserDictionary(String locale, String suggestionName) throws TextAnalyzerException {
        Object var9_10;
        String methodName = "createUserDictionary";
        if (!SpellCheckerCommon.validateUDMLocale(locale)) {
            throw new TextAnalyzerException(4, TextAnalyzerLogger.error_Language_Not_Supported, new String[]{locale});
        }
        if (suggestionName == null || suggestionName.equalsIgnoreCase("")) {
            TextAnalyzerLogger.log(Level.WARNING, pkgName, clazzName, methodName, TextAnalyzerLogger.warning_No_Dictionary_Name);
            return null;
        }
        if (!this.isDictNameValidate(suggestionName)) {
            TextAnalyzerLogger.log(Level.WARNING, pkgName, clazzName, methodName, TextAnalyzerLogger.warning_UnSupported_Dictionary_Name);
            return null;
        }
        if (this.validateSameDictName(locale, suggestionName)) {
            TextAnalyzerLogger.log(Level.WARNING, pkgName, clazzName, methodName, TextAnalyzerLogger.warning_Dumplicated_Dictionary_Name, new String[]{suggestionName, locale});
            return null;
        }
        boolean findIt = false;
        UserDictionaryImpl retV = new UserDictionaryImpl();
        UserDictionaryData newDictionary = new UserDictionaryData();
        retV.setData(newDictionary);
        Element newCreatedNode = doc.createElement(subDictionaryTag);
        newCreatedNode.setAttribute(nameTag, SpellCheckerCommon.saveConvert(suggestionName, false));
        newDictionary.dictionaryNode = newCreatedNode;
        newDictionary.dicName = suggestionName;
        newDictionary.locale = locale;
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            UserDict tempUD = (UserDict)iter.next();
            if (!tempUD.locale.equalsIgnoreCase(locale)) continue;
            findIt = true;
            tempUD.dictionary.add(newDictionary);
            tempUD.localeDictionaryNode.appendChild(newCreatedNode);
            break;
        }
        if (!findIt) {
            UserDict ud = new UserDict();
            ud.locale = locale;
            Element udNode = doc.createElement(dictionaryTag);
            udNode.setAttribute(localeTag, locale);
            ud.localeDictionaryNode = udNode;
            ud.dictionary = new LinkedList();
            ud.dictionary.add(newDictionary);
            ud.localeDictionaryNode.appendChild(newCreatedNode);
            items.add(ud);
            dictionaryRootNode.appendChild(ud.localeDictionaryNode);
        }
        try {
            try {
                docLock.acquire(500L);
                SpellCheckerCommon.writeDocument(doc, userDictionaryFileName);
            }
            catch (InterruptedException exp) {
                TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Lock_Resources, exp);
            }
        }
        catch (Throwable throwable) {
            var9_10 = null;
            docLock.release();
            throw throwable;
        }
        {
            var9_10 = null;
        }
        docLock.release();
        UserDictionaryManagerImpl.recordDataChangedTime(locale, suggestionName, false);
        this.addNewUserDictIntoDupWordTable(locale, suggestionName);
        this.createUserDictionaryEvent(retV, true);
        return retV;
    }

    public UserDictionary[] getUserDictionaries(String locale) {
        UserDict tempUD;
        String methodName = "getUserDictionaries";
        List tmpList = null;
        if (locale.equalsIgnoreCase("*")) {
            tmpList = new LinkedList();
            Iterator iter = items.iterator();
            while (iter.hasNext()) {
                tempUD = (UserDict)iter.next();
                tmpList.addAll(tempUD.dictionary);
            }
        } else {
            if (!SpellCheckerCommon.validateUDMLocale(locale)) {
                TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Language_Not_Supported, new String[]{locale});
                return new UserDictionary[0];
            }
            Iterator iter2 = items.iterator();
            while (iter2.hasNext()) {
                tempUD = (UserDict)iter2.next();
                if (!tempUD.locale.equalsIgnoreCase(locale)) continue;
                tmpList = tempUD.dictionary;
                break;
            }
        }
        if (tmpList == null) {
            return new UserDictionary[0];
        }
        int size = tmpList.size();
        UserDictionary[] retV = new UserDictionary[size];
        int i = 0;
        while (i < size) {
            retV[i] = ((UserDictionaryData)tmpList.get(i)).getIUserDictionary();
            ++i;
        }
        return retV;
    }

    public UserDictionary getUserDictionary(String locale, String dictName) {
        String methodName = "getUserDictionary";
        if (!SpellCheckerCommon.validateUDMLocale(locale)) {
            TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Language_Not_Supported, new String[]{locale});
            return null;
        }
        try {
            UserDictionary[] dicts = this.getUserDictionaries(locale);
            int i = 0;
            while (i < dicts.length) {
                if (dicts[i].getName().equalsIgnoreCase(dictName)) {
                    return dicts[i];
                }
                ++i;
            }
        }
        catch (TextAnalyzerException exp) {
            TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Get_UserDictionary, exp);
        }
        return null;
    }

    public UserWord[] getUserWords(DictionaryInfo userDict) {
        int dictType = userDict.getDictType();
        if (dictType == 2) {
            String locale = userDict.getLocale();
            String dicName = userDict.getDictionaryName();
            List tmpList = null;
            Iterator iter = items.iterator();
            block0: while (iter.hasNext()) {
                UserDict tempUD = (UserDict)iter.next();
                if (!tempUD.locale.equalsIgnoreCase(locale)) continue;
                UserDictionaryData data = null;
                Iterator iterD = tempUD.dictionary.iterator();
                while (iterD.hasNext()) {
                    data = (UserDictionaryData)iterD.next();
                    if (!data.dicName.equalsIgnoreCase(dicName)) continue;
                    tmpList = data.words;
                    break block0;
                }
                break block0;
            }
            if (tmpList != null) {
                return tmpList.toArray(new UserWord[tmpList.size()]);
            }
        }
        return new UserWord[0];
    }

    /*
     * Exception decompiling
     */
    public boolean deleteUserDictionary(UserDictionary targetDict) throws TextAnalyzerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 192->195)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getBinaryUserDictionaryStatus(DictionaryInfo dict) {
        String methodName = "getBinaryUserDictionaryStatus";
        if (dict == null) {
            return -1;
        }
        if (!SpellCheckerCommon.validateCheckingLocale(dict.getLocale())) {
            TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Language_Not_Supported, new String[]{dict.getLocale()});
            return -1;
        }
        long binaryUpdateTime = 0L;
        long UDMUpdateTime = 0L;
        boolean findIt = false;
        Iterator iter = binaryUDIList.iterator();
        while (iter.hasNext()) {
            BinaryUDInfo temp = (BinaryUDInfo)iter.next();
            if (!temp.dictInfo.getLocale().equalsIgnoreCase(dict.getLocale()) || !temp.dictInfo.getDictionaryName().equalsIgnoreCase(dict.getDictionaryName()) || !temp.dictInfo.getEngineName().equalsIgnoreCase(dict.getEngineName())) continue;
            binaryUpdateTime = temp.modifyDate;
            findIt = true;
            break;
        }
        if (!findIt) {
            return 0;
        }
        Iterator iterU = UDMInfoList.iterator();
        while (iterU.hasNext()) {
            UDMDataInfo info = (UDMDataInfo)iterU.next();
            if (!info.locale.equalsIgnoreCase(dict.getLocale()) || !info.dictionName.equalsIgnoreCase(dict.getDictionaryName())) continue;
            UDMUpdateTime = info.modifyDate;
            break;
        }
        if (binaryUpdateTime == 0L || UDMUpdateTime == 0L) {
            return 0;
        }
        long diff = binaryUpdateTime - UDMUpdateTime;
        if (diff >= 0L) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateBinaryUserDictionaryStatus(DictionaryInfo dicInfo, int status) {
        Object var9_9;
        String methodName = "updateBinaryUserDictionaryStatus";
        if (dicInfo == null) {
            return false;
        }
        if (!SpellCheckerCommon.validateCheckingLocale(dicInfo.getLocale())) {
            TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Language_Not_Supported, new String[]{dicInfo.getLocale()});
            return false;
        }
        long time = new Date().getTime();
        String currentTime = String.valueOf(time);
        boolean findIt = false;
        Iterator iter = binaryUDIList.iterator();
        while (iter.hasNext()) {
            BinaryUDInfo temp = (BinaryUDInfo)iter.next();
            if (!temp.dictInfo.getLocale().equalsIgnoreCase(dicInfo.getLocale()) || !temp.dictInfo.getDictionaryName().equalsIgnoreCase(dicInfo.getDictionaryName()) || !temp.dictInfo.getEngineName().equalsIgnoreCase(dicInfo.getEngineName())) continue;
            findIt = true;
            if (status == 0) {
                binaryUDIList.remove(temp);
                Node parent = temp.BinaryUDNode.getParentNode();
                parent.removeChild(temp.BinaryUDNode);
                break;
            }
            temp.modifyDate = time;
            ((Element)temp.BinaryUDNode).setAttribute(lastModifyDateTag, currentTime);
            temp.dictInfo.setDescription(dicInfo.getDescription());
            ((Element)temp.BinaryUDNode).setAttribute(descriptionTag, SpellCheckerCommon.saveConvert(dicInfo.getDescription(), false));
            temp.dictInfo.setFilePath(dicInfo.getFilePath());
            ((Element)temp.BinaryUDNode).setAttribute(filePathTag, SpellCheckerCommon.saveConvert(dicInfo.getFilePath(), false));
            temp.dictInfo.setLanguage(dicInfo.getLanguage());
            ((Element)temp.BinaryUDNode).setAttribute(languageTag, SpellCheckerCommon.saveConvert(dicInfo.getLanguage(), false));
            temp.dictInfo.setVersionInfo(dicInfo.getVersionInfo());
            ((Element)temp.BinaryUDNode).setAttribute(versionTag, SpellCheckerCommon.saveConvert(dicInfo.getVersionInfo(), false));
            temp.dictInfo.setProvider(dicInfo.getProvider());
            ((Element)temp.BinaryUDNode).setAttribute(providerTag, SpellCheckerCommon.saveConvert(dicInfo.getProvider(), false));
            break;
        }
        if (!findIt && status == 1) {
            BinaryUDInfo tmp = new BinaryUDInfo();
            tmp.dictInfo = dicInfo;
            tmp.modifyDate = time;
            Element newNode = UDIPersistDoc.createElement(dicInfoTag);
            newNode.setAttribute(descriptionTag, SpellCheckerCommon.saveConvert(dicInfo.getDescription(), false));
            newNode.setAttribute(localeTag, dicInfo.getLocale());
            newNode.setAttribute(engineTag, dicInfo.getEngineName());
            newNode.setAttribute(dictionaryNameTag, SpellCheckerCommon.saveConvert(dicInfo.getDictionaryName(), false));
            newNode.setAttribute(filePathTag, SpellCheckerCommon.saveConvert(dicInfo.getFilePath(), false));
            newNode.setAttribute(languageTag, SpellCheckerCommon.saveConvert(dicInfo.getLanguage(), false));
            newNode.setAttribute(providerTag, SpellCheckerCommon.saveConvert(dicInfo.getProvider(), false));
            newNode.setAttribute(versionTag, dicInfo.getVersionInfo());
            newNode.setAttribute(lastModifyDateTag, currentTime);
            if (binaryUserDictNode == null) {
                binaryUserDictNode = UDIPersistDoc.createElement(userBinaryDictInfoTag);
                UDIPersistNode.appendChild(binaryUserDictNode);
            }
            binaryUserDictNode.appendChild(newNode);
            tmp.BinaryUDNode = newNode;
            binaryUDIList.add(tmp);
        }
        try {
            try {
                UDIPersistDocLock.acquire(500L);
                SpellCheckerCommon.writeDocument(UDIPersistDoc, userDicInfoPersistFile);
            }
            catch (InterruptedException exp) {
                TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Lock_Resources2, exp);
            }
        }
        catch (Throwable throwable) {
            var9_9 = null;
            UDIPersistDocLock.release();
            throw throwable;
        }
        {
            var9_9 = null;
        }
        UDIPersistDocLock.release();
        return true;
    }

    public DictionaryInfo[] getBinaryUserDictionaries(String locale, String engine) {
        return UserDictionaryManagerImpl.getBinaryUserDictionaryInfos(locale, engine);
    }

    public static DictionaryInfo[] getBinaryUserDictioaryInfo(String locale, String dicName) {
        LinkedList<DictionaryInfo> retL = new LinkedList<DictionaryInfo>();
        Iterator iter = binaryUDIList.iterator();
        while (iter.hasNext()) {
            BinaryUDInfo temp = (BinaryUDInfo)iter.next();
            if (!temp.dictInfo.getLocale().equalsIgnoreCase(locale) || !temp.dictInfo.getDictionaryName().equalsIgnoreCase(dicName)) continue;
            retL.add(temp.dictInfo);
        }
        return retL.toArray(new DictionaryInfo[retL.size()]);
    }

    public static DictionaryInfo getBinaryUserDictioaryInfo(String locale, String dicName, String engine) {
        UserDictionaryManagerImpl.getBinaryUserDictionaryInfos(locale, engine);
        Iterator iter = binaryUDIList.iterator();
        while (iter.hasNext()) {
            BinaryUDInfo temp = (BinaryUDInfo)iter.next();
            if (!temp.dictInfo.getLocale().equalsIgnoreCase(locale) || !temp.dictInfo.getDictionaryName().equalsIgnoreCase(dicName) || !temp.dictInfo.getEngineName().equalsIgnoreCase(engine)) continue;
            return temp.dictInfo;
        }
        return null;
    }

    public void addUserDictionaryListener(UserDictionaryListener listener) {
        userDictionaryEventListeners.add(listener);
    }

    public void removeUserDictionaryListener(UserDictionaryListener listener) {
        userDictionaryEventListeners.remove(listener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DictionaryInfo[] getBinaryUserDictionaryInfos(String locale, String engine) {
        Object var8_13;
        String methodName = "getBinaryUserDictionaryInfos";
        if (!SpellCheckerCommon.validateCheckingLocale(locale)) {
            TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Language_Not_Supported, new String[]{locale});
            return new DictionaryInfo[0];
        }
        if (engine.equalsIgnoreCase("")) {
            return new DictionaryInfo[0];
        }
        LinkedList<DictionaryInfo> retL = new LinkedList<DictionaryInfo>();
        LinkedList<UDMDataInfo> checkL = new LinkedList<UDMDataInfo>();
        Iterator iter = binaryUDIList.iterator();
        while (iter.hasNext()) {
            BinaryUDInfo temp = (BinaryUDInfo)iter.next();
            if (!temp.dictInfo.getLocale().equalsIgnoreCase(locale) || !temp.dictInfo.getEngineName().equalsIgnoreCase(engine)) continue;
            retL.add(temp.dictInfo);
        }
        int size = retL.size();
        Iterator iterU = UDMInfoList.iterator();
        while (iterU.hasNext()) {
            UDMDataInfo tmp = (UDMDataInfo)iterU.next();
            if (!tmp.locale.equalsIgnoreCase(locale)) continue;
            checkL.add(tmp);
        }
        int checkSize = checkL.size();
        if (checkSize <= size) return retL.toArray(new DictionaryInfo[retL.size()]);
        int iretL = 0;
        while (iretL < retL.size()) {
            DictionaryInfo tempInfo = (DictionaryInfo)retL.get(iretL);
            int l = checkL.size() - 1;
            while (l >= 0) {
                if (tempInfo.getDictionaryName().equalsIgnoreCase(((UDMDataInfo)checkL.get(l)).dictionName)) {
                    checkL.remove(l);
                }
                --l;
            }
            ++iretL;
        }
        Iterator iterNA = checkL.iterator();
        while (iterNA.hasNext()) {
            DictionaryInfo newDic = new DictionaryInfo();
            newDic.setLocale(locale);
            newDic.setEngineName(engine);
            newDic.setDictionaryName(((UDMDataInfo)iterNA.next()).dictionName);
            newDic.setFilePath(String.valueOf(SpellCheckerCommon.getDataLocationPath()) + locale + "_" + engine + "_" + newDic.getDictionaryName() + ".dic");
            newDic.setDictType(2);
            retL.add(newDic);
            BinaryUDInfo newBUDI = new BinaryUDInfo();
            newBUDI.dictInfo = newDic;
            newBUDI.modifyDate = 0L;
            Element newNode = UDIPersistDoc.createElement(dicInfoTag);
            newNode.setAttribute(localeTag, locale);
            newNode.setAttribute(engineTag, engine);
            newNode.setAttribute(dictionaryNameTag, newDic.getDictionaryName());
            newNode.setAttribute(filePathTag, newDic.getFilePath());
            newNode.setAttribute(lastModifyDateTag, "");
            if (binaryUserDictNode == null) {
                binaryUserDictNode = UDIPersistDoc.createElement(userBinaryDictInfoTag);
                UDIPersistNode.appendChild(binaryUserDictNode);
            }
            binaryUserDictNode.appendChild(newNode);
            newBUDI.BinaryUDNode = newNode;
            binaryUDIList.add(newBUDI);
        }
        try {
            try {
                UDIPersistDocLock.acquire(500L);
                SpellCheckerCommon.writeDocument(UDIPersistDoc, userDicInfoPersistFile);
            }
            catch (InterruptedException exp) {
                TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Lock_Resources2, exp);
            }
            var8_13 = null;
        }
        catch (Throwable throwable) {
            var8_13 = null;
            UDIPersistDocLock.release();
            throw throwable;
        }
        UDIPersistDocLock.release();
        return retL.toArray(new DictionaryInfo[retL.size()]);
    }

    private void createUserDictionaryEvent(UserDictionary ud, boolean created) {
        String methodName = "createUserDictionaryEvent";
        try {
            EngineExtensionInfo[] retA = RuntimeEngineTable.getEngineExtensionList();
            if (retA == null || retA.length == 0) {
                UserDictionaryEvent event = new UserDictionaryEvent();
                DictionaryInfo dicInfo = new DictionaryInfo();
                dicInfo.setDictType(2);
                dicInfo.setDictionaryName(ud.getName());
                dicInfo.setLocale(ud.getLocale());
                dicInfo.setLanguage(SpellCheckerCommon.getLanguageDescription(ud.getLocale()));
                event.setTargetDictionary(dicInfo);
                if (created) {
                    event.setType(1);
                } else {
                    event.setType(2);
                }
                this.fireUserDictionaryEvent(event);
            } else {
                int j = 0;
                while (j < retA.length) {
                    if (retA[j] != null) {
                        UserDictionaryEvent event = new UserDictionaryEvent();
                        DictionaryInfo dicInfo = new DictionaryInfo();
                        dicInfo.setDictType(2);
                        dicInfo.setDictionaryName(ud.getName());
                        dicInfo.setLocale(ud.getLocale());
                        dicInfo.setEngineName(retA[j].engineName);
                        dicInfo.setFilePath(String.valueOf(SpellCheckerCommon.getDataLocationPath()) + dicInfo.getLocale() + "_" + dicInfo.getEngineName() + "_" + dicInfo.getDictionaryName() + ".dic");
                        event.setTargetDictionary(dicInfo);
                        if (created) {
                            event.setType(1);
                        } else {
                            event.setType(2);
                        }
                        this.fireUserDictionaryEvent(event);
                    }
                    ++j;
                }
            }
        }
        catch (TextAnalyzerException scExp) {
            TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_UserDictionary_Event, scExp);
        }
    }

    private void fireUserDictionaryEvent(UserDictionaryEvent UD_event) {
        int i = 0;
        while (i < userDictionaryEventListeners.size()) {
            UserDictionaryListener lis = (UserDictionaryListener)userDictionaryEventListeners.get(i);
            lis.userDictionaryChanged(UD_event);
            ++i;
        }
        boolean hasEngineStart = false;
        if (userDictionaryEventListeners.size() != 0) {
            int i2 = 0;
            while (i2 < userDictionaryEventListeners.size()) {
                UserDictionaryListener lis = (UserDictionaryListener)userDictionaryEventListeners.get(i2);
                if (lis instanceof SpellCheckerEngine) {
                    hasEngineStart = true;
                    break;
                }
                ++i2;
            }
        }
        if (UD_event.getType() == 2 && !hasEngineStart) {
            DictionaryInfo dicInfo = UD_event.getTargetDictionary();
            String fileName = dicInfo.getFilePath();
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            this.updateBinaryUserDictionaryStatus(dicInfo, 0);
        }
    }

    private void initDoc() {
        String methodName = "initDoc";
        try {
            String path = SpellCheckerCommon.getDataLocationPath();
            File dictionaryFile = new File(String.valueOf(path) + userDictionaryFileName);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (!dictionaryFile.exists()) {
                dictionaryFile.createNewFile();
                doc = builder.newDocument();
                Element rootNode = doc.createElement(userDictionaryTag);
                doc.appendChild(rootNode);
                items = new LinkedList();
                SpellCheckerCommon.writeDocument(doc, userDictionaryFileName);
            } else {
                doc = builder.parse(dictionaryFile);
                items = this.getDataFromDocument(doc);
            }
            IJobManager jobMan = Platform.getJobManager();
            docLock = jobMan.newLock();
        }
        catch (Exception e) {
            TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Init_UserDictionary, e);
        }
    }

    private void initRootNode() {
        NodeList dicList = doc.getElementsByTagName(userDictionaryTag);
        if (dicList != null && dicList.getLength() == 1) {
            dictionaryRootNode = dicList.item(0);
        }
        if ((dicList = UDIPersistDoc.getElementsByTagName(UDIPersistTag)) != null && dicList.getLength() == 1) {
            UDIPersistNode = dicList.item(0);
        }
    }

    private Node getBinaryUserDictRootNode() {
        NodeList dicList = UDIPersistDoc.getElementsByTagName(userBinaryDictInfoTag);
        if (dicList != null && dicList.getLength() == 1) {
            binaryUserDictNode = dicList.item(0);
        }
        return binaryUserDictNode;
    }

    private Node getUDMDataRootNode() {
        NodeList dicList = UDIPersistDoc.getElementsByTagName(UDMDataInfoTag);
        if (dicList != null && dicList.getLength() == 1) {
            udmDataNode = dicList.item(0);
        }
        return udmDataNode;
    }

    private List getDataFromDocument(Document doc) {
        LinkedList<UserDict> dictionaries = new LinkedList<UserDict>();
        String tmpLocale = null;
        UserDict userDict = null;
        NodeList dicList = doc.getElementsByTagName(subDictionaryTag);
        int i = 0;
        while (i < dicList.getLength()) {
            Node dic = dicList.item(i);
            Node parent = dic.getParentNode();
            String locale = this.getAttributeValue(parent, localeTag);
            if (tmpLocale == null || !locale.equalsIgnoreCase(tmpLocale)) {
                tmpLocale = locale;
                userDict = new UserDict();
                userDict.locale = locale;
                userDict.localeDictionaryNode = parent;
                userDict.dictionary = new LinkedList();
                dictionaries.add(userDict);
            }
            UserDictionaryData udd = new UserDictionaryData();
            udd.locale = locale;
            udd.dicName = this.getAttributeValue(dic, nameTag);
            udd.dictionaryNode = dic;
            udd.words = new LinkedList();
            NodeList children = dic.getChildNodes();
            int k = 0;
            while (k < children.getLength()) {
                Node child = children.item(k);
                udd.words.add(this.getWord(child));
                ++k;
            }
            userDict.dictionary.add(udd);
            ++i;
        }
        return dictionaries;
    }

    private String getAttributeValue(Node node, String attributeName) {
        NamedNodeMap attrList = node.getAttributes();
        int ct = 0;
        while (ct < attrList.getLength()) {
            Node attrNode = attrList.item(ct);
            if (attrNode.getNodeName().trim().equalsIgnoreCase(attributeName)) {
                return SpellCheckerCommon.loadConvert(attrNode.getNodeValue().trim());
            }
            ++ct;
        }
        return null;
    }

    private UserWord getWord(Node node) {
        UserWord word = new UserWord();
        if (node.getNodeName().equalsIgnoreCase(userWordTag)) {
            String tmpStr = node.getFirstChild().getNodeValue().trim();
            if (tmpStr != null) {
                word.setUserWord(SpellCheckerCommon.loadConvert(tmpStr));
            } else {
                word.setUserWord(null);
            }
            tmpStr = this.getAttributeValue(node, replaceWordTag);
            if (tmpStr != null) {
                word.setReplaceWord(tmpStr);
            } else {
                word.setReplaceWord(null);
            }
            int isUserWord = Integer.parseInt(this.getAttributeValue(node, userWordTypeTag));
            if (isUserWord == 1) {
                word.setType(1);
            } else if (isUserWord == 2) {
                word.setType(2);
            }
        }
        return word;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void recordDataChangedTime(String locale, String dictName, boolean deleted) {
        Object var9_9;
        String methodName = "recordDataChangedTime";
        long time = new Date().getTime();
        boolean findIt = false;
        String currentTime = String.valueOf(time);
        Iterator iter = UDMInfoList.iterator();
        while (iter.hasNext()) {
            UDMDataInfo temp = (UDMDataInfo)iter.next();
            if (!temp.locale.equalsIgnoreCase(locale) || !temp.dictionName.equalsIgnoreCase(dictName)) continue;
            findIt = true;
            if (deleted) {
                UDMInfoList.remove(temp);
                Node parent = temp.UDMDataNode.getParentNode();
                parent.removeChild(temp.UDMDataNode);
                break;
            }
            temp.modifyDate = time;
            ((Element)temp.UDMDataNode).setAttribute(lastModifyDateTag, currentTime);
            break;
        }
        if (!findIt && !deleted) {
            UDMDataInfo tmp = new UDMDataInfo();
            tmp.locale = locale;
            tmp.dictionName = dictName;
            tmp.modifyDate = time;
            Element newNode = UDIPersistDoc.createElement(dataInfoTag);
            newNode.setAttribute(localeTag, locale);
            newNode.setAttribute(dictionaryNameTag, SpellCheckerCommon.saveConvert(dictName, false));
            newNode.setAttribute(lastModifyDateTag, currentTime);
            if (udmDataNode == null) {
                udmDataNode = UDIPersistDoc.createElement(UDMDataInfoTag);
                UDIPersistNode.appendChild(udmDataNode);
            }
            udmDataNode.appendChild(newNode);
            tmp.UDMDataNode = newNode;
            UDMInfoList.add(tmp);
        }
        try {
            try {
                UDIPersistDocLock.acquire(500L);
                SpellCheckerCommon.writeDocument(UDIPersistDoc, userDicInfoPersistFile);
            }
            catch (InterruptedException exp) {
                TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Lock_Resources2, exp);
            }
        }
        catch (Throwable throwable) {
            var9_9 = null;
            UDIPersistDocLock.release();
            throw throwable;
        }
        {
            var9_9 = null;
        }
        UDIPersistDocLock.release();
    }

    private boolean isDictNameValidate(String dictName) {
        if (dictName.indexOf(58) != -1) {
            return false;
        }
        File tempFile = new File(String.valueOf(SpellCheckerCommon.getDataLocationPath()) + dictName);
        try {
            boolean tmp = tempFile.createNewFile();
            if (tmp) {
                tempFile.delete();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean validateSameDictName(String locale, String dictName) {
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            UserDict tempUD = (UserDict)iter.next();
            if (!tempUD.locale.equalsIgnoreCase(locale)) continue;
            Iterator iter1 = tempUD.dictionary.iterator();
            while (iter1.hasNext()) {
                UserDictionaryData tmpData = (UserDictionaryData)iter1.next();
                if (!tmpData.dicName.equalsIgnoreCase(dictName)) continue;
                return true;
            }
        }
        return false;
    }

    private void initUDIDocument() {
        String methodName = "initUDIDocument";
        String path = SpellCheckerCommon.getDataLocationPath();
        try {
            File persistFile = new File(String.valueOf(path) + userDicInfoPersistFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (!persistFile.exists()) {
                persistFile.createNewFile();
                UDIPersistDoc = builder.newDocument();
                UDIPersistDoc.appendChild(UDIPersistDoc.createElement(UDIPersistTag));
                binaryUDIList = new LinkedList();
                UDMInfoList = new LinkedList();
                SpellCheckerCommon.writeDocument(UDIPersistDoc, userDicInfoPersistFile);
            } else {
                UDIPersistDoc = builder.parse(persistFile);
                binaryUDIList = this.getBinaryUDIFromDocument(UDIPersistDoc);
                UDMInfoList = this.getUDMDataInfoFromDoc(UDIPersistDoc);
                binaryUserDictNode = this.getBinaryUserDictRootNode();
                udmDataNode = this.getUDMDataRootNode();
            }
            IJobManager jobMan = Platform.getJobManager();
            UDIPersistDocLock = jobMan.newLock();
        }
        catch (Exception e) {
            TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Init_UDI_Error, e);
        }
    }

    private List getBinaryUDIFromDocument(Document doc) {
        LinkedList<BinaryUDInfo> dicInfos = new LinkedList<BinaryUDInfo>();
        NodeList binaryDicList = doc.getElementsByTagName(dicInfoTag);
        int i = 0;
        while (i < binaryDicList.getLength()) {
            Node tempNode = binaryDicList.item(i);
            BinaryUDInfo binaryUDIInfo = new BinaryUDInfo();
            DictionaryInfo dictInfo = new DictionaryInfo();
            dictInfo.setDictType(2);
            binaryUDIInfo.BinaryUDNode = tempNode;
            NamedNodeMap attrList = tempNode.getAttributes();
            int j = 0;
            while (j < attrList.getLength()) {
                Node attrNode = attrList.item(j);
                if (attrNode.getNodeName().trim().equalsIgnoreCase(localeTag)) {
                    dictInfo.setLocale(attrNode.getNodeValue().trim());
                }
                if (attrNode.getNodeName().trim().equalsIgnoreCase(engineTag)) {
                    dictInfo.setEngineName(attrNode.getNodeValue().trim());
                }
                if (dictionaryNameTag.equals(attrNode.getNodeName().trim())) {
                    dictInfo.setDictionaryName(SpellCheckerCommon.loadConvert(attrNode.getNodeValue().trim()));
                }
                if (filePathTag.equals(attrNode.getNodeName().trim())) {
                    dictInfo.setFilePath(SpellCheckerCommon.loadConvert(attrNode.getNodeValue().trim()));
                }
                if (lastModifyDateTag.equals(attrNode.getNodeName().trim())) {
                    if (!attrNode.getNodeValue().trim().equalsIgnoreCase("")) {
                        binaryUDIInfo.modifyDate = Long.parseLong(attrNode.getNodeValue().trim());
                    } else {
                        binaryUDIInfo.modifyDate = 0L;
                    }
                }
                if (versionTag.equals(attrNode.getNodeName().trim())) {
                    dictInfo.setVersionInfo(attrNode.getNodeValue().trim());
                }
                if (providerTag.equals(attrNode.getNodeName().trim())) {
                    dictInfo.setProvider(SpellCheckerCommon.loadConvert(attrNode.getNodeValue().trim()));
                }
                if (languageTag.equals(attrNode.getNodeName().trim())) {
                    dictInfo.setLanguage(SpellCheckerCommon.loadConvert(attrNode.getNodeValue().trim()));
                }
                if (descriptionTag.equals(attrNode.getNodeName().trim())) {
                    dictInfo.setDescription(SpellCheckerCommon.loadConvert(attrNode.getNodeValue().trim()));
                }
                ++j;
            }
            binaryUDIInfo.dictInfo = dictInfo;
            dicInfos.add(binaryUDIInfo);
            ++i;
        }
        return dicInfos;
    }

    private List getUDMDataInfoFromDoc(Document doc) {
        LinkedList<UDMDataInfo> UDMDataInfos = new LinkedList<UDMDataInfo>();
        NodeList UDMNodeList = doc.getElementsByTagName(dataInfoTag);
        int i = 0;
        while (i < UDMNodeList.getLength()) {
            Node tempNode = UDMNodeList.item(i);
            UDMDataInfo udmDataInfo = new UDMDataInfo();
            udmDataInfo.UDMDataNode = tempNode;
            NamedNodeMap attrList = tempNode.getAttributes();
            int j = 0;
            while (j < attrList.getLength()) {
                Node attrNode = attrList.item(j);
                if (attrNode.getNodeName().trim().equalsIgnoreCase(localeTag)) {
                    udmDataInfo.locale = attrNode.getNodeValue().trim();
                }
                if (dictionaryNameTag.equals(attrNode.getNodeName().trim())) {
                    udmDataInfo.dictionName = SpellCheckerCommon.loadConvert(attrNode.getNodeValue().trim());
                }
                if (lastModifyDateTag.equals(attrNode.getNodeName().trim()) && !attrNode.getNodeValue().trim().equalsIgnoreCase("")) {
                    udmDataInfo.modifyDate = Long.parseLong(attrNode.getNodeValue().trim());
                }
                ++j;
            }
            UDMDataInfos.add(udmDataInfo);
            ++i;
        }
        return UDMDataInfos;
    }

    private void initDuplicateWordTable() {
        duplicateWordList = new LinkedList();
        if (items != null) {
            int i = 0;
            while (i < items.size()) {
                UserDict userDict = (UserDict)items.get(i);
                List dictionary = userDict.dictionary;
                if (dictionary != null && dictionary.size() > 0) {
                    int j = 0;
                    while (j < dictionary.size()) {
                        DuplicateWordTableInfo dupWordTable = new DuplicateWordTableInfo();
                        UserDictionaryData dictData = (UserDictionaryData)dictionary.get(j);
                        dupWordTable.locale = dictData.locale;
                        dupWordTable.dictionaryName = dictData.dicName;
                        List words = dictData.words;
                        dupWordTable.compareWords = this.getAllCompareWords(words);
                        dupWordTable.duplicateWordMap = this.makeDupwordsMap(dupWordTable.compareWords);
                        duplicateWordList.add(dupWordTable);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private List getAllCompareWords(List wordList) {
        LinkedList<String> retV = new LinkedList<String>();
        int len = wordList.size();
        int i = 0;
        while (i < len) {
            UserWord word = (UserWord)wordList.get(i);
            if (word.getType() == 1) {
                retV.add(word.getUserWord());
            } else if (word.getReplaceWord() != null) {
                retV.add(word.getReplaceWord());
            }
            ++i;
        }
        return retV;
    }

    private Map makeDupwordsMap(List wordList) {
        HashMap<String, Integer> dupWordMap = new HashMap<String, Integer>();
        int len = wordList.size();
        int i = 0;
        while (i < len) {
            String word = (String)wordList.get(i);
            if (!dupWordMap.containsKey(word)) {
                int dupNum = 0;
                int j = i + 1;
                while (j < len) {
                    String word2 = (String)wordList.get(j);
                    if (word.equals(word2)) {
                        ++dupNum;
                    }
                    ++j;
                }
                if (dupNum > 0) {
                    dupWordMap.put(word, new Integer(dupNum));
                }
            }
            ++i;
        }
        return dupWordMap;
    }

    private void addNewUserDictIntoDupWordTable(String locale, String dictionaryName) {
        DuplicateWordTableInfo dupWordTable = new DuplicateWordTableInfo();
        dupWordTable.locale = locale;
        dupWordTable.dictionaryName = dictionaryName;
        dupWordTable.compareWords = new LinkedList();
        dupWordTable.duplicateWordMap = new HashMap();
        duplicateWordList.add(dupWordTable);
    }

    private void removeUserDictFromDupWordTable(String locale, String dictionaryName) {
        int len = duplicateWordList.size();
        int i = 0;
        while (i < len) {
            DuplicateWordTableInfo temp = (DuplicateWordTableInfo)duplicateWordList.get(i);
            if (temp.locale.equalsIgnoreCase(locale) && temp.dictionaryName.equalsIgnoreCase(dictionaryName)) {
                duplicateWordList.remove(i);
                break;
            }
            ++i;
        }
    }

    static List getDupWordList() {
        return duplicateWordList;
    }

    private static class BinaryUDInfo {
        private DictionaryInfo dictInfo;
        private long modifyDate;
        private Node BinaryUDNode;

        private BinaryUDInfo() {
        }
    }

    private static class UDMDataInfo {
        private String locale;
        private String dictionName;
        private long modifyDate;
        private Node UDMDataNode;

        private UDMDataInfo() {
        }
    }

    private class UserDict {
        private String locale;
        private List dictionary;
        private Node localeDictionaryNode = null;

        private UserDict() {
        }
    }
}

