/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.textanalyzer.internal;

import com.ibm.rcp.textanalyzer.TextAnalyzerException;
import com.ibm.rcp.textanalyzer.TextAnalyzerFactory;
import com.ibm.rcp.textanalyzer.dictionarymanager.DictionaryInfo;
import com.ibm.rcp.textanalyzer.dictionarymanager.DictionaryManager;
import com.ibm.rcp.textanalyzer.internal.RuntimeEngineTable;
import com.ibm.rcp.textanalyzer.internal.SpellCheckerCommon;
import com.ibm.rcp.textanalyzer.internal.SpellEngineInfo;
import com.ibm.rcp.textanalyzer.internal.TextAnalyzerLogger;
import com.ibm.rcp.textanalyzer.internal.UserDictionaryImpl;
import com.ibm.rcp.textanalyzer.spellchecker.MisspelledWord;
import com.ibm.rcp.textanalyzer.spellchecker.SpellChecker;
import com.ibm.rcp.textanalyzer.spellchecker.SpellCheckerEngine;
import com.ibm.rcp.textanalyzer.spellchecker.SpellCheckerPreference;
import com.ibm.rcp.textanalyzer.spellchecker.udm.UserDictionary;
import com.ibm.rcp.textanalyzer.spellchecker.udm.UserDictionaryManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;

public class SpellCheckerImpl
implements SpellChecker {
    private SpellCheckerEngine engine = null;
    private SpellEngineInfo specEngineInfo = null;
    private boolean disposed = false;

    private boolean getDefaultSession() {
        String defaultNL = Platform.getNL();
        defaultNL = defaultNL.replace('_', '-');
        String[] tArray = this.getSupportedLocales();
        int i = 0;
        while (i < tArray.length) {
            if (defaultNL.equalsIgnoreCase(tArray[i])) {
                try {
                    this.setLocale(defaultNL);
                }
                catch (TextAnalyzerException textAnalyzerException) {
                    return false;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean releaseCurrentSession() {
        if (this.engine != null) {
            this.specEngineInfo.engineExtensionInfo.removeSpellEngineObjectList(this.engine);
            this.engine.closeSession();
            this.engine = null;
        }
        return true;
    }

    public boolean dispose() {
        if (this.disposed) {
            return false;
        }
        this.disposed = true;
        if (this.engine != null) {
            this.releaseCurrentSession();
        }
        return true;
    }

    public String[] getSupportedLocales() {
        if (this.disposed) {
            return new String[0];
        }
        List retL = RuntimeEngineTable.getSpellingSupportedLocales();
        if (retL == null || retL.size() == 0) {
            return new String[0];
        }
        return retL.toArray(new String[retL.size()]);
    }

    public boolean setLocale(String locale) throws TextAnalyzerException {
        try {
            if (this.disposed) {
                throw new TextAnalyzerException(5, TextAnalyzerLogger.error_Instance_Disposed);
            }
            if (!SpellCheckerCommon.validateCheckingLocale(locale)) {
                throw new TextAnalyzerException(4, TextAnalyzerLogger.error_Language_Not_Supported, new String[]{locale});
            }
            DictionaryManager dm = TextAnalyzerFactory.getDictionaryManager();
            DictionaryInfo[] mainDic = dm.getDictionaryInfo(locale, 1);
            UserDictionaryManager udm = TextAnalyzerFactory.getUserDictionaryManager();
            UserDictionary[] uDict = udm.getUserDictionaries(locale);
            UserDictionary[] uDictXX = udm.getUserDictionaries("mul-xx");
            if (uDictXX.length != 0) {
                int len1 = uDict.length;
                int len2 = uDictXX.length;
                UserDictionary[] uDictAll = new UserDictionary[len1 + len2];
                int i = 0;
                while (i < len1) {
                    uDictAll[i] = uDict[i];
                    ++i;
                }
                while (i < len1 + len2) {
                    uDictAll[i] = uDictXX[i - len1];
                    ++i;
                }
                return this.setLocale(locale, mainDic, uDictAll);
            }
            return this.setLocale(locale, mainDic, uDict);
        }
        catch (TextAnalyzerException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new TextAnalyzerException(5, TextAnalyzerLogger.error_Language_Not_Supported, new String[]{locale});
        }
    }

    public boolean setLocale(String locale, DictionaryInfo[] mainDictArray, UserDictionary[] userDictArray) throws TextAnalyzerException {
        try {
            DictionaryInfo[] allDict;
            if (this.disposed) {
                throw new TextAnalyzerException(5, TextAnalyzerLogger.error_Instance_Disposed);
            }
            if (!SpellCheckerCommon.validateCheckingLocale(locale)) {
                throw new TextAnalyzerException(4, TextAnalyzerLogger.error_Language_Not_Supported, new String[]{locale});
            }
            if (this.engine != null) {
                this.releaseCurrentSession();
            }
            this.specEngineInfo = RuntimeEngineTable.getSpellEngineInfo(locale);
            if (this.specEngineInfo == null) {
                throw new TextAnalyzerException(6, TextAnalyzerLogger.error_No_Engine_Available);
            }
            this.engine = this.specEngineInfo.createSpellEngine();
            if (this.engine == null) {
                throw new TextAnalyzerException(7, TextAnalyzerLogger.error_Null_engine_Value);
            }
            if (mainDictArray == null && userDictArray == null) {
                allDict = null;
            } else {
                int allCount = 0;
                int i = 0;
                if (mainDictArray != null && mainDictArray.length != 0) {
                    allCount = mainDictArray.length;
                }
                if (userDictArray != null && userDictArray.length != 0) {
                    allCount += userDictArray.length;
                }
                ArrayList<DictionaryInfo> allDictList = new ArrayList<DictionaryInfo>();
                if (mainDictArray != null && mainDictArray.length != 0) {
                    i = 0;
                    while (i < mainDictArray.length) {
                        allDictList.add(mainDictArray[i]);
                        ++i;
                    }
                }
                UserDictionary userDic = null;
                UserDictionaryImpl userDicImpl = null;
                String engineName = this.specEngineInfo.engineName;
                if (userDictArray != null && userDictArray.length != 0) {
                    int j = 0;
                    j = 0;
                    while (j < userDictArray.length) {
                        userDic = userDictArray[j];
                        if (userDic instanceof UserDictionaryImpl) {
                            userDicImpl = (UserDictionaryImpl)userDic;
                            DictionaryInfo resDic = userDicImpl.getBinaryUserDictioaryInfo(engineName);
                            allDictList.add(resDic);
                        }
                        ++j;
                    }
                }
                allDict = allDictList.toArray(new DictionaryInfo[allDictList.size()]);
            }
            this.engine.openSession(locale, allDict);
            this.setInitPreferenceValue();
            return true;
        }
        catch (TextAnalyzerException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new TextAnalyzerException(5, TextAnalyzerLogger.error_Language_Not_Supported, new String[]{locale});
        }
    }

    private void setInitPreferenceValue() throws TextAnalyzerException {
        SpellCheckerPreference preference = TextAnalyzerFactory.getSpellCheckerPreference();
        this.engine.setBooleanPreference(1, preference.getBooleanPreference(1));
        this.engine.setBooleanPreference(2, preference.getBooleanPreference(2));
        this.engine.setBooleanPreference(4, preference.getBooleanPreference(4));
        this.engine.setBooleanPreference(8, preference.getBooleanPreference(8));
    }

    public MisspelledWord[] checkSpelling(String theInputText, int numSuggestions, boolean autoCorrect) {
        if (this.disposed) {
            return new MisspelledWord[0];
        }
        if (theInputText == null || theInputText.length() == 0) {
            return new MisspelledWord[0];
        }
        if (numSuggestions < 0) {
            return new MisspelledWord[0];
        }
        if (this.engine == null && !this.getDefaultSession()) {
            return new MisspelledWord[0];
        }
        MisspelledWord[] resArray = this.engine.checkSpelling(theInputText, numSuggestions, autoCorrect);
        return resArray;
    }

    public MisspelledWord[] checkSpelling(String theInputText, int begin, int end, int numSuggestions, boolean autoCorrect) {
        if (this.disposed) {
            return new MisspelledWord[0];
        }
        if (theInputText == null || theInputText.length() == 0) {
            return new MisspelledWord[0];
        }
        if (begin >= end) {
            return new MisspelledWord[0];
        }
        if (numSuggestions < 0) {
            return new MisspelledWord[0];
        }
        if (end > theInputText.length()) {
            end = theInputText.length();
        }
        if (this.engine == null && !this.getDefaultSession()) {
            return new MisspelledWord[0];
        }
        MisspelledWord[] resArray = this.engine.checkSpelling(theInputText, begin, end, numSuggestions, autoCorrect);
        return resArray;
    }

    public String[] getSuggestions(String word, int numSuggestions, int suggestionType) {
        if (this.disposed) {
            return new String[0];
        }
        if (word == null || word.length() == 0) {
            return new String[0];
        }
        if (numSuggestions <= 0) {
            return new String[0];
        }
        if (this.engine == null && !this.getDefaultSession()) {
            return new String[0];
        }
        String[] resArray = this.engine.getSuggestions(word, numSuggestions, suggestionType);
        return resArray;
    }

    public boolean addIgnoreWord(String word) {
        if (this.disposed) {
            return false;
        }
        if (word == null || word.length() == 0) {
            return false;
        }
        if (this.engine == null && !this.getDefaultSession()) {
            return false;
        }
        if (this.engine != null) {
            return this.engine.addIgnoreWord(word);
        }
        return false;
    }
}

