/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.textanalyzer.internal;

import com.ibm.rcp.textanalyzer.TextAnalyzerConstant;
import com.ibm.rcp.textanalyzer.internal.RuntimeEngineTable;
import com.ibm.rcp.textanalyzer.internal.TextAnalyzerLogger;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.w3c.dom.Document;

public class SpellCheckerCommon {
    private static final String UDMLocationName = "UDM";
    static /* synthetic */ Class class$0;

    public static void writeDocument(Document document, String fileName) {
        String methodName = "writeDocument";
        try {
            DOMSource source = new DOMSource(document);
            String path = SpellCheckerCommon.getDataLocationPath();
            File file = new File(String.valueOf(path) + fileName);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.rcp.textanalyzer.internal.SpellCheckerCommon");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String clazzName = clazz.getName();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.ibm.rcp.textanalyzer.internal.SpellCheckerCommon");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String pkgName = clazz2.getPackage().getName();
            TextAnalyzerLogger.log(Level.SEVERE, pkgName, clazzName, methodName, TextAnalyzerLogger.error_Write_File_Error, e);
        }
    }

    public static String getDataLocationPath() {
        Location dataStoreLocation = Platform.getInstanceLocation();
        String path = dataStoreLocation.getURL().getFile();
        File temp = new File(path = String.valueOf(path) + UDMLocationName + "/");
        if (!temp.exists()) {
            temp.mkdir();
        }
        return path;
    }

    public static boolean validateCheckingLocale(String locale) {
        if (locale == null || locale.length() == 0) {
            return false;
        }
        if (locale.equalsIgnoreCase("mul-xx")) {
            return true;
        }
        List retL = RuntimeEngineTable.getSpellingSupportedLocales();
        if (retL == null || retL.size() == 0) {
            return false;
        }
        Iterator iter = retL.iterator();
        while (iter.hasNext()) {
            if (!locale.equalsIgnoreCase((String)iter.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean validateUDMLocale(String locale) {
        if (locale == null || locale.length() == 0) {
            return false;
        }
        if (locale.equalsIgnoreCase("mul-xx")) {
            return true;
        }
        int size = TextAnalyzerConstant.ALL_LANGUAGES.length;
        int i = 0;
        while (i < size) {
            if (locale.equalsIgnoreCase(TextAnalyzerConstant.ALL_LANGUAGES[i])) {
                return true;
            }
            ++i;
        }
        List retL = RuntimeEngineTable.getSpellingSupportedLocales();
        if (retL == null || retL.size() == 0) {
            return false;
        }
        Iterator iter = retL.iterator();
        while (iter.hasNext()) {
            if (!locale.equalsIgnoreCase((String)iter.next())) continue;
            return true;
        }
        return false;
    }

    public static String saveConvert(String str, boolean escapeAscii) {
        if (str == null) {
            return "";
        }
        StringBuffer retV = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (!escapeAscii && ch >= ' ' && ch <= '~') {
                if (ch == '\\') {
                    retV.append('\\');
                }
                retV.append(ch);
            } else {
                retV.append("\\u");
                String hexStr = Integer.toHexString(str.charAt(i) & 0xFFFF);
                int j = 0;
                while (j < 4 - hexStr.length()) {
                    retV.append("0");
                    ++j;
                }
                retV.append(hexStr);
            }
            ++i;
        }
        return new String(retV);
    }

    public static String loadConvert(String str) {
        int len = str.length();
        StringBuffer retV = new StringBuffer();
        int i = 0;
        while (i < len) {
            if (str.charAt(i) == '\\') {
                if (str.charAt(++i) == 'u') {
                    String subStr = str.substring(++i, i + 4);
                    retV.append((char)Integer.valueOf(subStr, 16).intValue());
                    i += 4;
                    continue;
                }
                retV.append(str.charAt(i));
                ++i;
                continue;
            }
            retV.append(str.charAt(i));
            ++i;
        }
        return new String(retV);
    }

    public static String getLanguageDescription(String lang) {
        if (lang == null) {
            return "";
        }
        int i = 0;
        while (i < TextAnalyzerConstant.ALL_LANGUAGES.length) {
            if (lang.equals(TextAnalyzerConstant.ALL_LANGUAGES[i])) {
                return TextAnalyzerConstant.getLanguageDescription(TextAnalyzerConstant.ALL_LANGUAGES[i]);
            }
            ++i;
        }
        return lang;
    }
}

