/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rcp.rte.internal.actions;

import com.ibm.rcp.rte.RichTextEditor;
import com.ibm.rcp.rte.internal.FontNameDialog;
import com.ibm.rcp.rte.internal.LinkInsertDialog;
import com.ibm.rcp.rte.internal.RTENLS;
import com.ibm.rcp.rte.internal.TableInsertDialog;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;

public class ProcessRTECommand {
    public static final String RTE_COMMAND_PRINT = "Print";
    public static final String RTE_COMMAND_CUT = "Cut";
    public static final String RTE_COMMAND_COPY = "Copy";
    public static final String RTE_COMMAND_PASTE = "Paste";
    public static final String RTE_COMMAND_HORIZONTALRULE = "InsertHorizontalRule";
    public static final String RTE_COMMAND_BOLD = "Bold";
    public static final String RTE_COMMAND_ITALIC = "Italic";
    public static final String RTE_COMMAND_UNDERLINE = "Underline";
    public static final String RTE_COMMAND_FIND = "Find";
    public static final String RTE_COMMAND_REDO = "redo";
    public static final String RTE_COMMAND_UNDO = "undo";
    public static final String RTE_COMMAND_JUSTIFYLEFT = "justifyleft";
    public static final String RTE_COMMAND_JUSTIFYCENTER = "justifycenter";
    public static final String RTE_COMMAND_JUSTIFYRIGHT = "justifyright";
    public static final String RTE_COMMAND_INSERTORDEREDLIST = "insertorderedlist";
    public static final String RTE_COMMAND_INSERTUNORDEREDLIST = "insertunorderedlist";
    public static final String RTE_COMMAND_INDENT = "indent";
    public static final String RTE_COMMAND_OUTDENT = "outdent";
    public static final String RTE_COMMAND_DOCWHOLEBIDI = "docwholebidi";
    public static final String RTE_COMMAND_RTL = "rtl";
    public static final String RTE_COMMAND_LTR = "ltr";
    public static final String RTE_COMMAND_FONT = "font";
    public static final String RTE_COMMAND_FORECOLOR = "forecolor";
    public static final String RTE_COMMAND_BACKCOLOR = "backcolor";
    public static final String RTE_COMMAND_CREATELINK = "createlink";
    public static final String RTE_COMMAND_INSERTIMAGE = "insertimage";
    public static final String RTE_COMMAND_INSERTLINK = "insertlink";
    public static final String RTE_COMMAND_INSERTTABLE = "inserttable";
    public static final String RTE_COMMAND_JUSTIFYFULL = "justifyfull";
    public static final String RTE_COMMAND_REMOVEFORMAT = "removeformat";
    public static final String RTE_COMMAND_FORMATNAME = "formatblock";
    public static final String RTE_COMMAND_FONTNAME = "fontname";
    public static final String RTE_COMMAND_FONTSIZE = "fontsize";
    public static final String RTE_COMMAND_SELECTALL = "selectall";
    public static final String RTE_COMMAND_SPELLCHECKER = "spellchecker";
    public static final String RTE_COMMAND_BACKGROUNDSPELLCHECKER = "backgroundspellchecker";
    private RichTextEditor _editAPI;
    private String _rteCommand;
    private String _rteCommandValue;

    public ProcessRTECommand(RichTextEditor editAPI, String rteCommand, String value) {
        this._editAPI = editAPI;
        this._rteCommand = rteCommand;
        this._rteCommandValue = value;
    }

    public void setRTECommand(String rteCommand) {
        this._rteCommand = rteCommand;
    }

    public void setRTECommandValue(String value) {
        this._rteCommandValue = value;
    }

    public void execute() {
        if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_PRINT)) {
            this._editAPI.print();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_BACKCOLOR)) {
            this.promptColor();
            if (this._rteCommandValue != null) {
                this._editAPI.setBackColor(this._rteCommandValue);
            }
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_FORECOLOR)) {
            this.promptColor();
            if (this._rteCommandValue != null) {
                this._editAPI.setForeColor(this._rteCommandValue);
            }
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_BOLD)) {
            this._editAPI.bold();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_COPY)) {
            this._editAPI.copy();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_INSERTLINK)) {
            this.insertLink();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_INSERTTABLE)) {
            this.insertTable();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_CUT)) {
            this._editAPI.cut();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_FONTNAME)) {
            if (this._rteCommandValue != null) {
                this._editAPI.setFontName(this._rteCommandValue);
            } else {
                this.promptAndExecuteFont();
            }
            this._rteCommandValue = null;
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_FONTSIZE)) {
            this._editAPI.setFontSize(this._rteCommandValue);
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_FORMATNAME)) {
            this._editAPI.formatBlock(this._rteCommandValue);
        } else if (this._rteCommand.equalsIgnoreCase("Heading")) {
            this._editAPI.heading(this._rteCommandValue);
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_INDENT)) {
            this._editAPI.indent();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_HORIZONTALRULE)) {
            this._editAPI.insertHorizontalRule();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_INSERTORDEREDLIST)) {
            this._editAPI.insertOrderedList();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_INSERTUNORDEREDLIST)) {
            this._editAPI.insertBulletList();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_ITALIC)) {
            this._editAPI.italic();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_JUSTIFYCENTER)) {
            this._editAPI.setJustifyStyle(0);
        } else if (this._rteCommand.equalsIgnoreCase("JustifyFull")) {
            this._editAPI.setJustifyStyle(1);
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_JUSTIFYLEFT)) {
            this._editAPI.setJustifyStyle(2);
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_JUSTIFYRIGHT)) {
            this._editAPI.setJustifyStyle(3);
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_OUTDENT)) {
            this._editAPI.outdent();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_PASTE)) {
            this._editAPI.paste();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_REDO)) {
            this._editAPI.redo();
        } else if (this._rteCommand.equalsIgnoreCase("RemoveFormat")) {
            this._editAPI.removeFormat();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_UNDERLINE)) {
            this._editAPI.underline();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_UNDO)) {
            this._editAPI.undo();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_FIND)) {
            this._editAPI.find();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_SELECTALL)) {
            this._editAPI.selectAll();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_DOCWHOLEBIDI)) {
            this._editAPI.bidi();
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_RTL)) {
            this._editAPI.setDirection(-1);
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_LTR)) {
            this._editAPI.setDirection(1);
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_BACKGROUNDSPELLCHECKER)) {
            this._editAPI.enableBackgroundSpellchecking(!this._editAPI.isBackgroundSpellcheckingEnabled());
        } else if (this._rteCommand.equalsIgnoreCase(RTE_COMMAND_SPELLCHECKER)) {
            this._editAPI.doCheckSpelling();
        }
    }

    private void promptColor() {
        Shell shell = Display.getCurrent().getActiveShell();
        ColorDialog dlg = new ColorDialog(shell);
        dlg.setText(RTENLS.rteToolPalette_colordialog_title);
        RGB rgb = dlg.open();
        this.getRGBColor(rgb);
    }

    private void promptAndExecuteFont() {
        Shell shell = Display.getCurrent().getActiveShell();
        FontNameDialog dlg = new FontNameDialog(shell);
        int result = dlg.open();
        if (result == 0) {
            this._rteCommandValue = dlg.getCommandValue();
            this._editAPI.setFontName(this._rteCommandValue);
        }
    }

    private void getRGBColor(RGB rgb) {
        if (rgb != null) {
            String strValue = Integer.toHexString(rgb.red << 16 | rgb.green << 8 | rgb.blue);
            this._rteCommandValue = "#" + "000000".substring(0, 6 - strValue.length()) + strValue;
        }
    }

    private void insertLink() {
        Shell shell = Display.getCurrent().getActiveShell();
        LinkInsertDialog dlg = new LinkInsertDialog(shell);
        if (dlg.open() == 0) {
            String strElementText = dlg.getNodeText();
            String strUrlLink = dlg.getURL();
            strUrlLink = this.validateURL(strUrlLink);
            Element linkElem = this._editAPI.createHTMLElement("a");
            linkElem.setAttribute("href", strUrlLink);
            linkElem.appendChild(this._editAPI.getHtmlDocument().createTextNode(strElementText));
            this._editAPI.insertHTMLElementAtCursor(linkElem);
        }
    }

    private String validateURL(String url) {
        block3: {
            try {
                URL u = new URL(url);
                if (u.getProtocol() == null) {
                    return "http://" + url;
                }
            }
            catch (MalformedURLException e) {
                if (e.getMessage().toLowerCase().indexOf("no protocol") < 0) break block3;
                return "http://" + url;
            }
        }
        return url;
    }

    private void insertTable() {
        Shell shell = Display.getCurrent().getActiveShell();
        TableInsertDialog dlg = new TableInsertDialog(shell);
        if (dlg.open() == 0) {
            int rowNumber = dlg.getRowNumber();
            int columnNumber = dlg.getColumnNumber();
            this._editAPI.insertTable(null, rowNumber, columnNumber);
        }
    }
}

